/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class GradientBorder
extends AbstractBorder {
    static final Color COLOR_BORDER = new Color(12242416);
    static final Color COLOR_SELECTION = Color.BLUE;
    private static final int INSET_SIZE = 2;
    private static final Insets INSETS = new Insets(2, 2, 2, 2);
    private static final Color COLOR1 = new Color(221, 235, 246, 64);
    private static final Color COLOR2 = new Color(255, 255, 255, 64);
    private static final Color COLOR3 = new Color(214, 235, 255, 64);
    private static final Color COLOR4 = new Color(241, 249, 253, 64);
    private static final Color COLOR5 = new Color(255, 255, 255, 64);
    private boolean isSelected;

    public GradientBorder(boolean bl) {
        this.isSelected = bl;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        graphics2D.clip(new RoundRectangle2D.Float(n, n2, n3, n4, 4.0f, 4.0f));
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.drawGradient(graphics2D, rectangle, COLOR1, COLOR2, 0.0f, 0.3f);
        this.drawGradient(graphics2D, rectangle, COLOR2, COLOR3, 0.3f, 0.764f);
        this.drawGradient(graphics2D, rectangle, COLOR3, COLOR4, 0.764f, 0.927f);
        this.drawGradient(graphics2D, rectangle, COLOR4, COLOR5, 0.927f, 1.0f);
        graphics2D.setColor(COLOR_BORDER);
        graphics2D.draw(new RoundRectangle2D.Float((float)n + 0.5f, (float)n2 + 0.5f, n3 - 1, n4 - 1, 4.0f, 4.0f));
        if (this.isSelected) {
            graphics2D.setColor(COLOR_SELECTION);
            graphics2D.drawRect(n + 3, n2 + 3, n3 - 7, n4 - 7);
        }
        graphics2D.setClip(shape);
    }

    private void drawGradient(Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2, float f, float f2) {
        f = (float)rectangle.y + f * (float)rectangle.height;
        f2 = (float)rectangle.y + f2 * (float)rectangle.height;
        graphics2D.setPaint(new GradientPaint(rectangle.x, f, color, rectangle.x, f2, color2));
        graphics2D.fill(new Rectangle2D.Float(rectangle.x, f, rectangle.x + rectangle.width, f2));
    }

    public Insets getBorderInsets(Component component) {
        return INSETS;
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

