/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.screen.actions;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.api.screen.actions.EditDependencyPresenter;
import org.netbeans.modules.vmd.api.screen.editor.EditedScreenSupport;
import org.netbeans.modules.vmd.screen.ScreenEditorView;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DesignerEditAction
extends SystemAction {
    private boolean enabled;

    public void actionPerformed(ActionEvent actionEvent) {
        ProjectUtils.requestVisibility((DataObjectContext)ActiveViewSupport.getDefault().getActiveView().getContext(), (String)ScreenEditorView.SCREEN_EDITOR_VIEW_DISPLAY_NAME);
        this.requestComponentVisibility();
    }

    public String getName() {
        return NbBundle.getMessage(DesignerEditAction.class, (String)"NAME_EditAction");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isEnabled() {
        final DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        this.enabled = false;
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = DesignerEditAction.this.getSelectedComponent(designDocument);
                if (designComponent == null) {
                    return;
                }
                EditDependencyPresenter editDependencyPresenter = (EditDependencyPresenter)designComponent.getPresenter(EditDependencyPresenter.class);
                if (editDependencyPresenter == null) {
                    return;
                }
                DesignerEditAction.this.enabled = editDependencyPresenter.isComponentEditable();
            }
        });
        return this.enabled;
    }

    protected void requestComponentVisibility() {
        final DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                final DesignComponent designComponent = DesignerEditAction.this.getSelectedComponent(designDocument);
                if (designComponent != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            designDocument.getTransactionManager().readAccess(new Runnable(){

                                public void run() {
                                    EditedScreenSupport.getSupportForDocument(designDocument).setEditedScreenComponentID(designComponent.getComponentID());
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    protected DesignComponent getSelectedComponent(DesignDocument designDocument) {
        if (designDocument.getSelectedComponents().size() != 1) {
            return null;
        }
        DesignComponent designComponent = (DesignComponent)designDocument.getSelectedComponents().iterator().next();
        return designComponent;
    }
}

