/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.SendJMSMessageUiSupport;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.ServiceLocatorStrategyPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendJmsMessagePanel
extends JPanel {
    public static final String IS_VALID = SendJmsMessagePanel.class.getName() + ".IS_VALID";
    private final J2eeModuleProvider provider;
    private final Set<MessageDestination> moduleDestinations;
    private final Set<MessageDestination> serverDestinations;
    private final List<SendJMSMessageUiSupport.MdbHolder> mdbs;
    private final boolean isDestinationCreationSupportedByServerPlugin;
    private final ServiceLocatorStrategyPanel slPanel;
    private JButton addButton;
    private JTextField connectionFactoryTextField;
    private ButtonGroup destinationGroup;
    private JLabel destinationLabel;
    private JTextField destinationText;
    private JLabel errorLabel;
    private JLabel jLabel1;
    private JComboBox mdbCombo;
    private JRadioButton mdbRadio;
    private JComboBox projectDestinationsCombo;
    private JRadioButton projectDestinationsRadio;
    private JComboBox serverDestinationsCombo;
    private JRadioButton serverDestinationsRadio;
    private JPanel serviceLocatorPanel;

    private SendJmsMessagePanel(J2eeModuleProvider j2eeModuleProvider, Set<MessageDestination> set, Set<MessageDestination> set2, List<SendJMSMessageUiSupport.MdbHolder> list, String string, ClasspathInfo classpathInfo) {
        this.initComponents();
        this.provider = j2eeModuleProvider;
        this.moduleDestinations = set;
        this.serverDestinations = set2;
        this.mdbs = list;
        this.isDestinationCreationSupportedByServerPlugin = j2eeModuleProvider.getConfigSupport().supportsCreateMessageDestination();
        this.slPanel = new ServiceLocatorStrategyPanel(string, classpathInfo);
    }

    public static SendJmsMessagePanel newInstance(J2eeModuleProvider j2eeModuleProvider, Set<MessageDestination> set, Set<MessageDestination> set2, List<SendJMSMessageUiSupport.MdbHolder> list, String string, ClasspathInfo classpathInfo) {
        SendJmsMessagePanel sendJmsMessagePanel = new SendJmsMessagePanel(j2eeModuleProvider, set, set2, list, string, classpathInfo);
        sendJmsMessagePanel.initialize();
        sendJmsMessagePanel.verifyAndFire();
        sendJmsMessagePanel.handleConnectionFactory();
        return sendJmsMessagePanel;
    }

    public MessageDestination getDestination() {
        if (this.projectDestinationsRadio.isSelected()) {
            return (MessageDestination)this.projectDestinationsCombo.getSelectedItem();
        }
        if (this.serverDestinationsRadio.isSelected()) {
            return (MessageDestination)this.serverDestinationsCombo.getSelectedItem();
        }
        SendJMSMessageUiSupport.MdbHolder mdbHolder = (SendJMSMessageUiSupport.MdbHolder)this.mdbCombo.getSelectedItem();
        if (mdbHolder != null) {
            return mdbHolder.getMessageDestination();
        }
        return null;
    }

    public String getConnectionFactory() {
        return this.connectionFactoryTextField.getText();
    }

    public String getServiceLocator() {
        return this.slPanel.classSelected();
    }

    public Project getMdbHolderProject() {
        if (this.mdbRadio.isSelected()) {
            SendJMSMessageUiSupport.MdbHolder mdbHolder = (SendJMSMessageUiSupport.MdbHolder)this.mdbCombo.getSelectedItem();
            return mdbHolder.getProject();
        }
        return null;
    }

    private void initialize() {
        this.registerListeners();
        this.setupProjectDestinationsOption();
        this.setupMessageDrivenOption();
        this.setupErrorLabel();
        this.setupServiceLocatorPanel();
        this.handleComboBoxes();
        this.populate();
    }

    private void registerListeners() {
        this.projectDestinationsRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
                SendJmsMessagePanel.this.handleComboBoxes();
            }
        });
        this.serverDestinationsRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
                SendJmsMessagePanel.this.handleComboBoxes();
            }
        });
        this.mdbRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
                SendJmsMessagePanel.this.handleComboBoxes();
            }
        });
        this.projectDestinationsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }
        });
        this.serverDestinationsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }
        });
        this.mdbCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }
        });
        this.connectionFactoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }
        });
    }

    private void setupProjectDestinationsOption() {
        if (J2eeModule.EJB.equals(this.provider.getJ2eeModule().getModuleType())) {
            this.projectDestinationsRadio.setEnabled(true);
            this.setupAddButton();
            this.projectDestinationsRadio.setSelected(true);
        } else {
            this.projectDestinationsRadio.setEnabled(false);
            this.addButton.setEnabled(false);
            this.serverDestinationsRadio.setSelected(true);
        }
    }

    private void setupMessageDrivenOption() {
        this.mdbRadio.setEnabled(J2eeModule.EJB.equals(this.provider.getJ2eeModule().getModuleType()) || Utils.isPartOfJ2eeApp(this.provider));
    }

    private void setupAddButton() {
        if (!this.isDestinationCreationSupportedByServerPlugin) {
            this.addButton.setEnabled(false);
        }
    }

    private void handleComboBoxes() {
        this.projectDestinationsCombo.setEnabled(this.projectDestinationsRadio.isSelected());
        this.serverDestinationsCombo.setEnabled(this.serverDestinationsRadio.isSelected());
        this.mdbCombo.setEnabled(this.mdbRadio.isSelected());
        this.destinationText.setEnabled(this.mdbRadio.isSelected());
        this.handleConnectionFactory();
    }

    private void handleConnectionFactory() {
        MessageDestination messageDestination = this.getDestination();
        if (messageDestination != null) {
            this.connectionFactoryTextField.setText(messageDestination.getName() + "Factory");
        } else {
            this.connectionFactoryTextField.setText(null);
        }
    }

    private void setupErrorLabel() {
        this.setError(null);
        this.errorLabel.setForeground(this.getErrorColor());
    }

    private Color getErrorColor() {
        Color color = UIManager.getColor("nb.errorForeground");
        if (color != null) {
            return color;
        }
        return new Color(255, 0, 0);
    }

    private void setupServiceLocatorPanel() {
        this.slPanel.addPropertyChangeListener("ServiceLocatorStrategyPanel_isValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null && object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    if (bl) {
                        SendJmsMessagePanel.this.verifyAndFire();
                    } else {
                        SendJmsMessagePanel.this.firePropertyChange(IS_VALID, true, false);
                    }
                }
            }
        });
        this.serviceLocatorPanel.add((Component)this.slPanel, "Center");
    }

    private void populate() {
        SendJMSMessageUiSupport.populateDestinations(this.moduleDestinations, this.projectDestinationsCombo, null);
        SendJMSMessageUiSupport.populateDestinations(this.serverDestinations, this.serverDestinationsCombo, null);
        SendJMSMessageUiSupport.populateMessageDrivenBeans(this.mdbs, this.mdbCombo, this.destinationText);
    }

    void verifyAndFire() {
        boolean bl = this.verifyComponents();
        this.firePropertyChange(IS_VALID, !bl, bl);
    }

    private boolean verifyComponents() {
        if (this.destinationGroup.getSelection() == null || this.getDestination() == null) {
            this.setError("ERR_NoDestinationSelected");
            return false;
        }
        if ("".equals(this.getConnectionFactory().trim())) {
            this.setError("ERR_NoConnectionFactorySelected");
            return false;
        }
        this.setError(null);
        return true;
    }

    private void setError(String string) {
        if (string == null) {
            this.errorLabel.setText("");
            return;
        }
        this.errorLabel.setText(NbBundle.getMessage(SendJmsMessagePanel.class, (String)string));
    }

    private void initComponents() {
        this.destinationGroup = new ButtonGroup();
        this.projectDestinationsRadio = new JRadioButton();
        this.serverDestinationsRadio = new JRadioButton();
        this.projectDestinationsCombo = new JComboBox();
        this.serverDestinationsCombo = new JComboBox();
        this.addButton = new JButton();
        this.mdbRadio = new JRadioButton();
        this.mdbCombo = new JComboBox();
        this.serviceLocatorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.destinationLabel = new JLabel();
        this.destinationText = new JTextField();
        this.jLabel1 = new JLabel();
        this.connectionFactoryTextField = new JTextField();
        this.destinationGroup.add(this.projectDestinationsRadio);
        this.projectDestinationsRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.projectDestinationsRadio, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_ProjectDestinations"));
        this.projectDestinationsRadio.setMargin(new Insets(0, 0, 0, 0));
        this.destinationGroup.add(this.serverDestinationsRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.serverDestinationsRadio, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_ServerDestinations"));
        this.serverDestinationsRadio.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.destinationGroup.add(this.mdbRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.mdbRadio, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_MessageDrivenBean"));
        this.mdbRadio.setMargin(new Insets(0, 0, 0, 0));
        this.serviceLocatorPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ERR_NoDestinationSelected"));
        Mnemonics.setLocalizedText((JLabel)this.destinationLabel, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_Destination"));
        this.destinationText.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"Connection Factory:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.serviceLocatorPanel, -1, 540, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectDestinationsRadio).add((Component)this.serverDestinationsRadio).add((Component)this.mdbRadio).add(2, (Component)this.destinationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.destinationText, -1, 321, Short.MAX_VALUE).add(2, (Component)this.mdbCombo, 0, 321, Short.MAX_VALUE).add(2, (Component)this.serverDestinationsCombo, 0, 321, Short.MAX_VALUE).add(2, (Component)this.projectDestinationsCombo, 0, 321, Short.MAX_VALUE).add((Component)this.connectionFactoryTextField, -1, 321, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.addButton).addContainerGap()).add((Component)this.jLabel1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.errorLabel, -1, 540, Short.MAX_VALUE).addContainerGap()))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectDestinationsRadio).add((Component)this.addButton).add((Component)this.projectDestinationsCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serverDestinationsRadio).add((Component)this.serverDestinationsCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.mdbRadio).add((Component)this.mdbCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.destinationLabel).add((Component)this.destinationText, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.connectionFactoryTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.serviceLocatorPanel, -2, -1, -2).addPreferredGap(1).add((Component)this.errorLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.projectDestinationsRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_JMSProjectDestination"));
        this.serverDestinationsRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_JMSServerDestination"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_AddMessageDestination"));
        this.mdbRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_JMSMessageDestination"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_SendJMSMessage"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_SendJMSMessage"));
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        MessageDestination messageDestination = SendJMSMessageUiSupport.createMessageDestination(this.provider, this.moduleDestinations, this.serverDestinations);
        if (messageDestination != null) {
            this.moduleDestinations.add(messageDestination);
            SendJMSMessageUiSupport.populateDestinations(this.moduleDestinations, this.projectDestinationsCombo, messageDestination);
        }
    }
}

