/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageDestinationUiSupport;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SendJMSMessageUiSupport
extends MessageDestinationUiSupport {
    public static List<MdbHolder> getMdbs() {
        Project[] projectArray;
        ArrayList<MdbHolder> arrayList = new ArrayList<MdbHolder>();
        for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
            if (EjbJar.getEjbJars((Project)project).length <= 0) continue;
            try {
                Map<String, String> map = SendJMSMessageUiSupport.getMdbs(project);
                SendJMSMessageUiSupport.populateMdbs(arrayList, map, project);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return arrayList;
    }

    public static void populateMessageDrivenBeans(List<MdbHolder> list, JComboBox jComboBox, final JTextField jTextField) {
        assert (list != null);
        assert (jComboBox != null);
        assert (jTextField != null);
        jComboBox.setRenderer(new MdbHolderListCellRenderer());
        ArrayList<MdbHolder> arrayList = new ArrayList<MdbHolder>(list);
        Collections.sort(arrayList, new MdbHolderComparator());
        jComboBox.removeAllItems();
        jTextField.setText("");
        for (MdbHolder mdbHolder : arrayList) {
            jComboBox.addItem(mdbHolder);
        }
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendJMSMessageUiSupport.populateMdbTextField((JComboBox)actionEvent.getSource(), jTextField);
            }
        });
        SendJMSMessageUiSupport.populateMdbTextField(jComboBox, jTextField);
    }

    private static void populateMdbTextField(JComboBox jComboBox, JTextField jTextField) {
        MdbHolder mdbHolder = (MdbHolder)jComboBox.getSelectedItem();
        if (mdbHolder != null) {
            jTextField.setText(mdbHolder.getMessageDestination().getName());
        }
    }

    private static void populateMdbs(List<MdbHolder> list, Map<String, String> map, Project project) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            J2eeModuleProvider j2eeModuleProvider = SendJMSMessageUiSupport.getJ2eeModuleProvider(project);
            try {
                MessageDestination messageDestination = null;
                String string = entry.getKey();
                String string2 = entry.getValue();
                String string3 = j2eeModuleProvider.getConfigSupport().findMessageDestinationName(string);
                if (string3 == null && string2 != null) {
                    string3 = string2;
                }
                if (string3 == null) continue;
                messageDestination = j2eeModuleProvider.getConfigSupport().findMessageDestination(string3);
                list.add(new MdbHolder(string, messageDestination, project));
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
    }

    private static J2eeModuleProvider getJ2eeModuleProvider(Project project) {
        return (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
    }

    private static Map<String, String> getMdbs(Project project) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (EjbJar ejbJar : EjbJar.getEjbJars((Project)project)) {
            MetadataModel metadataModel = ejbJar.getMetadataModel();
            Map map = (Map)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Map<String, String>>(){

                public Map<String, String> run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    MessageDriven[] messageDrivenArray;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    EnterpriseBeans enterpriseBeans = ejbJarMetadata.getRoot().getEnterpriseBeans();
                    if (enterpriseBeans == null) {
                        return Collections.emptyMap();
                    }
                    for (MessageDriven messageDriven : messageDrivenArray = enterpriseBeans.getMessageDriven()) {
                        hashMap.put(messageDriven.getEjbName(), messageDriven.getMappedName());
                    }
                    return hashMap;
                }
            });
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private static class MdbHolderListCellRenderer
    extends DefaultListCellRenderer {
        private MdbHolderListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof MdbHolder) {
                MdbHolder mdbHolder = (MdbHolder)object;
                this.setText(mdbHolder.getMdbEjbName());
                String string = MessageDestination.Type.QUEUE.equals((Object)mdbHolder.getMessageDestination().getType()) ? "LBL_Queue" : "LBL_Topic";
                StringBuilder stringBuilder = new StringBuilder(mdbHolder.getProjectName());
                stringBuilder.append(" : ");
                stringBuilder.append(mdbHolder.getMdbEjbName());
                stringBuilder.append(" [");
                stringBuilder.append(NbBundle.getMessage(MessageDestinationUiSupport.class, (String)string));
                stringBuilder.append("]");
                this.setToolTipText(stringBuilder.toString());
            } else {
                this.setText(object != null ? object.toString() : "");
                this.setToolTipText("");
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MdbHolderComparator
    implements Comparator<MdbHolder> {
        private MdbHolderComparator() {
        }

        @Override
        public int compare(MdbHolder mdbHolder, MdbHolder mdbHolder2) {
            if (mdbHolder == null) {
                return mdbHolder2 == null ? 0 : -1;
            }
            if (mdbHolder2 == null) {
                return 1;
            }
            String string = mdbHolder.getMdbEjbName();
            String string2 = mdbHolder2.getMdbEjbName();
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            return string2 == null ? 1 : string.compareToIgnoreCase(string2);
        }
    }

    public static class MdbHolder {
        private final String mdbEjbName;
        private final MessageDestination messageDestination;
        private final Project project;

        public MdbHolder(String string, MessageDestination messageDestination, Project project) {
            assert (string != null);
            assert (messageDestination != null);
            assert (project != null);
            this.mdbEjbName = string;
            this.messageDestination = messageDestination;
            this.project = project;
        }

        public MessageDestination getMessageDestination() {
            return this.messageDestination;
        }

        public Project getProject() {
            return this.project;
        }

        public String getMdbEjbName() {
            return this.mdbEjbName;
        }

        public String getProjectName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append(" [");
            stringBuilder.append(this.getMdbEjbName());
            stringBuilder.append(" (");
            stringBuilder.append(this.getMessageDestination().getType().toString());
            stringBuilder.append("), ");
            stringBuilder.append(this.getProjectName());
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

