/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodViewStrategy;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentMethodModel
extends Children.Keys<MethodModel> {
    private final ClasspathInfo cpInfo;
    private final String homeInterface;
    private Collection<String> interfaces;
    private String implBean;
    private final ClassIndexListener classIndexListener;

    public ComponentMethodModel(ClasspathInfo classpathInfo, String string, Collection<String> collection, String string2) {
        this.cpInfo = classpathInfo;
        this.homeInterface = string2;
        this.implBean = string;
        this.interfaces = collection;
        this.classIndexListener = new ClassIndexListenerImpl();
    }

    private void updateKeys() {
        ComponentMethodViewStrategy componentMethodViewStrategy = this.createViewStrategy();
        final ArrayList arrayList = new ArrayList();
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    Elements elements = compilationController.getElements();
                    final ElementUtilities elementUtilities = compilationController.getElementUtilities();
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    for (String string : ComponentMethodModel.this.getInterfaces()) {
                        Object object;
                        TypeElement typeElement = elements.getTypeElement(string);
                        if (typeElement == null) continue;
                        if (string.equals(ComponentMethodModel.this.homeInterface)) {
                            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                                object = MethodModelSupport.createMethodModel((CompilationController)compilationController, (ExecutableElement)executableElement);
                                arrayList.add(object);
                            }
                            continue;
                        }
                        Iterable iterable = elementUtilities.getMembers(typeElement.asType(), new ElementUtilities.ElementAcceptor(){

                            public boolean accept(Element element, TypeMirror typeMirror) {
                                TypeElement typeElement = elementUtilities.enclosingTypeElement(element);
                                boolean bl = ElementKind.INTERFACE == typeElement.getKind();
                                boolean bl2 = typeElement.getQualifiedName().toString().startsWith("javax.ejb.");
                                return bl && !bl2 && ElementKind.METHOD == element.getKind();
                            }
                        });
                        Iterator iterator = iterable.iterator();
                        while (iterator.hasNext()) {
                            object = (Element)iterator.next();
                            MethodModel methodModel = MethodModelSupport.createMethodModel((CompilationController)compilationController, (ExecutableElement)((ExecutableElement)object));
                            arrayList.add(methodModel);
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentMethodModel.this.setKeys(arrayList);
            }
        });
    }

    protected void addNotify() {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces();
        }
        assert (this.interfaces != null);
        if (this.implBean == null) {
            this.implBean = this.getImplBean();
        }
        super.addNotify();
        this.registerListeners();
        this.updateKeys();
    }

    private void registerListeners() {
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex classIndex = compilationController.getClasspathInfo().getClassIndex();
                    classIndex.addClassIndexListener(ComponentMethodModel.this.classIndexListener);
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void removeListeners() {
        if (this.interfaces == null) {
            return;
        }
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex classIndex = compilationController.getClasspathInfo().getClassIndex();
                    classIndex.removeClassIndexListener(ComponentMethodModel.this.classIndexListener);
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected void removeNotify() {
        if (this.interfaces == null) {
            return;
        }
        this.setKeys(Collections.emptySet());
        this.removeListeners();
        super.removeNotify();
    }

    protected Collection<String> getInterfaces() {
        return null;
    }

    protected String getImplBean() {
        return null;
    }

    public abstract ComponentMethodViewStrategy createViewStrategy();

    protected Node[] createNodes(MethodModel methodModel) {
        ComponentMethodViewStrategy componentMethodViewStrategy = this.createViewStrategy();
        return new Node[]{new MethodNode(this.cpInfo, methodModel, this.implBean, this.getInterfaces(), componentMethodViewStrategy)};
    }

    private class ClassIndexListenerImpl
    implements ClassIndexListener {
        private ClassIndexListenerImpl() {
        }

        public void typesAdded(TypesEvent typesEvent) {
            this.handleTypes(typesEvent);
        }

        public void typesRemoved(TypesEvent typesEvent) {
            this.handleTypes(typesEvent);
        }

        public void typesChanged(TypesEvent typesEvent) {
            this.handleTypes(typesEvent);
        }

        public void rootsAdded(RootsEvent rootsEvent) {
        }

        public void rootsRemoved(RootsEvent rootsEvent) {
        }

        private void handleTypes(TypesEvent typesEvent) {
            for (ElementHandle elementHandle : typesEvent.getTypes()) {
                if (!ComponentMethodModel.this.interfaces.contains(elementHandle.getQualifiedName())) continue;
                ComponentMethodModel.this.updateKeys();
                return;
            }
        }
    }
}

