/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FieldBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private FieldBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JPanel cPanel;
    private JComboBox cbBreakpointType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfClassName;
    private JTextField tfFieldName;

    private static FieldBreakpoint creteBreakpoint() {
        String string;
        String string2;
        try {
            string2 = EditorContextBridge.getContext().getCurrentClassName();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            string2 = "";
        }
        try {
            string = EditorContextBridge.getContext().getCurrentFieldName();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            string = "";
        }
        FieldBreakpoint fieldBreakpoint = FieldBreakpoint.create((String)string2, (String)string, (int)1);
        fieldBreakpoint.setPrintText(NbBundle.getBundle(FieldBreakpointPanel.class).getString("CTL_Field_Breakpoint_Print_Text"));
        return fieldBreakpoint;
    }

    public FieldBreakpointPanel() {
        this(FieldBreakpointPanel.creteBreakpoint());
        this.createBreakpoint = true;
    }

    public FieldBreakpointPanel(FieldBreakpoint fieldBreakpoint) {
        this.breakpoint = fieldBreakpoint;
        this.initComponents();
        String string = fieldBreakpoint.getClassName();
        this.tfClassName.setText(string);
        this.tfFieldName.setText(fieldBreakpoint.getFieldName());
        this.cbBreakpointType.addItem(NbBundle.getMessage(FieldBreakpointPanel.class, (String)"LBL_Field_Breakpoint_Type_Access"));
        this.cbBreakpointType.addItem(NbBundle.getMessage(FieldBreakpointPanel.class, (String)"LBL_Field_Breakpoint_Type_Modification"));
        this.cbBreakpointType.addItem(NbBundle.getMessage(FieldBreakpointPanel.class, (String)"LBL_Field_Breakpoint_Type_Access_or_Modification"));
        switch (fieldBreakpoint.getBreakpointType()) {
            case 1: {
                this.cbBreakpointType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.cbBreakpointType.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.cbBreakpointType.setSelectedIndex(2);
            }
        }
        this.conditionsPanel = new ConditionsPanel();
        this.conditionsPanel.showClassFilter(false);
        this.conditionsPanel.setCondition(fieldBreakpoint.getCondition());
        this.conditionsPanel.setHitCountFilteringStyle(fieldBreakpoint.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(fieldBreakpoint.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)fieldBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", "debug.add.breakpoint.java.field");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointFieldJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.tfClassName = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfFieldName = new JTextField();
        this.jLabel4 = new JLabel();
        this.cbBreakpointType = new JComboBox();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Field_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.tfClassName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("L_Field_Breakpoint_Class_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Field_Breakpoint_Class_Name"));
        this.tfClassName.setToolTipText(resourceBundle.getString("TTT_TF_Field_Breakpoint_Class_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfClassName, gridBagConstraints);
        this.tfClassName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Field_Breakpoint_Class_Name"));
        this.jLabel1.setLabelFor(this.tfFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("L_Field_Breakpoint_Field_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Field_Breakpoint_Field_Name"));
        this.tfFieldName.setToolTipText(resourceBundle.getString("TTT_TF_Field_Breakpoint_Field_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFieldName, gridBagConstraints);
        this.tfFieldName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Field_Breakpoint_Field_Name"));
        this.jLabel4.setLabelFor(this.cbBreakpointType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)resourceBundle.getString("L_Field_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Field_Breakpoint_Type"));
        this.cbBreakpointType.setToolTipText(resourceBundle.getString("TTT_CB_Field_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbBreakpointType, gridBagConstraints);
        this.cbBreakpointType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CB_Field_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldBreakpointPanel.class, (String)"ACSN_FieldBreakpoint"));
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string == null) {
            string = this.conditionsPanel.valiadateMsg();
        }
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.actionsPanel.ok();
        String string2 = this.tfClassName.getText().trim();
        this.breakpoint.setClassName(string2);
        this.breakpoint.setFieldName(this.tfFieldName.getText().trim());
        switch (this.cbBreakpointType.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setBreakpointType(1);
                break;
            }
            case 1: {
                this.breakpoint.setBreakpointType(2);
                break;
            }
            case 2: {
                this.breakpoint.setBreakpointType(3);
            }
        }
        this.breakpoint.setCondition(this.conditionsPanel.getCondition());
        this.breakpoint.setHitCountFilter(this.conditionsPanel.getHitCount(), this.conditionsPanel.getHitCountFilteringStyle());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String valiadateMsg() {
        if (this.tfClassName.getText().trim().length() == 0 || this.tfFieldName.getText().trim().length() == 0) {
            return NbBundle.getMessage(FieldBreakpointPanel.class, (String)"MSG_No_Class_or_Field_Name_Spec");
        }
        return null;
    }
}

