/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClassBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private ClassLoadUnloadBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JPanel cPanel;
    private JComboBox cbBreakpointType;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfClassName;

    private static ClassLoadUnloadBreakpoint creteBreakpoint() {
        String string;
        try {
            string = EditorContextBridge.getContext().getCurrentClassName();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            string = "";
        }
        ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = ClassLoadUnloadBreakpoint.create((String)string, (boolean)false, (int)3);
        classLoadUnloadBreakpoint.setPrintText(NbBundle.getBundle(ClassBreakpointPanel.class).getString("CTL_Class_Breakpoint_Print_Text"));
        return classLoadUnloadBreakpoint;
    }

    public ClassBreakpointPanel() {
        this(ClassBreakpointPanel.creteBreakpoint());
        this.createBreakpoint = true;
    }

    public ClassBreakpointPanel(ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint) {
        this.breakpoint = classLoadUnloadBreakpoint;
        this.initComponents();
        String[] stringArray = classLoadUnloadBreakpoint.getClassFilters();
        this.tfClassName.setText(ClassBreakpointPanel.concatClassFilters(stringArray));
        this.cbBreakpointType.addItem(NbBundle.getMessage(ClassBreakpointPanel.class, (String)"LBL_Class_Breakpoint_Type_Prepare"));
        this.cbBreakpointType.addItem(NbBundle.getMessage(ClassBreakpointPanel.class, (String)"LBL_Class_Breakpoint_Type_Unload"));
        this.cbBreakpointType.addItem(NbBundle.getMessage(ClassBreakpointPanel.class, (String)"LBL_Class_Breakpoint_Type_Prepare_or_Unload"));
        switch (classLoadUnloadBreakpoint.getBreakpointType()) {
            case 1: {
                this.cbBreakpointType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.cbBreakpointType.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.cbBreakpointType.setSelectedIndex(2);
            }
        }
        this.conditionsPanel = new ConditionsPanel();
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.conditionsPanel.showExclusionClassFilter(true);
        this.conditionsPanel.showCondition(false);
        this.conditionsPanel.setClassExcludeFilter(classLoadUnloadBreakpoint.getClassExclusionFilters());
        this.conditionsPanel.setHitCountFilteringStyle(classLoadUnloadBreakpoint.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(classLoadUnloadBreakpoint.getHitCountFilter());
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)classLoadUnloadBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", "debug.add.breakpoint.java.class");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointClassJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.tfClassName = new JTextField();
        this.jLabel4 = new JLabel();
        this.cbBreakpointType = new JComboBox();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Class_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.tfClassName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("L_Class_Breakpoint_Class_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Class_Breakpoint_Class_Name"));
        this.tfClassName.setToolTipText(resourceBundle.getString("TTT_TF_Class_Breakpoint_Class_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfClassName, gridBagConstraints);
        this.tfClassName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Class_Breakpoint_Class_Name"));
        this.jLabel4.setLabelFor(this.cbBreakpointType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)resourceBundle.getString("L_Class_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ASCD_L_Class_Breakpoint_Type"));
        this.cbBreakpointType.setToolTipText(resourceBundle.getString("TTT_CB_Class_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbBreakpointType, gridBagConstraints);
        this.cbBreakpointType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CB_Class_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string == null) {
            string = this.conditionsPanel.valiadateMsg();
        }
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.actionsPanel.ok();
        String string2 = this.tfClassName.getText().trim();
        this.breakpoint.setClassFilters(ClassBreakpointPanel.parseClassFilters(string2));
        this.breakpoint.setClassExclusionFilters(this.conditionsPanel.getClassExcludeFilter());
        switch (this.cbBreakpointType.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setBreakpointType(1);
                break;
            }
            case 1: {
                this.breakpoint.setBreakpointType(2);
                break;
            }
            case 2: {
                this.breakpoint.setBreakpointType(3);
            }
        }
        this.breakpoint.setHitCountFilter(this.conditionsPanel.getHitCount(), this.conditionsPanel.getHitCountFilteringStyle());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String valiadateMsg() {
        if (this.tfClassName.getText().trim().length() == 0) {
            return NbBundle.getMessage(ClassBreakpointPanel.class, (String)"MSG_No_Class_Name_Spec");
        }
        return null;
    }

    static String concatClassFilters(String[] stringArray) {
        if (stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(stringArray[i]);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    static String[] parseClassFilters(String string) {
        int n = 1;
        int n2 = string.length();
        if (n2 == 0) {
            return new String[0];
        }
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n];
        if (n == 1) {
            stringArray[0] = string;
        } else {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = string.indexOf(",");
                if (n5 < 0) {
                    n5 = n2;
                }
                stringArray[n3] = string.substring(n4, n5).trim();
                ++n3;
                n4 = n5 + 1;
            }
        }
        return stringArray;
    }
}

