/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class FixedWatchesManager
implements TreeModelFilter,
NodeActionsProviderFilter,
ExtendedNodeModelFilter,
TableModelFilter {
    public static final String FIXED_WATCH = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch.gif";
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(FixedWatchesManager.class).getString("CTL_DeleteFixedWatch_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return !WatchesNodeModel.isEmptyWatch(object);
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                FixedWatchesManager.this.fixedWatches.remove(objectArray[i]);
            }
            FixedWatchesManager.this.fireModelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)FixedWatchesManager.this, (Object)"Root", 8));
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action CREATE_FIXED_WATCH_ACTION;
    private Map fixedWatches;
    private HashSet listeners;
    private ContextProvider contextProvider;

    public FixedWatchesManager(ContextProvider contextProvider) {
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.CREATE_FIXED_WATCH_ACTION = Models.createAction((String)NbBundle.getBundle(FixedWatchesManager.class).getString("CTL_CreateFixedWatch_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return !WatchesNodeModel.isEmptyWatch(object) && !this.isPrimitive(object);
            }

            public void perform(Object[] objectArray) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    FixedWatchesManager.this.createFixedWatch(objectArray[i]);
                }
            }

            private boolean isPrimitive(Object object) {
                if (!(object instanceof Variable)) {
                    return false;
                }
                Variable variable = (Variable)object;
                if (!VariablesTreeModelFilter.isEvaluated(variable)) {
                    return false;
                }
                String string = variable.getType();
                return "".equals(string) || "boolean".equals(string) || "byte".equals(string) || "char".equals(string) || "short".equals(string) || "int".equals(string) || "long".equals(string) || "float".equals(string) || "double".equals(string);
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
        this.fixedWatches = new LinkedHashMap();
        this.contextProvider = contextProvider;
    }

    public Object getRoot(TreeModel treeModel) {
        return treeModel.getRoot();
    }

    public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            if (this.fixedWatches.size() == 0) {
                return treeModel.getChildren(object, n, n2);
            }
            int n3 = this.fixedWatches.size();
            int n4 = n - n3;
            int n5 = n2 - n3;
            if (n4 < 0) {
                n4 = 0;
            }
            Object[] objectArray = n5 > n4 ? treeModel.getChildren(object, n4, n5) : new Object[]{};
            Object[] objectArray2 = new Object[objectArray.length + n3];
            this.fixedWatches.keySet().toArray(objectArray2);
            System.arraycopy(objectArray, 0, objectArray2, n3, objectArray.length);
            if (n > 0 || n2 < objectArray2.length) {
                if (n2 > objectArray2.length) {
                    n2 = objectArray2.length;
                }
                Object[] objectArray3 = new Object[n2 - n];
                System.arraycopy(objectArray2, n, objectArray3, 0, n2 - n);
                return objectArray3;
            }
            return objectArray2;
        }
        return treeModel.getChildren(object, n, n2);
    }

    public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object == "Root") {
            int n = treeModel.getChildrenCount(object);
            if (n < Integer.MAX_VALUE) {
                n += this.fixedWatches.size();
            }
            return n;
        }
        return treeModel.getChildrenCount(object);
    }

    public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
        return treeModel.isLeaf(object);
    }

    public synchronized void addModelListener(ModelListener modelListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(modelListener);
    }

    public synchronized void removeModelListener(ModelListener modelListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(modelListener);
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        Action[] actionArray = nodeActionsProvider.getActions(object);
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (this.fixedWatches.containsKey(object)) {
            return new Action[]{this.DELETE_ACTION};
        }
        if (object instanceof Variable) {
            arrayList.add(this.CREATE_FIXED_WATCH_ACTION);
        } else if (object instanceof JPDAWatch) {
            arrayList.add(this.CREATE_FIXED_WATCH_ACTION);
        } else {
            return actionArray;
        }
        arrayList.addAll(Arrays.asList(actionArray));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(object)) {
            return (String)this.fixedWatches.get(object);
        }
        return nodeModel.getDisplayName(object);
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getShortDescription(object);
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getIconBase(object);
    }

    private void createFixedWatch(Object object) {
        if (object instanceof JPDAWatch) {
            JPDAWatch jPDAWatch = (JPDAWatch)object;
            this.addFixedWatch(jPDAWatch.getExpression(), (Variable)jPDAWatch);
        } else {
            Variable variable = (Variable)object;
            String string = null;
            string = variable instanceof LocalVariable ? ((LocalVariable)variable).getName() : (variable instanceof Field ? ((Field)variable).getName() : (variable instanceof This ? "this" : (variable instanceof ObjectVariable ? "object" : "unnamed")));
            this.addFixedWatch(string, variable);
        }
    }

    private void addFixedWatch(String string, Variable variable) {
        if (variable instanceof Cloneable) {
            try {
                Method method = variable.getClass().getMethod("clone", new Class[0]);
                method.setAccessible(true);
                Object object = method.invoke((Object)variable, new Object[0]);
                if (object instanceof Variable) {
                    variable = (Variable)object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fixedWatches.put(variable, string);
        this.fireModelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChanged(ModelEvent modelEvent) {
        HashSet hashSet;
        FixedWatchesManager fixedWatchesManager = this;
        synchronized (fixedWatchesManager) {
            if (this.listeners == null) {
                return;
            }
            hashSet = new HashSet(this.listeners);
        }
        for (ModelListener modelListener : hashSet) {
            modelListener.modelChanged(modelEvent);
        }
    }

    public boolean canRename(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canRename(object);
    }

    public boolean canCopy(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canCopy(object);
    }

    public boolean canCut(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canCut(object);
    }

    public Transferable clipboardCopy(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        return extendedNodeModel.clipboardCopy(object);
    }

    public Transferable clipboardCut(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        return extendedNodeModel.clipboardCut(object);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel extendedNodeModel, Object object, Transferable transferable) throws UnknownTypeException {
        return extendedNodeModel.getPasteTypes(object, transferable);
    }

    public void setName(ExtendedNodeModel extendedNodeModel, Object object, String string) throws UnknownTypeException {
        extendedNodeModel.setName(object, string);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(object)) {
            return FIXED_WATCH;
        }
        return extendedNodeModel.getIconBaseWithExtension(object);
    }

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        return tableModel.getValueAt(object, string);
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(object)) {
            return true;
        }
        return tableModel.isReadOnly(object, string);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        tableModel.setValueAt(object, string, object2);
    }
}

