/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.Evaluator;
import org.netbeans.modules.web.wizards.FileType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;

class TargetEvaluator
extends Evaluator {
    private final boolean debug = false;
    private ArrayList pathItems = null;
    private DeployData deployData = null;
    private String errorMessage = null;
    private String fileName;
    private boolean initialized = false;
    private String className;

    TargetEvaluator(FileType fileType, DeployData deployData) {
        super(fileType);
        this.deployData = deployData;
    }

    String getErrorMessage() {
        if (this.errorMessage == null) {
            return "";
        }
        return this.errorMessage;
    }

    DeployData getDeployData() {
        return this.deployData;
    }

    String getClassName() {
        return this.className;
    }

    void setClassName(String string, String string2) {
        this.className = string2.length() > 0 ? string2 + "." + string : string;
        this.fileName = string;
    }

    String getFileName() {
        return this.fileName;
    }

    Iterator getPathItems() {
        return this.pathItems.iterator();
    }

    String getTargetPath() {
        return super.getTargetPath(this.pathItems.iterator());
    }

    void setInitialFolder(DataFolder dataFolder, Project project) {
        if (dataFolder == null) {
            return;
        }
        FileObject fileObject = dataFolder.getPrimaryFile();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        String string = null;
        for (int i = 0; i < sourceGroupArray.length && string == null; ++i) {
            string = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
            this.deployData.setWebApp(DeployData.getWebAppFor(sourceGroupArray[i].getRootFolder()));
        }
        if (string == null) {
            string = "";
        }
        this.setInitialPath(string);
    }

    boolean isValid() {
        return true;
    }

    private void setInitialPath(String string) {
        this.pathItems = new ArrayList();
        String[] stringArray = string.split("/");
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("")) continue;
                this.pathItems.add(stringArray[i]);
            }
        }
    }

    private static void log(String string) {
        System.out.println("TargetEvaluator" + string);
    }

    private void setAlternativeName(String string, FileObject fileObject) {
        int n = 0;
        String string2 = string;
        boolean bl = false;
        while (!bl) {
            this.pathItems.remove(string2);
            string2 = string.concat("_").concat(String.valueOf(++n));
            this.pathItems.add(string2);
            try {
                this.checkFile(this.pathItems.iterator(), fileObject);
                bl = true;
                this.fileName = string2;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
    }
}

