/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.DDTable;
import org.netbeans.modules.web.wizards.Editable;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.TableRowDialog;
import org.openide.util.NbBundle;

class InitParamPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final String ADD = "add";
    private static final String EDIT = "edit";
    private static final String REMOVE = "remove";
    private ServletData deployData;
    private BaseWizardPanel parent;
    private boolean edited = false;
    private JLabel jLinitparams;
    private DDTable table;
    private JButton jBnew;
    private JButton jBedit;
    private JButton jBdelete;
    private JScrollPane scrollP;
    private static final boolean debug = false;
    private static final long serialVersionUID = -5803905591685582710L;

    public InitParamPanel(ServletData servletData, BaseWizardPanel baseWizardPanel) {
        this.deployData = servletData;
        this.parent = baseWizardPanel;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 60);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(4, 20, 4, 60);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridheight = 4;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 0.9;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(4, 0, 4, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = -1;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.insets = new Insets(4, 0, 4, 0);
        this.jLinitparams = new JLabel(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_initparamsL"));
        this.jLinitparams.setDisplayedMnemonic(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_initparams_mnemonic").charAt(0));
        this.add((Component)this.jLinitparams, gridBagConstraints);
        String[] stringArray = new String[]{"paramname", "paramvalue"};
        this.table = new DDTable(stringArray, "LBL_initparams", Editable.BOTH);
        this.jLinitparams.setLabelFor(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparams_desc"));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparams"));
        this.table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                InitParamPanel.this.updateInitParams();
            }
        });
        this.scrollP = new JScrollPane(this.table);
        this.add((Component)this.scrollP, gridBagConstraints3);
        this.jBnew = new JButton();
        this.jBnew.setText(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_new"));
        this.jBnew.setMnemonic(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_new_mnemonic").charAt(0));
        this.jBnew.addActionListener(this);
        this.jBnew.setActionCommand(ADD);
        this.jBnew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparam_new"));
        this.add((Component)this.jBnew, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this.jBedit = new JButton();
        this.jBedit.setText(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_edit"));
        this.jBedit.setMnemonic(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_edit_mnemonic").charAt(0));
        this.jBedit.addActionListener(this);
        this.jBedit.setActionCommand(EDIT);
        this.jBedit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparam_edit"));
        this.jBedit.setEnabled(false);
        this.add((Component)this.jBedit, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this.jBdelete = new JButton();
        this.jBdelete.setText(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_delete"));
        this.jBdelete.setMnemonic(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_delete_mnemonic").charAt(0));
        this.jBdelete.addActionListener(this);
        this.jBdelete.setActionCommand(REMOVE);
        this.jBdelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparam_delete"));
        this.jBdelete.setEnabled(false);
        this.add((Component)this.jBdelete, gridBagConstraints2);
        this.add((Component)new JPanel(), gridBagConstraints4);
    }

    public void setEnabled() {
        boolean bl = this.deployData.makeEntry();
        this.jLinitparams.setEnabled(bl);
        this.jBnew.setEnabled(bl);
        if (bl) {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) {
                this.jBdelete.setEnabled(false);
                this.jBedit.setEnabled(false);
            } else {
                this.jBdelete.setEnabled(true);
                this.jBedit.setEnabled(true);
            }
        } else {
            this.jBdelete.setEnabled(false);
            this.jBedit.setEnabled(false);
        }
        this.table.setEditable(bl ? Editable.BOTH : Editable.NEITHER);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = -1;
        if (actionEvent.getSource() instanceof JButton) {
            if (actionEvent.getActionCommand() == ADD) {
                String[] stringArray = new String[]{NbBundle.getMessage(InitParamPanel.class, (String)"LBL_paramname"), NbBundle.getMessage(InitParamPanel.class, (String)"LBL_paramvalue")};
                n = this.table.addRow(stringArray);
                this.table.setRowSelectionInterval(n, n);
            } else if (actionEvent.getActionCommand() == REMOVE) {
                n = this.table.getSelectedRow();
                this.table.removeRow(n);
                this.setEnabled();
            } else if (actionEvent.getActionCommand() == EDIT) {
                n = this.table.getSelectedRow();
                String string = (String)this.table.getValueAt(n, 0);
                String string2 = (String)this.table.getValueAt(n, 1);
                String string3 = NbBundle.getMessage(DDTable.class, (String)"LBL_initparams_edit");
                TableRowDialog tableRowDialog = new TableRowDialog(string, string2, Editable.BOTH, TableRowDialog.Condition.NONE, string3);
                tableRowDialog.showDialog();
                if (tableRowDialog.getDialogOK()) {
                    this.table.setData(tableRowDialog.getName(), tableRowDialog.getValue(), n);
                } else {
                    this.table.setData(string, string2, n);
                }
            }
            this.scrollP.revalidate();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.setEnabled();
        this.updateInitParams();
    }

    private void updateInitParams() {
        this.edited = true;
        if (this.deployData.makeEntry()) {
            int n = this.table.getRowCount();
            String[][] stringArray = new String[n][2];
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                stringArray[i][0] = (String)this.table.getModel().getValueAt(i, 0);
                if (stringArray[i][0].length() == 0) {
                    bl = false;
                }
                stringArray[i][1] = (String)this.table.getModel().getValueAt(i, 1);
            }
            this.deployData.setInitParams(stringArray, bl);
            this.parent.fireChangeEvent();
        }
    }

    private void log(String string) {
        System.out.println("InitParamPanel" + string);
    }
}

