/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.wizards.FileType;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

abstract class Evaluator {
    private FileType fileType = null;
    private static final boolean debug = false;

    Evaluator(FileType fileType) {
        this.fileType = fileType;
    }

    abstract boolean isValid();

    abstract String getTargetPath();

    abstract String getErrorMessage();

    abstract Iterator getPathItems();

    abstract void setInitialFolder(DataFolder var1, Project var2);

    FileType getFileType() {
        return this.fileType;
    }

    String getTargetPath(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(".");
        stringBuffer.append(this.fileType.getSuffix());
        return stringBuffer.toString();
    }

    void checkFile(Iterator iterator, FileObject fileObject) throws IOException {
        FileObject fileObject2 = fileObject;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (iterator.hasNext()) {
                try {
                    fileObject2 = fileObject2.getFileObject(string, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IOException(NbBundle.getMessage(Evaluator.class, (String)"MSG_clash_path", (Object)string));
                }
                if (fileObject2 == null) {
                    return;
                }
                if (fileObject2.isFolder()) continue;
                throw new IOException(NbBundle.getMessage(Evaluator.class, (String)"MSG_clash_path", (Object)string));
            }
            try {
                fileObject2 = fileObject2.getFileObject(string, this.fileType.getSuffix());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(NbBundle.getMessage(Evaluator.class, (String)"MSG_clash_path", (Object)string));
            }
            if (fileObject2 == null) {
                return;
            }
            if (!fileObject2.isData()) continue;
            throw new IOException(NbBundle.getMessage(Evaluator.class, (String)"MSG_file_exists", (Object)string));
        }
    }

    private static void log(String string) {
        System.out.println("Evaluator" + string);
    }
}

