/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.web.core.WebExecSupport;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.openide.actions.OpenAction;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class JspNode
extends DataNode {
    private static final String EXECUTION_SET_NAME = "Execution";
    private static final String SHEETNAME_TEXT_PROPERTIES = "textProperties";
    private static final String ICON_JSP = "org/netbeans/modules/web/core/resources/jsp16";
    private static final String ICON_TAG = "org/netbeans/modules/web/core/resources/tag16";
    private static final String ICON_JSP_XML = "org/netbeans/modules/web/core/resources/jsp-xml16";
    private static final String ICON_JSP_FRAGMENT = "org/netbeans/modules/web/core/resources/jsp-fragment16";
    public static final String PROP_FILE_ENCODING = "encoding";
    public static final String PROP_REQUEST_PARAMS = "requestparams";

    public JspNode(JspDataObject jspDataObject) {
        super((DataObject)jspDataObject, Children.LEAF);
        this.initialize();
    }

    private void initialize() {
        this.setIconBase(this.getIconBase());
        this.setDefaultAction(SystemAction.get(OpenAction.class));
        if (this.isTagFile()) {
            this.setShortDescription(NbBundle.getMessage(JspNode.class, (String)"LBL_tagNodeShortDesc"));
        } else {
            this.setShortDescription(NbBundle.getMessage(JspNode.class, (String)"LBL_jspNodeShortDesc"));
        }
    }

    private String getExtension() {
        return this.getDataObject().getPrimaryFile().getExt();
    }

    private boolean isTagFile() {
        String string = this.getExtension();
        return string.equals("tagf") || string.equals("tagx") || string.equals("tag");
    }

    public DataObject getDataObject() {
        return super.getDataObject();
    }

    protected Sheet createSheet() {
        Sheet.Set set;
        Sheet sheet = super.createSheet();
        if (!this.isTagFile()) {
            set = new Sheet.Set();
            set.setName(EXECUTION_SET_NAME);
            set.setDisplayName(NbBundle.getBundle(JspNode.class).getString("PROP_executionSetName"));
            set.setShortDescription(NbBundle.getBundle(JspNode.class).getString("HINT_executionSetName"));
            set.put((Node.Property)new PropertySupport.ReadWrite(PROP_REQUEST_PARAMS, String.class, NbBundle.getBundle(JspNode.class).getString("PROP_requestParams"), NbBundle.getBundle(JspNode.class).getString("HINT_requestParams")){

                public Object getValue() {
                    return JspNode.getRequestParams(((MultiDataObject)JspNode.this.getDataObject()).getPrimaryEntry());
                }

                public void setValue(Object object) throws InvocationTargetException {
                    if (object instanceof String) {
                        try {
                            JspNode.setRequestParams(((MultiDataObject)JspNode.this.getDataObject()).getPrimaryEntry(), (String)object);
                        }
                        catch (IOException iOException) {
                            throw new InvocationTargetException(iOException);
                        }
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
            });
            sheet.put(set);
        }
        set = new Sheet.Set();
        set.setName(SHEETNAME_TEXT_PROPERTIES);
        set.setDisplayName(NbBundle.getBundle(JspNode.class).getString("PROP_textfileSetName"));
        set.setShortDescription(NbBundle.getBundle(JspNode.class).getString("HINT_textfileSetName"));
        sheet.put(set);
        set.put((Node.Property)new PropertySupport.ReadOnly(PROP_FILE_ENCODING, String.class, NbBundle.getBundle(JspNode.class).getString("PROP_fileEncoding"), NbBundle.getBundle(JspNode.class).getString("HINT_fileEncoding")){

            public Object getValue() {
                return ((JspDataObject)JspNode.this.getDataObject()).getFileEncoding();
            }
        });
        return sheet;
    }

    static final void wrapThrowable(Throwable throwable, Throwable throwable2, String string) {
        throwable.initCause(throwable2);
        Exceptions.attachMessage((Throwable)throwable, (String)string);
    }

    static void setRequestParams(MultiDataObject.Entry entry, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\r' || c == '\n') continue;
                stringBuffer.append(c);
            }
            string2 = stringBuffer.toString();
            if (string2.length() == 0) {
                string2 = null;
            }
        }
        WebExecSupport.setQueryString(entry.getFile(), string2);
    }

    static String getRequestParams(MultiDataObject.Entry entry) {
        return WebExecSupport.getQueryString(entry.getFile());
    }

    protected String getIconBase() {
        String string = this.getDataObject().getPrimaryFile().getExt();
        if (string.equals("tagf") || string.equals("tagx") || string.equals("tag")) {
            return ICON_TAG;
        }
        if (string.equals("jsf") || string.equals("jspf")) {
            return ICON_JSP_FRAGMENT;
        }
        if (string.equals("jspx")) {
            return ICON_JSP_XML;
        }
        return ICON_JSP;
    }
}

