/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import java.util.ArrayList;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.ui.actions.DeleteServiceAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class DeleteGroupAction
extends NodeAction {
    protected boolean enable(Node[] nodeArray) {
        for (Node node : nodeArray) {
            SaasGroup saasGroup = (SaasGroup)node.getLookup().lookup(SaasGroup.class);
            if (saasGroup != null && saasGroup.isUserDefined()) continue;
            return false;
        }
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/websvc/saas/ui/resources/ActionIcon.gif";
    }

    public String getName() {
        return NbBundle.getMessage(DeleteServiceAction.class, (String)"DELETE");
    }

    protected void performAction(Node[] nodeArray) {
        final ArrayList<SaasGroup> arrayList = new ArrayList<SaasGroup>();
        for (Node node : nodeArray) {
            SaasGroup saasGroup = (SaasGroup)node.getLookup().lookup(SaasGroup.class);
            if (saasGroup == null || !saasGroup.isUserDefined()) {
                throw new IllegalArgumentException("Some node has no associated SaasGroup");
            }
            arrayList.add(saasGroup);
        }
        String string = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"WS_DELETE_GROUP") + " " + arrayList;
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (null != object && object.equals(NotifyDescriptor.YES_OPTION)) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    for (SaasGroup saasGroup : arrayList) {
                        SaasServicesModel.getInstance().removeGroup(saasGroup);
                    }
                }
            });
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

