/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSemanticAnalyzer
implements SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, ColoringAttributes> semanticHighlights;

    public Map<OffsetRange, ColoringAttributes> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        if (this.cancelled) {
            return;
        }
        HashMap<OffsetRange, ColoringAttributes> hashMap = new HashMap<OffsetRange, ColoringAttributes>();
        ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/html").iterator().next();
        TranslatedSource translatedSource = parserResult.getTranslatedSource();
        HtmlParserResult htmlParserResult = (HtmlParserResult)parserResult;
        Set<SyntaxElement.TagAttribute> set = htmlParserResult.elementsIds();
        for (SyntaxElement.TagAttribute tagAttribute : set) {
            AstOffsetRange astOffsetRange = new AstOffsetRange(tagAttribute.getValueOffset(), tagAttribute.getValueOffset() + tagAttribute.getValueLength(), translatedSource);
            hashMap.put(astOffsetRange, ColoringAttributes.METHOD);
        }
        this.semanticHighlights = hashMap;
    }

    public static class AstOffsetRange
    extends OffsetRange {
        private TranslatedSource source;

        public AstOffsetRange(int n, int n2, TranslatedSource translatedSource) {
            super(n, n2);
            this.source = translatedSource;
        }

        public int getStart() {
            return this.source == null ? super.getStart() : this.source.getLexicalOffset(super.getStart());
        }

        public int getEnd() {
            return this.source == null ? super.getEnd() : this.source.getLexicalOffset(super.getEnd());
        }
    }
}

