/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class HTMLBracesMatching
implements BracesMatcher,
BracesMatcherFactory {
    private MatcherContext context;
    private LanguagePath htmlLanguagePath;
    private FileObject fileObject;
    private static final String BLOCK_COMMENT_START = "<!--";
    private static final String BLOCK_COMMENT_END = "-->";

    public HTMLBracesMatching() {
        this(null, null, null);
    }

    private HTMLBracesMatching(MatcherContext matcherContext, FileObject fileObject, LanguagePath languagePath) {
        this.context = matcherContext;
        this.fileObject = fileObject;
        this.htmlLanguagePath = languagePath;
    }

    public int[] findOrigin() throws InterruptedException, BadLocationException {
        if (MatcherContext.isTaskCanceled()) {
            return null;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
        List list = tokenHierarchy.embeddedTokenSequences(this.context.getSearchOffset(), this.context.isSearchingBackward());
        block0: for (TokenSequence tokenSequence : list) {
            Object object;
            if (tokenSequence.language() != HTMLTokenId.language()) continue;
            tokenSequence.move(this.context.getSearchOffset());
            if (!tokenSequence.moveNext()) continue;
            if (this.context.isSearchingBackward() && tokenSequence.offset() + tokenSequence.token().length() < this.context.getSearchOffset()) {
                return null;
            }
            Token token = tokenSequence.token();
            if (this.tokenInTag(token)) {
                do {
                    if (!this.tokenInTag((Token)(object = tokenSequence.token()))) {
                        return null;
                    }
                    if (object.id() != HTMLTokenId.TAG_OPEN_SYMBOL) continue;
                    while (tokenSequence.moveNext()) {
                        Token token2 = tokenSequence.token();
                        if (!this.tokenInTag(token2) || token2.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                            return null;
                        }
                        if (token2.id() != HTMLTokenId.TAG_CLOSE_SYMBOL) continue;
                        if ("/>".equals(((Object)token2.text()).toString())) {
                            return null;
                        }
                        return new int[]{object.offset(tokenHierarchy), token2.offset(tokenHierarchy) + token2.length()};
                    }
                    continue block0;
                } while (tokenSequence.movePrevious());
                continue;
            }
            if (token.id() != HTMLTokenId.BLOCK_COMMENT) continue;
            object = ((Object)token.text()).toString();
            if (((String)object).startsWith(BLOCK_COMMENT_START) && this.context.getSearchOffset() < token.offset(tokenHierarchy) + BLOCK_COMMENT_START.length()) {
                return new int[]{token.offset(tokenHierarchy), token.offset(tokenHierarchy) + BLOCK_COMMENT_START.length()};
            }
            if (!((String)object).endsWith(BLOCK_COMMENT_END) || this.context.getSearchOffset() < token.offset(tokenHierarchy) + ((String)object).length() - BLOCK_COMMENT_END.length()) continue;
            return new int[]{token.offset(tokenHierarchy) + token.length() - BLOCK_COMMENT_END.length(), token.offset(tokenHierarchy) + token.length()};
        }
        return null;
    }

    private boolean tokenInTag(Token token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL || token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_CLOSE || token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.ARGUMENT || token.id() == HTMLTokenId.VALUE || token.id() == HTMLTokenId.VALUE_JAVASCRIPT || token.id() == HTMLTokenId.OPERATOR || token.id() == HTMLTokenId.EOL;
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        if (MatcherContext.isTaskCanceled()) {
            return null;
        }
        try {
            Source source = Source.forDocument((Document)this.context.getDocument());
            if (source == null) {
                return null;
            }
            final ArrayList arrayList = new ArrayList(1);
            if (SourceAccessor.getINSTANCE().isParserLocked()) {
                return null;
            }
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (MatcherContext.isTaskCanceled()) {
                        return;
                    }
                    HtmlParserResult htmlParserResult = (HtmlParserResult)compilationController.getEmbeddedResult("text/html", HTMLBracesMatching.this.context.getSearchOffset());
                    arrayList.add(0, htmlParserResult);
                }
            }, true);
            if (arrayList.size() > 0) {
                int n;
                HtmlParserResult htmlParserResult = (HtmlParserResult)((Object)arrayList.get(0));
                if (htmlParserResult == null) {
                    return new int[]{this.context.getSearchOffset(), this.context.getSearchOffset()};
                }
                AstNode astNode = htmlParserResult.root();
                AstNode astNode2 = AstNodeUtils.findDescendant((AstNode)astNode, (int)(n = htmlParserResult.getTranslatedSource() == null ? this.context.getSearchOffset() : htmlParserResult.getTranslatedSource().getAstOffset(this.context.getSearchOffset())));
                if (astNode2 != null) {
                    if (astNode2.type() == AstNode.NodeType.OPEN_TAG) {
                        AstNode astNode3 = astNode2.parent();
                        if (astNode3.type() == AstNode.NodeType.UNMATCHED_TAG) {
                            DTD.Element element = htmlParserResult.dtd().getElement(astNode2.name().toUpperCase());
                            if (element != null && element.hasOptionalEnd()) {
                                return new int[]{n, n};
                            }
                            return null;
                        }
                        AstNode astNode4 = (AstNode)astNode3.children().get(astNode3.children().size() - 1);
                        return this.translate(new int[]{astNode4.startOffset(), astNode4.endOffset()}, htmlParserResult.getTranslatedSource());
                    }
                    if (astNode2.type() == AstNode.NodeType.ENDTAG) {
                        AstNode astNode5 = astNode2.parent();
                        if (astNode5.type() == AstNode.NodeType.UNMATCHED_TAG) {
                            DTD.Element element = htmlParserResult.dtd().getElement(astNode2.name().toUpperCase());
                            if (element != null && element.hasOptionalStart()) {
                                return new int[]{n, n};
                            }
                            return null;
                        }
                        AstNode astNode6 = (AstNode)astNode5.children().get(0);
                        return this.translate(new int[]{astNode6.startOffset(), astNode6.endOffset()}, htmlParserResult.getTranslatedSource());
                    }
                    if (astNode2.type() == AstNode.NodeType.COMMENT) {
                        int n2 = astNode2.startOffset();
                        if (n >= astNode2.startOffset() && n <= astNode2.startOffset() + BLOCK_COMMENT_START.length()) {
                            return this.translate(new int[]{astNode2.endOffset() - BLOCK_COMMENT_END.length(), astNode2.endOffset()}, htmlParserResult.getTranslatedSource());
                        }
                        if (n >= astNode2.endOffset() - BLOCK_COMMENT_END.length() && n <= astNode2.endOffset()) {
                            return this.translate(new int[]{astNode2.startOffset(), astNode2.startOffset() + BLOCK_COMMENT_START.length()}, htmlParserResult.getTranslatedSource());
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private int[] translate(int[] nArray, TranslatedSource translatedSource) {
        if (translatedSource == null) {
            return nArray;
        }
        return new int[]{translatedSource.getLexicalOffset(nArray[0]), translatedSource.getLexicalOffset(nArray[1] - 1) + 1};
    }

    public BracesMatcher createMatcher(MatcherContext matcherContext) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)matcherContext.getDocument());
        List list = tokenHierarchy.embeddedTokenSequences(matcherContext.getSearchOffset(), matcherContext.isSearchingBackward());
        for (TokenSequence tokenSequence : list) {
            Language language = tokenSequence.language();
            if (language != HTMLTokenId.language()) continue;
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)matcherContext.getDocument());
            if (dataObject == null) break;
            return new HTMLBracesMatching(matcherContext, dataObject.getPrimaryFile(), tokenSequence.languagePath());
        }
        return null;
    }
}

