/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces.refactoring;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.visualweb.insync.java.JavaClass;
import org.netbeans.modules.visualweb.insync.java.JavaUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FacesRefactoringUtils {
    static final String FACES_SERVLET_URL_PATTERN_PREFIX = "/faces/";
    private static final String JSP_MIME_TYPE = "text/x-jsp";
    private static final String JAVA_MIME_TYPE = "text/x-java";
    private static final List<String> specialFolderNames = Collections.unmodifiableList(Arrays.asList("META-INF", "WEB-INF"));
    private static final Logger LOGGER = Logger.getLogger(FacesRefactoringUtils.class.getName());
    private static Dialog waitDialog = null;
    private static RequestProcessor.Task waitTask = null;

    FacesRefactoringUtils() {
    }

    static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    static boolean isJspFile(FileObject fileObject) {
        return JSP_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    static boolean isSpecialFolderName(String string) {
        return specialFolderNames.contains(string);
    }

    static boolean isVisualWebJspFile(FileObject fileObject) {
        FileObject fileObject2;
        return FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject) && FacesRefactoringUtils.isJspFile(fileObject) && (fileObject2 = FacesModel.getJavaForJsp(fileObject)) != null;
    }

    static boolean isFileUnderDocumentRoot(FileObject fileObject) {
        FileObject fileObject2;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        if (JsfProjectUtils.isJsfProject((Project)project) && (fileObject2 = JsfProjectUtils.getDocumentRoot((Project)project)) != null) {
            return FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject);
        }
        return false;
    }

    static boolean isFileUnderPageBeanRoot(FileObject fileObject) {
        if (FacesRefactoringUtils.isFileInJsfProject(fileObject)) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return false;
            }
            FileObject fileObject2 = JsfProjectUtils.getPageBeanRoot((Project)project);
            if (fileObject2 != null) {
                return FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject);
            }
        }
        return false;
    }

    static boolean isFolderParentOfPageBeanRoot(FileObject fileObject) {
        if (fileObject.isFolder()) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return false;
            }
            FileObject fileObject2 = JsfProjectUtils.getPageBeanRoot((Project)project);
            if (fileObject2 != null) {
                return FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2);
            }
        }
        return false;
    }

    static boolean isFolderPageBeanRoot(FileObject fileObject) {
        if (fileObject.isFolder()) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return false;
            }
            FileObject fileObject2 = JsfProjectUtils.getPageBeanRoot((Project)project);
            if (fileObject2 != null) {
                return fileObject2.equals(fileObject);
            }
        }
        return false;
    }

    static boolean isFolderUnderPageBeanRoot(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return FacesRefactoringUtils.isFileUnderPageBeanRoot(fileObject);
        }
        return false;
    }

    static boolean isFileInJsfProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        return JsfProjectUtils.isJsfProject((Project)project);
    }

    static boolean isOpenProject(Project project) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            return true;
        }
        return false;
    }

    static boolean isJavaFileObjectOfInterest(FileObject fileObject) {
        FacesModel facesModel;
        if (FacesRefactoringUtils.isFileUnderPageBeanRoot(fileObject) && FacesRefactoringUtils.isOnSourceClasspath(fileObject) && FacesRefactoringUtils.isJavaFile(fileObject) && (facesModel = FacesModel.getFacesModel(fileObject)) != null) {
            JavaUnit javaUnit;
            facesModel.sync();
            if (!facesModel.isBusted() && (javaUnit = facesModel.getJavaUnit()) != null) {
                JavaClass javaClass = javaUnit.getJavaClass();
                for (String string : FacesModel.managedBeanNames) {
                    if (!javaClass.isSubTypeOf(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fileObject) {
        return fileObject.equals(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject));
    }

    public static String getPackageName(FileObject fileObject) {
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    static String getName(Dictionary dictionary) {
        if (dictionary == null) {
            return null;
        }
        return (String)dictionary.get("name");
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... classPath) {
        FileObject fileObject2;
        assert (((FileObject[])classPath).length > 0);
        HashSet<URL> hashSet = new HashSet<URL>();
        for (FileObject fileObject2 : classPath) {
            Project project = null;
            if (fileObject2 != null) {
                project = FileOwnerQuery.getOwner((FileObject)fileObject2);
            }
            if (project != null) {
                URL uRL = URLMapper.findURL((FileObject)ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source").findOwnerRoot(fileObject2), (int)0);
                hashSet.addAll(SourceUtils.getDependentRoots((URL)uRL));
                for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                    hashSet.add(URLMapper.findURL((FileObject)sourceGroup.getRootFolder(), (int)0));
                }
                continue;
            }
            for (SourceGroup[] sourceGroupArray : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject fileObject3 : sourceGroupArray.getRoots()) {
                    hashSet.add(URLMapper.findURL((FileObject)fileObject3, (int)0));
                }
            }
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((URL[])hashSet.toArray(new URL[hashSet.size()]));
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/boot");
        ClassPath classPath4 = ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/compile");
        fileObject2 = ClasspathInfo.create((ClassPath)classPath3, (ClassPath)classPath4, (ClassPath)classPath2);
        return fileObject2;
    }

    public static FileObject getClassPathRoot(FileObject fileObject) {
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseDocument getBaseDocument(DataObject dataObject) {
        BaseDocument baseDocument = null;
        if (dataObject != null) {
            DataObject dataObject2 = dataObject;
            synchronized (dataObject2) {
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                if (editorCookie != null && (baseDocument = (BaseDocument)editorCookie.getDocument()) == null) {
                    Task task = editorCookie.prepareDocument();
                    task.waitFinished();
                    baseDocument = (BaseDocument)editorCookie.getDocument();
                }
            }
        }
        return baseDocument;
    }

    static List<OccurrenceItem> getAllBeanNameOccurrences(WebModule webModule, String string, String string2) {
        FileObject[] fileObjectArray;
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        assert (string2 != null);
        LOGGER.fine("getAllOccurences(" + webModule.getDocumentBase().getPath() + ", " + string + ", " + string2 + ")");
        if (webModule != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FacesConfig facesConfig = ConfigurationUtils.getConfigModel((FileObject)fileObjectArray[i], (boolean)true).getRootComponent();
                List list = facesConfig.getManagedBeans();
                for (ManagedBean managedBean : list) {
                    if (!string.equals(managedBean.getManagedBeanName())) continue;
                    arrayList.add(new ManagedBeanNameItem(fileObjectArray[i], managedBean, string2));
                }
            }
        }
        return arrayList;
    }

    static List<OccurrenceItem> getAllBeanClassOccurrences(WebModule webModule, String string, String string2) {
        FileObject[] fileObjectArray;
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        assert (string2 != null);
        LOGGER.fine("getAllOccurences(" + webModule.getDocumentBase().getPath() + ", " + string + ", " + string2 + ")");
        if (webModule != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FacesConfig facesConfig = ConfigurationUtils.getConfigModel((FileObject)fileObjectArray[i], (boolean)true).getRootComponent();
                List list = facesConfig.getManagedBeans();
                for (ManagedBean managedBean : list) {
                    if (!string.equals(managedBean.getManagedBeanClass())) continue;
                    arrayList.add(new ManagedBeanClassItem(fileObjectArray[i], managedBean, string2));
                }
            }
        }
        return arrayList;
    }

    static List<OccurrenceItem> getAllFromViewIdOccurrences(WebModule webModule, String string, String string2) {
        FileObject[] fileObjectArray;
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        assert (string2 != null);
        LOGGER.fine("getAllFromViewOccurrences(" + webModule.getDocumentBase().getPath() + ", " + string + ", " + string2 + ")");
        if (webModule != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FacesConfig facesConfig = ConfigurationUtils.getConfigModel((FileObject)fileObjectArray[i], (boolean)true).getRootComponent();
                List list = facesConfig.getNavigationRules();
                for (NavigationRule navigationRule : list) {
                    if (!string.equals(navigationRule.getFromViewId())) continue;
                    arrayList.add(new NavigationFromViewIdItem(fileObjectArray[i], navigationRule, string2));
                }
            }
        }
        return arrayList;
    }

    static List<OccurrenceItem> getAllToViewOccurrences(WebModule webModule, String string, String string2) {
        FileObject[] fileObjectArray;
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        assert (string2 != null);
        LOGGER.fine("getAllToViewOccurrences(" + webModule.getDocumentBase().getPath() + ", " + string + ", " + string2 + ")");
        if (webModule != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FacesConfig facesConfig = ConfigurationUtils.getConfigModel((FileObject)fileObjectArray[i], (boolean)true).getRootComponent();
                List list = facesConfig.getNavigationRules();
                for (NavigationRule navigationRule : list) {
                    List list2 = navigationRule.getNavigationCases();
                    for (NavigationCase navigationCase : list2) {
                        if (!string.equals(navigationCase.getToViewId())) continue;
                        arrayList.add(new NavigationToViewIdItem(fileObjectArray[i], navigationCase, string2));
                    }
                }
            }
        }
        return arrayList;
    }

    static boolean isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    static String computePathFromTo(FileObject fileObject, FileObject fileObject2) {
        ArrayList arrayList = FacesRefactoringUtils.getPathList(fileObject);
        ArrayList arrayList2 = FacesRefactoringUtils.getPathList(fileObject2);
        StringBuffer stringBuffer = new StringBuffer(FacesRefactoringUtils.computePathFromTo(arrayList, arrayList2));
        if (fileObject2.isData()) {
            stringBuffer.append(fileObject2.getNameExt());
        }
        return stringBuffer.toString();
    }

    static String computePathFromTo(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        for (int i = 0; i < arrayList.size() && i < arrayList2.size() && arrayList.get(i).equals(arrayList2.get(i)); ++i) {
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = i; n < arrayList.size(); ++n) {
            stringBuffer.append("../");
        }
        for (n = i; n < arrayList2.size(); ++n) {
            stringBuffer.append(arrayList2.get(n));
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    static ArrayList getPathList(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            fileObject = fileObject.getParent();
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        while (fileObject != null) {
            arrayList.add(fileObject.getName());
            fileObject = fileObject.getParent();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    static ArrayList getPathList(String string) {
        if (string.length() == 0) {
            return new ArrayList();
        }
        String[] stringArray = string.replace('\\', '/').split("/");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    static String computeRelativePath(String string, String string2) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(string.split("/")));
        LinkedList<String> linkedList2 = new LinkedList<String>(Arrays.asList(string2.split("/")));
        Collections.reverse(linkedList);
        Collections.reverse(linkedList2);
        String string3 = FacesRefactoringUtils.computeRelativePath(linkedList, linkedList2);
        if (string3 != null && string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    static String computeRelativePath(List<String> list, List<String> list2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size() - 1;
        for (n = list2.size() - 1; n2 >= 0 && n >= 0 && list.get(n2).equals(list2.get(n)); --n2, --n) {
        }
        while (n2 >= 0) {
            stringBuilder.append("../");
            --n2;
        }
        while (n >= 1) {
            stringBuilder.append(list2.get(n) + "/");
            --n;
        }
        stringBuilder.append(list2.get(n));
        return stringBuilder.toString();
    }

    public static boolean invokeAfterScanFinished(Runnable runnable, String string) {
        assert (SwingUtilities.isEventDispatchThread());
        if (SourceUtils.isScanInProgress()) {
            final ActionPerformer actionPerformer = new ActionPerformer(runnable);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    actionPerformer.cancel();
                    waitTask.cancel();
                }
            };
            JLabel jLabel = new JLabel(FacesRefactoringUtils.getString("MSG_WaitScan"), UIManager.getIcon("OptionPane.informationIcon"), 2);
            jLabel.setBorder(new EmptyBorder(12, 12, 11, 11));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jLabel, string, true, new Object[]{FacesRefactoringUtils.getString("LBL_CancelAction", new Object[]{string})}, null, 0, null, actionListener);
            waitDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            waitDialog.pack();
            waitTask = RequestProcessor.getDefault().post((Runnable)actionPerformer);
            waitDialog.setVisible(true);
            waitTask = null;
            waitDialog = null;
            return actionPerformer.hasBeenCancelled();
        }
        runnable.run();
        return false;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(FacesRefactoringUtils.class, (String)string);
    }

    private static String getString(String string, Object object) {
        return new MessageFormat(FacesRefactoringUtils.getString(string)).format(object);
    }

    private static class ActionPerformer
    implements Runnable {
        private Runnable action;
        private boolean cancel = false;

        ActionPerformer(Runnable runnable) {
            this.action = runnable;
        }

        public boolean hasBeenCancelled() {
            return this.cancel;
        }

        public void run() {
            try {
                SourceUtils.waitScanFinished();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!ActionPerformer.this.cancel) {
                        if (waitDialog != null) {
                            waitDialog.setVisible(false);
                        }
                        ActionPerformer.this.action.run();
                    }
                }
            });
        }

        public void cancel() {
            assert (SwingUtilities.isEventDispatchThread());
            if (waitDialog != null) {
                this.cancel = true;
                waitDialog.setVisible(false);
            }
        }
    }

    static class NavigationToViewIdItem
    extends OccurrenceItem {
        private final NavigationCase navigationCase;

        public NavigationToViewIdItem(FileObject fileObject, NavigationCase navigationCase, String string) {
            super(fileObject, string, navigationCase.getToViewId());
            this.navigationCase = navigationCase;
        }

        protected String getXMLElementName() {
            return "to-view-id";
        }

        public void performRename() {
            this.changeToViewId(this.oldValue, this.newValue);
        }

        public void undoRename() {
            this.changeToViewId(this.newValue, this.oldValue);
        }

        public String getRenameMessage() {
            return NbBundle.getMessage(FacesRefactoringUtils.class, (String)"MSG_NavigationToViewId_Rename", (Object[])new Object[]{this.navigationCase.getToViewId(), this.getElementText()});
        }

        private void changeToViewId(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel((FileObject)this.config, (boolean)true).getRootComponent();
            List list = facesConfig.getNavigationRules();
            for (NavigationRule navigationRule : list) {
                List list2 = navigationRule.getNavigationCases();
                for (NavigationCase navigationCase : list2) {
                    if (!string.equals(navigationCase.getToViewId())) continue;
                    facesConfig.getModel().startTransaction();
                    navigationCase.setToViewId(string2);
                    facesConfig.getModel().endTransaction();
                }
            }
        }
    }

    static class NavigationFromViewIdItem
    extends OccurrenceItem {
        private final NavigationRule navigationRule;

        public NavigationFromViewIdItem(FileObject fileObject, NavigationRule navigationRule, String string) {
            super(fileObject, string, navigationRule.getFromViewId());
            this.navigationRule = navigationRule;
        }

        protected String getXMLElementName() {
            return "from-view-id";
        }

        public void performRename() {
            this.changeFromViewId(this.oldValue, this.newValue);
        }

        public void undoRename() {
            this.changeFromViewId(this.newValue, this.oldValue);
        }

        public String getRenameMessage() {
            return NbBundle.getMessage(FacesRefactoringUtils.class, (String)"MSG_NavigationFromViewId_Rename", (Object[])new Object[]{this.navigationRule.getFromViewId(), this.getElementText()});
        }

        private void changeFromViewId(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel((FileObject)this.config, (boolean)true).getRootComponent();
            List list = facesConfig.getNavigationRules();
            for (NavigationRule navigationRule : list) {
                if (!string.equals(navigationRule.getFromViewId())) continue;
                facesConfig.getModel().startTransaction();
                navigationRule.setFromViewId(string2);
                facesConfig.getModel().endTransaction();
            }
        }
    }

    static class ManagedBeanClassItem
    extends OccurrenceItem {
        private final ManagedBean bean;

        public ManagedBeanClassItem(FileObject fileObject, ManagedBean managedBean, String string) {
            super(fileObject, string, managedBean.getManagedBeanClass());
            this.bean = managedBean;
        }

        protected String getXMLElementName() {
            return "managed-bean-class";
        }

        public void performRename() {
            this.changeBeanName(this.oldValue, this.newValue);
        }

        public void undoRename() {
            this.changeBeanName(this.newValue, this.oldValue);
        }

        public String getRenameMessage() {
            return NbBundle.getMessage(FacesRefactoringUtils.class, (String)"MSG_ManagedBeanClass_Rename", (Object[])new Object[]{this.bean.getManagedBeanClass(), this.getElementText()});
        }

        private void changeBeanName(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel((FileObject)this.config, (boolean)true).getRootComponent();
            List list = facesConfig.getManagedBeans();
            for (ManagedBean managedBean : list) {
                if (!string.equals(managedBean.getManagedBeanClass())) continue;
                facesConfig.getModel().startTransaction();
                managedBean.setManagedBeanClass(string2);
                facesConfig.getModel().endTransaction();
            }
        }
    }

    static class ManagedBeanNameItem
    extends OccurrenceItem {
        private final ManagedBean bean;

        public ManagedBeanNameItem(FileObject fileObject, ManagedBean managedBean, String string) {
            super(fileObject, string, managedBean.getManagedBeanName());
            this.bean = managedBean;
        }

        protected String getXMLElementName() {
            return "managed-bean-name";
        }

        public void performRename() {
            this.changeBeanName(this.oldValue, this.newValue);
        }

        public void undoRename() {
            this.changeBeanName(this.newValue, this.oldValue);
        }

        public String getRenameMessage() {
            return NbBundle.getMessage(FacesRefactoringUtils.class, (String)"MSG_ManagedBeanName_Rename", (Object[])new Object[]{this.bean.getManagedBeanName(), this.getElementText()});
        }

        private void changeBeanName(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel((FileObject)this.config, (boolean)true).getRootComponent();
            List list = facesConfig.getManagedBeans();
            for (ManagedBean managedBean : list) {
                if (!string.equals(managedBean.getManagedBeanName())) continue;
                facesConfig.getModel().startTransaction();
                managedBean.setManagedBeanName(string2);
                facesConfig.getModel().endTransaction();
            }
        }
    }

    static abstract class OccurrenceItem {
        protected FileObject config;
        protected String newValue;
        protected String oldValue;

        public OccurrenceItem(FileObject fileObject, String string, String string2) {
            this.config = fileObject;
            this.newValue = string;
            this.oldValue = string2;
        }

        public FileObject getFacesConfig() {
            return this.config;
        }

        public String getElementText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<font color=\"#0000FF\">");
            stringBuffer.append("&lt;").append(this.getXMLElementName()).append("&gt;</font><b>");
            stringBuffer.append(this.oldValue).append("</b><font color=\"#0000FF\">&lt;/").append(this.getXMLElementName());
            stringBuffer.append("&gt;</font>");
            return stringBuffer.toString();
        }

        protected abstract String getXMLElementName();

        public abstract void performRename();

        public abstract void undoRename();

        public abstract String getRenameMessage();
    }
}

