/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces;

import org.apache.xml.serialize.HTMLdtd;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.insync.InSyncServiceProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Entities {
    private Entities() {
    }

    public static String expandHtmlEntities(String string) {
        return Entities.expandHtmlEntities(string, true, null);
    }

    public static String expandHtmlEntities(String string, boolean bl) {
        return Entities.expandHtmlEntities(string, bl, null);
    }

    public static String expandHtmlEntities(String string, boolean bl, Node node) {
        FileObject fileObject = null;
        int n = -1;
        if (node != null) {
            Element element;
            if (node.getNodeType() == 3) {
                node = node.getParentNode();
            }
            if ((element = MarkupService.getCorrespondingSourceElement((Element)((Element)node))) != null) {
                Document document = element.getOwnerDocument();
                fileObject = InSyncServiceProvider.get().getFileObject(document);
                n = InSyncServiceProvider.get().computeLine(document, element);
            }
        }
        return Entities.getExpandedString(string, bl, fileObject, n);
    }

    private static String getExpandedString(String string, boolean bl, FileObject fileObject, int n) {
        if (string.indexOf(38) == -1) {
            return string;
        }
        int n2 = string.length();
        int n3 = n2 - 1;
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '&' && i < n3) {
                String string2;
                int n4;
                int n5;
                for (n5 = n4 = i + 1; n5 < n2 && string.charAt(n5) != ';' && n5 - n4 <= 10; ++n5) {
                }
                if (n5 == n2 || string.charAt(n5) != ';') {
                    if (bl) {
                        string2 = NbBundle.getMessage(Entities.class, (String)"LBL_IllegalEntity", (Object)string.substring(n4 - 1));
                        if (fileObject != null && n > -1) {
                            InSyncServiceProvider.get().getRaveErrorHandler().displayErrorForFileObject(string2, fileObject, n, 0);
                        } else {
                            InSyncServiceProvider.get().getRaveErrorHandler().displayError(string2);
                        }
                    }
                    stringBuffer.append('&');
                    continue;
                }
                string2 = string.substring(n4, n5);
                int n6 = Entities.expand(string2);
                if (n6 == -1) {
                    if (bl) {
                        String string3 = NbBundle.getMessage(Entities.class, (String)"LBL_NoSuchEntity", (Object)string2);
                        if (fileObject != null && n > -1) {
                            InSyncServiceProvider.get().getRaveErrorHandler().displayErrorForFileObject(string3, fileObject, n, 0);
                        } else {
                            InSyncServiceProvider.get().getRaveErrorHandler().displayError(string3);
                        }
                    }
                    stringBuffer.append('&');
                    continue;
                }
                stringBuffer.append((char)n6);
                i = n5;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static int getUnexpandedOffset(String string, int n) {
        int n2 = string.length();
        int n3 = n2 - 1;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (n4 == n) {
                return i;
            }
            char c = string.charAt(i);
            if (c == '&' && i < n3) {
                int n5;
                int n6;
                for (n6 = n5 = i + 1; n6 < n2 && string.charAt(n6) != ';' && n6 - n5 <= 10; ++n6) {
                }
                if (n6 == n2 || string.charAt(n6) != ';') {
                    ++n4;
                    continue;
                }
                String string2 = string.substring(n5, n6);
                int n7 = Entities.expand(string2);
                if (n7 == -1) {
                    ++n4;
                    continue;
                }
                ++n4;
                i = n6;
                continue;
            }
            ++n4;
        }
        return n2;
    }

    public static int getExpandedOffset(String string, int n) {
        int n2 = string.length();
        int n3 = n2 - 1;
        int n4 = 0;
        if (n > n2) {
            n = n2;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&' && i < n3) {
                int n5;
                int n6;
                for (n6 = n5 = i + 1; n6 < n2 && string.charAt(n6) != ';' && n6 - n5 <= 10; ++n6) {
                }
                if (n6 == n2 || string.charAt(n6) != ';') {
                    ++n4;
                    continue;
                }
                String string2 = string.substring(n5, n6);
                int n7 = Entities.expand(string2);
                if (n7 == -1) {
                    ++n4;
                    continue;
                }
                ++n4;
                i = n6;
                continue;
            }
            ++n4;
        }
        return n4;
    }

    private static int expand(String string) {
        if (string.length() > 0) {
            if (string.charAt(0) == '#') {
                return Entities.parseNumericReference(string);
            }
            return HTMLdtd.charFromName((String)string);
        }
        return -1;
    }

    private static int parseNumericReference(String string) {
        int n;
        int n2 = 10;
        if (string == null) {
            return 0;
        }
        int n3 = 0;
        int n4 = string.length();
        if (n4 <= 1) {
            return -1;
        }
        assert (string.charAt(0) == '#');
        if (string.charAt(1) == 'x' || string.charAt(1) == 'X') {
            n2 = 16;
            n3 = 2;
        } else {
            n3 = 1;
        }
        int n5 = 0;
        int n6 = -2147483647;
        int n7 = n6 / n2;
        if (n3 < n4) {
            if ((n = Character.digit(string.charAt(n3++), n2)) < 0) {
                return -n5;
            }
            n5 = -n;
        }
        while (n3 < n4) {
            if ((n = Character.digit(string.charAt(n3++), n2)) < 0) {
                return -n5;
            }
            if (n5 < n7) {
                return -n5;
            }
            if ((n5 *= n2) < n6 + n) {
                return -n5;
            }
            n5 -= n;
        }
        return -n5;
    }
}

