/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;
import org.netbeans.modules.visualweb.insync.FileDocument;
import org.netbeans.modules.visualweb.insync.ParserAnnotation;
import org.netbeans.modules.visualweb.insync.SourceUnitListener;
import org.netbeans.modules.visualweb.insync.UndoEvent;
import org.netbeans.modules.visualweb.insync.UndoManager;
import org.netbeans.modules.visualweb.insync.Unit;
import org.netbeans.modules.visualweb.insync.Util;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;

public abstract class SourceUnit
implements Unit,
DocumentListener,
UndoableEditListener,
PropertyChangeListener,
FileChangeListener {
    protected FileObject fobj;
    protected StyledDocument styledDocument;
    protected UndoManager undoManager;
    private DataObject dataObject = null;
    private EditorCookie ec = null;
    protected Date lastModified;
    private FileChangeListener lastModifiedTracker;
    protected Date lastModelDirty;
    private AtomicBoolean documentListenerAdded = new AtomicBoolean(false);
    private AtomicBoolean undoableEditListenerAdded = new AtomicBoolean(false);
    Unit.State state = Unit.State.CLEAN;
    int readerCount;
    int writerCount;
    Thread writingThread;
    protected HashSet listeners = null;

    protected SourceUnit(FileObject fileObject, UndoManager undoManager) {
        this.fobj = fileObject;
        try {
            this.dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        this.undoManager = undoManager;
        this.state = Unit.State.SOURCEDIRTY;
        this.ec = (EditorCookie)Util.getCookie(fileObject, EditorCookie.class);
        if (this.ec instanceof CloneableEditorSupport) {
            ((CloneableEditorSupport)this.ec).addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.styledDocument = this.ec.getDocument();
        if (this.styledDocument != null) {
            this.addDocumentListener();
            this.addUndoableEditListener();
        } else {
            fileObject.addFileChangeListener((FileChangeListener)this);
        }
        this.lastModified = fileObject.lastModified();
        this.lastModifiedTracker = new FileChangeListener(){

            public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            }

            public void fileChanged(FileEvent fileEvent) {
                SourceUnit.this.lastModified = SourceUnit.this.fobj.lastModified();
            }

            public void fileDataCreated(FileEvent fileEvent) {
            }

            public void fileDeleted(FileEvent fileEvent) {
            }

            public void fileFolderCreated(FileEvent fileEvent) {
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                SourceUnit.this.lastModified = SourceUnit.this.fobj.lastModified();
            }
        };
        fileObject.addFileChangeListener(this.lastModifiedTracker);
    }

    public void destroy() {
        this.releaseDocument();
        if (this.fobj != null) {
            this.fobj.removeFileChangeListener((FileChangeListener)this);
            this.fobj.removeFileChangeListener(this.lastModifiedTracker);
        }
        this.listeners = null;
        if (this.ec instanceof CloneableEditorSupport) {
            ((CloneableEditorSupport)this.ec).removePropertyChangeListener((PropertyChangeListener)this);
            this.ec = null;
        }
        this.undoManager = null;
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        if (this.state != Unit.State.MODELDIRTY) {
            this.setSourceDirty();
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    protected void releaseDocument() {
        if (this.styledDocument != null) {
            this.removeDocumentListener();
            this.removeUndoableEditListener();
            this.styledDocument = null;
            if (this.undoManager != null) {
                this.undoManager.notifyBufferEdited(this);
            }
            if (this.fobj != null) {
                this.fobj.addFileChangeListener((FileChangeListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Boolean bl;
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue() == null) {
                try {
                    if (this.lastModelDirty != null && this.lastModified.before(this.lastModelDirty)) {
                        this.setSourceDirty();
                    }
                }
                finally {
                    this.lastModified = this.fobj.lastModified();
                    this.lastModelDirty = null;
                    this.releaseDocument();
                }
            }
            if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getOldValue() == null) {
                this.fobj.removeFileChangeListener((FileChangeListener)this);
                this.styledDocument = (StyledDocument)propertyChangeEvent.getNewValue();
                this.addDocumentListener();
                this.addUndoableEditListener();
            }
        } else if ("modified".equals(propertyChangeEvent.getPropertyName()) && (bl = (Boolean)propertyChangeEvent.getNewValue()) != null && bl.equals(Boolean.FALSE)) {
            this.fireSaved();
        }
    }

    public Unit.State getState() {
        return this.state;
    }

    public ParserAnnotation[] getErrors() {
        return ParserAnnotation.EMPTY_ARRAY;
    }

    public void setModelDirty() {
        this.lastModelDirty = new Date();
        if (this.state == Unit.State.SOURCEDIRTY) {
            throw new IllegalStateException("Illegal model modification with dirty source " + this.getName());
        }
        if (this.state == Unit.State.MODELDIRTY) {
            return;
        }
        if (this.state == Unit.State.CLEAN) {
            assert (Trace.trace((String)"insync", (String)"SU.setModelDirty UpToDate => ModelDirty"));
            this.state = Unit.State.MODELDIRTY;
            this.fireModelDirtied();
        }
    }

    public void setSourceDirty() {
        if (this.state == Unit.State.MODELDIRTY) {
            if (this.fobj != null && !this.fobj.isValid()) {
                return;
            }
            throw new IllegalStateException("Illegal source modification with dirty model " + this.getName());
        }
        if (this.state != Unit.State.SOURCEDIRTY) {
            if (this.fobj != null && !this.fobj.isValid()) {
                return;
            }
            if (this.state == Unit.State.CLEAN) {
                assert (Trace.trace((String)"insync", (String)"SU.setModelDirty Clean => SourceDirty"));
                this.state = Unit.State.SOURCEDIRTY;
            } else if (this.state == Unit.State.BUSTED) {
                assert (Trace.trace((String)"insync", (String)"SU.setModelDirty Busted => SourceDirty"));
                this.state = Unit.State.SOURCEDIRTY;
            }
            this.fireSourceDirtied();
        }
    }

    public boolean isBusted() {
        return this.state.isBusted();
    }

    public void setBusted() {
        if (this.state == Unit.State.BUSTED) {
            return;
        }
        if (this.state == Unit.State.SOURCEDIRTY) {
            assert (Trace.trace((String)"insync", (String)"SU.setInvalid SourceDirty => Busted"));
        } else {
            throw new IllegalStateException("Illegal source busting from " + this.state + " " + this.getName());
        }
        this.state = Unit.State.BUSTED;
    }

    public void setClean() {
        if (this.state == Unit.State.SOURCEDIRTY ? !$assertionsDisabled && !Trace.trace((String)"insync", (String)"SU.setSourceUpToDate SourceDirty => Clean") : (this.state == Unit.State.BUSTED ? !$assertionsDisabled && !Trace.trace((String)"insync", (String)"SU.setSourceUpToDate Busted => Clean") : this.state == Unit.State.MODELDIRTY && !$assertionsDisabled && !Trace.trace((String)"insync", (String)"SU.setSourceUpToDate ModelDirty => Clean"))) {
            throw new AssertionError();
        }
        this.state = Unit.State.CLEAN;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        assert (Trace.trace((String)"insync-listener", (String)"SU.changedUpdate"));
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        assert (Trace.trace((String)"insync-listener", (String)"SU.insertUpdate"));
        this.undoManager.notifyBufferEdited(this);
        this.setSourceDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        assert (Trace.trace((String)"insync-listener", (String)"SU.removeUpdate"));
        this.undoManager.notifyBufferEdited(this);
        this.setSourceDirty();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.undoManager != null) {
            this.undoManager.notifyUndoableEditEvent(this);
        }
    }

    protected final synchronized Thread getWritingThread() {
        return this.writingThread;
    }

    public final synchronized void writeLock(UndoEvent undoEvent) {
        try {
            while (this.readerCount > 0 || this.writingThread != null) {
                if (Thread.currentThread() == this.writingThread) {
                    ++this.writerCount;
                    return;
                }
                this.wait();
            }
            this.writingThread = Thread.currentThread();
            this.writerCount = 1;
            this.firstWriteLock();
        }
        catch (InterruptedException interruptedException) {
            throw new UnsupportedOperationException("Interrupted attempt to aquire write lock");
        }
    }

    public final synchronized boolean writeUnlock(UndoEvent undoEvent) {
        if (--this.writerCount <= 0) {
            this.writerCount = 0;
            this.flush();
            this.writingThread = null;
            this.lastWriteUnlock();
            this.notifyAll();
            return true;
        }
        return false;
    }

    public boolean isWriteLocked() {
        return this.writerCount > 0;
    }

    public final synchronized void readLock() {
        try {
            while (this.writingThread != null) {
                if (this.writingThread == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            ++this.readerCount;
        }
        catch (InterruptedException interruptedException) {
            throw new UnsupportedOperationException("Interrupted attempt to aquire read lock");
        }
    }

    public final synchronized void readUnlock() {
        if (this.writingThread == Thread.currentThread()) {
            return;
        }
        if (this.readerCount <= 0) {
            throw new IllegalStateException("BAD_LOCK_STATE");
        }
        --this.readerCount;
        this.notify();
    }

    protected abstract void read(char[] var1, int var2);

    private final Util.BufferResult loadBuf() {
        Util.BufferResult bufferResult = this.styledDocument == null ? Util.loadFileObjectBuffer(this.fobj) : Util.loadDocumentBuffer(this.styledDocument);
        return bufferResult;
    }

    public boolean sync() {
        if (this.state == Unit.State.CLEAN) {
            return false;
        }
        if (this.state == Unit.State.MODELDIRTY) {
            assert (Trace.trace((String)"insync", (String)"SU.sync attempt to read source into a dirty model"));
            return false;
        }
        Util.BufferResult bufferResult = this.loadBuf();
        this.read(bufferResult.getBuffer(), bufferResult.getSize());
        if (this.state == Unit.State.SOURCEDIRTY) {
            this.setClean();
        }
        return true;
    }

    public abstract void writeTo(Writer var1) throws IOException;

    public void writeTo(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.writeTo(bufferedWriter);
        ((Writer)bufferedWriter).flush();
    }

    public final void dumpTo(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        this.dumpTo(printWriter);
        printWriter.flush();
    }

    protected boolean minimalReplace(String string) {
        block5: {
            try {
                int n;
                Util.BufferResult bufferResult = this.loadBuf();
                char[] cArray = bufferResult.getBuffer();
                int n2 = this.styledDocument.getLength();
                int n3 = string.length();
                for (n = 0; n < n2 && n < n3 && cArray[n] == string.charAt(n); ++n) {
                }
                while (n2 > n && n3 > n && cArray[n2 - 1] == string.charAt(n3 - 1)) {
                    --n2;
                    --n3;
                }
                if (n2 > n || n3 > n) {
                    String string2 = n > 0 || n3 < string.length() ? string.substring(n, n3) : string;
                    this.styledDocument.remove(n, n2 - n);
                    this.styledDocument.insertString(n, string2, null);
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled || Trace.trace((String)"insync", (String)("Unexpected error in SU.flush: " + badLocationException))) break block5;
                throw new AssertionError();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() {
        boolean[] blArray;
        block15: {
            Trace.trace((String)"insync", (String)("SU.flush of " + this.getName() + " state:" + this.state));
            if (this.state == Unit.State.CLEAN) {
                return false;
            }
            if (this.state == Unit.State.SOURCEDIRTY) {
                assert (Trace.trace((String)"insync", (String)"SU.flush attempt to flush a model with dirty source"));
                assert (Trace.printStackTrace());
                return false;
            }
            if (this.state == Unit.State.BUSTED) {
                assert (Trace.trace((String)"insync", (String)"SU.flush attempt to flush a model with busted source"));
                return false;
            }
            if (this.styledDocument == null) {
                this.styledDocument = Util.retrieveDocument(this.fobj, true);
            }
            blArray = new boolean[1];
            if (this.styledDocument != null) {
                this.startFlush();
                try {
                    this.removeDocumentListener();
                    NbDocument.runAtomic((StyledDocument)this.styledDocument, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                StringWriter stringWriter = new StringWriter();
                                SourceUnit.this.writeTo(stringWriter);
                                blArray[0] = SourceUnit.this.minimalReplace(((Object)stringWriter).toString());
                            }
                            catch (IOException iOException) {
                                assert (Trace.trace((String)"insync", (String)("Unexpected error in SU.flush: " + iOException)));
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                    });
                }
                finally {
                    this.addDocumentListener();
                    this.endFlush(blArray[0]);
                }
            }
            if (this.styledDocument instanceof FileDocument) {
                FileDocument fileDocument = (FileDocument)((Object)this.styledDocument);
                try {
                    fileDocument.write();
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled || Trace.trace((String)"insync", (String)("Can't write file: " + this.getName()))) break block15;
                    throw new AssertionError();
                }
            }
        }
        this.setClean();
        return blArray[0];
    }

    public void save() {
        SaveCookie saveCookie;
        DataObject dataObject = this.getDataObject();
        if (dataObject != null && this.state == Unit.State.CLEAN && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public String getName() {
        return FileUtil.toFile((FileObject)this.fobj).getAbsolutePath();
    }

    public StyledDocument getSourceDocument() {
        if (this.styledDocument == null) {
            this.styledDocument = Util.retrieveDocument(this.fobj, true);
        }
        if (this.state != Unit.State.MODELDIRTY) {
            this.state = Unit.State.CLEAN;
        }
        return this.styledDocument;
    }

    public FileObject getFileObject() {
        return this.fobj;
    }

    public DataObject getDataObject() {
        if (this.fobj != null && !this.fobj.isValid()) {
            return null;
        }
        return Util.findDataObject(this.fobj);
    }

    public void addListener(SourceUnitListener sourceUnitListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(sourceUnitListener);
    }

    public void removeListener(SourceUnitListener sourceUnitListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(sourceUnitListener);
    }

    protected void fireModelDirtied() {
        if (this.listeners == null) {
            return;
        }
        for (SourceUnitListener sourceUnitListener : this.listeners) {
            sourceUnitListener.sourceUnitModelDirtied(this);
        }
    }

    protected void fireSourceDirtied() {
        if (this.listeners == null) {
            return;
        }
        for (SourceUnitListener sourceUnitListener : this.listeners) {
            sourceUnitListener.sourceUnitSourceDirtied(this);
        }
    }

    protected void fireSaved() {
        if (this.listeners == null) {
            return;
        }
        for (SourceUnitListener sourceUnitListener : this.listeners) {
            sourceUnitListener.sourceUnitSaved(this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("[");
        this.toString(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1));
        stringBuffer.append(" fobj: ");
        if (this.fobj == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.fobj.getNameExt());
        }
    }

    protected void startFlush() {
    }

    protected void endFlush(boolean bl) {
    }

    protected synchronized void firstWriteLock() {
    }

    protected synchronized void lastWriteUnlock() {
    }

    private void addDocumentListener() {
        if (this.styledDocument != null && this.documentListenerAdded.compareAndSet(false, true)) {
            this.styledDocument.addDocumentListener(this);
        }
    }

    private void removeDocumentListener() {
        if (this.styledDocument != null && this.documentListenerAdded.compareAndSet(true, false)) {
            this.styledDocument.removeDocumentListener(this);
        }
    }

    private void addUndoableEditListener() {
        if (this.styledDocument != null && this.undoableEditListenerAdded.compareAndSet(false, true)) {
            this.styledDocument.addUndoableEditListener(this);
        }
    }

    private void removeUndoableEditListener() {
        if (this.styledDocument != null && this.undoableEditListenerAdded.compareAndSet(true, false)) {
            this.styledDocument.removeUndoableEditListener(this);
        }
    }

    public class CountingWriter
    extends Writer {
        public int pos;

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] cArray) {
            this.pos += cArray.length;
        }

        public void write(char[] cArray, int n, int n2) {
            this.pos += n2;
        }

        public void write(int n) {
            ++this.pos;
        }

        public void write(String string) {
            this.pos += string.length();
        }

        public void write(String string, int n, int n2) {
            this.pos += n2;
        }
    }
}

