/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.visualweb.classloaderprovider.CommonClassloaderProvider;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;
import org.netbeans.modules.visualweb.insync.FileObjectVisitor;
import org.netbeans.modules.visualweb.insync.InSyncServiceProvider;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.ModelSetListener;
import org.netbeans.modules.visualweb.insync.ModelSetsListener;
import org.netbeans.modules.visualweb.insync.ParserAnnotation;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelSet
implements FileChangeListener {
    static final String WriteLock_PREFIX = ".LCK";
    static final String WriteLock_SUFFIX = "~";
    protected static ArrayList modelSetsListeners;
    protected static IdentityHashMap sets;
    private static Map<Project, Runnable> projectToRunnable;
    private boolean initialized;
    protected final ClassLoader parentClassLoader;
    protected final Project project;
    protected URLClassLoader classLoader;
    protected ClassPath classPath;
    protected ClassPathListener classPathListener;
    protected FileSystem fileSystem;
    protected Model configModel = null;
    protected final IdentityHashMap models = new IdentityHashMap();
    protected final IdentityHashMap modelSetListeners = new IdentityHashMap();
    private final OperationListener operationListener = new ModelSetOperationListener();
    private static final String WEBSERVICE_CLIENTS_SUB_DIR = "webservice_clients";
    private static final String EJB_DATA_SUB_DIR = "ejb-sources";
    private Set modelsToSync;

    public static boolean hasActiveLockFileSigns(FileObject fileObject) {
        String string = fileObject.getNameExt();
        boolean bl = string.endsWith(WriteLock_SUFFIX) && string.startsWith(WriteLock_PREFIX);
        return bl;
    }

    public static void addModelSetsListener(ModelSetsListener modelSetsListener) {
        modelSetsListeners.add(modelSetsListener);
    }

    public static void removeModelSetsListener(ModelSetsListener modelSetsListener) {
        modelSetsListeners.remove(modelSetsListener);
    }

    protected static void fireModelSetAdded(ModelSet modelSet) {
        Object[] objectArray = modelSetsListeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ModelSetsListener modelSetsListener = (ModelSetsListener)objectArray[i];
            modelSetsListener.modelSetAdded(modelSet);
        }
    }

    protected static void fireModelSetRemoved(ModelSet modelSet) {
        Object[] objectArray = modelSetsListeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ModelSetsListener modelSetsListener = (ModelSetsListener)objectArray[i];
            modelSetsListener.modelSetRemoved(modelSet);
        }
    }

    protected static Collection getFactories() {
        return Lookup.getDefault().lookup(new Lookup.Template(Model.Factory.class)).allInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ModelSet startModeling(final Project project, final Class clazz) {
        if (project == null) {
            return null;
        }
        ModelSet modelSet = ModelSet.getModelSet(project);
        if (modelSet != null) {
            return modelSet;
        }
        Map<Project, Runnable> map = projectToRunnable;
        synchronized (map) {
            Runnable runnable = projectToRunnable.get(project);
            if (runnable == null) {
                runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            ModelSet.getInstance(project, clazz);
                        }
                        finally {
                            Map map = projectToRunnable;
                            synchronized (map) {
                                projectToRunnable.remove(project);
                            }
                        }
                    }
                };
                projectToRunnable.put(project, runnable);
                new Thread(runnable, "Loading ModelSet for " + project.getProjectDirectory().getName()).start();
            }
        }
        return null;
    }

    protected static ModelSet getInstance(FileObject fileObject, Class clazz) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return ModelSet.getInstance(project, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized ModelSet getInstance(Project project, Class clazz) {
        if (project == null) {
            return null;
        }
        ModelSet modelSet = null;
        IdentityHashMap identityHashMap = sets;
        synchronized (identityHashMap) {
            modelSet = (ModelSet)sets.get(project);
        }
        if (modelSet == null && clazz != null && (modelSet = ModelSet.createInstance(project, clazz)) != null) {
            identityHashMap = sets;
            synchronized (identityHashMap) {
                sets.put(project, modelSet);
            }
            ModelSet.fireModelSetAdded(modelSet);
        }
        return modelSet;
    }

    private static ModelSet createInstance(Project project, Class clazz) {
        try {
            Constructor constructor = clazz.getConstructor(Project.class);
            ModelSet modelSet = (ModelSet)constructor.newInstance(project);
            modelSet.setInitialized();
            return modelSet;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static ModelSet getModelSet(FileObject fileObject) {
        return ModelSet.getModelSet(FileOwnerQuery.getOwner((FileObject)fileObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ModelSet getModelSet(Project project) {
        ModelSet modelSet = null;
        IdentityHashMap identityHashMap = sets;
        synchronized (identityHashMap) {
            modelSet = (ModelSet)sets.get(project);
        }
        return modelSet;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    protected ModelSet(Project project) {
        this.project = project;
        CommonClassloaderProvider commonClassloaderProvider = null;
        Properties properties = new Properties();
        properties.put("j2ee.platform", JsfProjectUtils.getJ2eePlatformVersion((Project)project));
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(CommonClassloaderProvider.class));
        for (Object object : result.allInstances()) {
            if (!object.isCapableOf(properties)) continue;
            commonClassloaderProvider = object;
            break;
        }
        if (commonClassloaderProvider == null) {
            throw new RuntimeException("No Common Classloader Provider found.");
        }
        this.parentClassLoader = commonClassloaderProvider.getClassLoader();
        if (project != null) {
            this.getProjectClassLoader();
            assert (Trace.trace((String)"insync.model", (String)("MS.ModelSet ModelCreateVisitor visiting project items in " + Thread.currentThread())));
            ModelCreateVisitor modelCreateVisitor = new ModelCreateVisitor();
            for (FileObject fileObject : this.getSourceRoots()) {
                modelCreateVisitor.traverse(fileObject);
            }
            try {
                this.fileSystem = project.getProjectDirectory().getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            if (this.fileSystem != null) {
                this.fileSystem.addFileChangeListener((FileChangeListener)this);
            }
        }
        DataLoaderPool.getDefault().addOperationListener((OperationListener)WeakListeners.create(OperationListener.class, (EventListener)this.operationListener, (Object)DataLoaderPool.getDefault()));
    }

    protected List getSourceRoots() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        FileObject fileObject = JsfProjectUtils.getDocumentRoot((Project)this.project);
        if (fileObject != null) {
            arrayList.add(fileObject);
        }
        if ((fileObject = JsfProjectUtils.getPageBeanRoot((Project)this.project)) != null) {
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.fileSystem != null) {
            this.fileSystem.removeFileChangeListener((FileChangeListener)this);
        }
        this.releaseProjectClassLoader();
        Model[] modelArray = this.getModels();
        this.models.clear();
        for (int i = 0; i < modelArray.length; ++i) {
            modelArray[i].destroy();
        }
        this.configModel.destroy();
        IdentityHashMap identityHashMap = sets;
        synchronized (identityHashMap) {
            sets.remove(this.project);
        }
    }

    public Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLClassLoader getProjectClassLoader() {
        if (this.classLoader == null) {
            Object object;
            Object object2;
            Object object3;
            Library library2;
            LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
            LibraryManager libraryManager = JsfProjectUtils.getProjectLibraryManager((Project)this.project);
            for (Library library2 : libraryManager.getLibraries()) {
                if (!library2.getType().equals("complib") || !JsfProjectUtils.hasLibraryReference((Project)this.project, (Library)library2, (String)"classpath/compile")) continue;
                linkedHashSet.addAll(library2.getContent("visual-web-designtime"));
            }
            String string = JsfProjectUtils.getJ2eePlatformVersion((Project)this.project);
            if (string.equals("1.3") || string.equals("1.4")) {
                try {
                    FileObject fileObject = JsfProjectUtils.getProjectLibraryDirectory((Project)this.project);
                    FileObject fileObject2 = fileObject.getFileObject(WEBSERVICE_CLIENTS_SUB_DIR);
                    if (fileObject2 != null && ModelSet.hasJarFiles(fileObject2)) {
                        library2 = this.getJAXRPCLibrary(libraryManager);
                        if (library2 == null) {
                            library2 = this.getJAXRPCLibrary(LibraryManager.getDefault());
                        }
                        if (library2 != null) {
                            linkedHashSet.addAll(library2.getContent("classpath"));
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            int n = 0;
            try {
                object3 = JsfProjectUtils.getProjectLibraryDirectory((Project)this.project);
                library2 = object3.getFileObject(EJB_DATA_SUB_DIR);
                n = library2 != null && ModelSet.hasJarFiles((FileObject)library2) ? 1 : 0;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            this.classPath = ClassPath.getClassPath((FileObject)JsfProjectUtils.getPageBeanRoot((Project)this.project), (String)"classpath/packaged");
            if (this.classPath == null) {
                this.classPath = ClassPath.getClassPath((FileObject)JsfProjectUtils.getPageBeanRoot((Project)this.project), (String)"classpath/compile");
                object3 = (URLClassLoader)this.classPath.getClassLoader(true);
                library2 = ((URLClassLoader)object3).getURLs();
                linkedHashSet.addAll(Arrays.asList(library2));
                object2 = JsfProjectUtils.getJ2eeClasspathEntries((Project)this.project);
                object = Arrays.asList(object2);
                for (URL uRL : library2) {
                    File file;
                    URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                    FileObject fileObject = URLMapper.findFileObject((URL)(uRL2 != null ? uRL2 : uRL));
                    if (fileObject == null || (file = FileUtil.toFile((FileObject)fileObject)) == null) continue;
                    if (n != 0 && file.isFile() && file.getName().endsWith(".jar")) {
                        try {
                            JarFile jarFile = new JarFile(file);
                            try {
                                if (jarFile.getEntry("javax/ejb/CreateException.class") != null) {
                                    continue;
                                }
                            }
                            finally {
                                jarFile.close();
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                    if (!object.contains(file.getAbsolutePath())) continue;
                    linkedHashSet.remove(uRL);
                }
            } else {
                for (Library library2 : this.classPath.entries()) {
                    linkedHashSet.add(library2.getURL());
                }
            }
            object3 = JsfProjectUtils.getDocumentRoot((Project)this.project);
            library2 = FileUtil.toFile((FileObject)object3);
            object2 = new File(library2.getParentFile(), "build" + File.separator + "web" + File.separator + "WEB-INF" + File.separator + "classes");
            object = null;
            try {
                object = ((File)object2).toURI().toURL();
                linkedHashSet.add((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            }
            this.classLoader = new ProjectClassLoader(ModelSet.normalizeURLs(linkedHashSet), this.parentClassLoader);
            this.classPathListener = new ClassPathListener();
            this.classPath.addPropertyChangeListener((PropertyChangeListener)this.classPathListener);
        }
        return this.classLoader;
    }

    private Library getJAXRPCLibrary(LibraryManager libraryManager) {
        for (Library library : libraryManager.getLibraries()) {
            if (!library.getType().equals("j2se") || !library.getName().equals("jaxrpc16")) continue;
            return library;
        }
        return null;
    }

    private static URL[] normalizeURLs(Collection<URL> collection) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (URL uRL : collection) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                File file;
                if ("jar".equals(uRL.getProtocol())) {
                    fileObject = FileUtil.getArchiveFile((FileObject)fileObject);
                }
                if ((file = FileUtil.toFile((FileObject)fileObject)) != null) {
                    try {
                        URL uRL2 = file.toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)uRL2)) {
                            uRL2 = FileUtil.getArchiveRoot((URL)uRL2);
                        } else if (!file.exists()) {
                            assert (!uRL2.toExternalForm().endsWith("/")) : file;
                            uRL2 = new URL(uRL2.toExternalForm() + "/");
                        }
                        linkedList.add(uRL2);
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                    }
                }
            }
            linkedList.add(uRL);
        }
        return linkedList.toArray(new URL[0]);
    }

    private static boolean hasJarFiles(FileObject fileObject) {
        Enumeration enumeration = fileObject.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.isData() || !fileObject2.getExt().equals("jar")) continue;
            return true;
        }
        return false;
    }

    public Model[] getModels() {
        return this.getModelsMap().values().toArray(Model.EMPTY_ARRAY);
    }

    protected Map getModelsMap() {
        return this.models;
    }

    public Model getModel(FileObject fileObject) {
        Model model = (Model)this.getModelsMap().get(fileObject);
        return model;
    }

    public Model getConfigModel() {
        return this.configModel;
    }

    public void setConfigModel(Model model) {
        this.configModel = model;
    }

    public void addModelSetListener(ModelSetListener modelSetListener) {
        this.modelSetListeners.put(modelSetListener, "");
    }

    public void removeModelSetListener(ModelSetListener modelSetListener) {
        this.modelSetListeners.remove(modelSetListener);
    }

    protected void fireModelAdded(Model model) {
        for (ModelSetListener modelSetListener : this.modelSetListeners.keySet()) {
            modelSetListener.modelAdded(model);
        }
    }

    protected void fireModelChanged(Model model) {
        for (ModelSetListener modelSetListener : this.modelSetListeners.keySet()) {
            modelSetListener.modelChanged(model);
        }
    }

    protected void fireModelProjectChanged() {
        for (ModelSetListener modelSetListener : this.modelSetListeners.keySet()) {
            modelSetListener.modelProjectChanged();
        }
    }

    protected void fireModelRemoved(Model model) {
        for (ModelSetListener modelSetListener : this.modelSetListeners.keySet()) {
            modelSetListener.modelRemoved(model);
        }
    }

    protected void addModel(FileObject fileObject, Model model) {
        this.models.put(fileObject, model);
        this.fireModelAdded(model);
    }

    void addToModelsToSync(Model model) {
        if (this.modelsToSync == null) {
            this.modelsToSync = new HashSet();
        }
        this.modelsToSync.add(model);
    }

    public void removeFromModelsToSync(Model model) {
        if (this.modelsToSync != null) {
            this.modelsToSync.remove(model);
        }
    }

    protected void syncAll() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.modelsToSync == null) {
            Object object;
            this.modelsToSync = new HashSet();
            Model model = this.configModel;
            if (model.isValid() && ((ParserAnnotation[])(object = model.getErrors())).length > 0) {
                int n = ((Object)object).length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(object[i]);
                }
            }
            object = this.evalOrderModels(this.getModelsMap().values());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                model = (Model)iterator.next();
                if (!model.isValid()) continue;
                model.sync();
                ParserAnnotation[] parserAnnotationArray = model.getErrors();
                if (parserAnnotationArray.length <= 0) continue;
                int n = parserAnnotationArray.length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(parserAnnotationArray[i]);
                }
            }
        } else {
            Iterator iterator = this.modelsToSync.iterator();
            while (iterator.hasNext()) {
                Model model = (Model)iterator.next();
                iterator.remove();
                model.sync();
                ParserAnnotation[] parserAnnotationArray = model.getErrors();
                if (parserAnnotationArray.length <= 0) continue;
                int n = parserAnnotationArray.length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(parserAnnotationArray[i]);
                }
            }
        }
        if (arrayList.size() > 0) {
            this.showSyncErrors(arrayList, true);
        }
    }

    protected void releaseProjectClassLoader() {
        if (this.classLoader != null) {
            this.classLoader = null;
        }
        if (this.classPath != null) {
            this.classPath.removePropertyChangeListener((PropertyChangeListener)this.classPathListener);
            this.classPathListener = null;
            this.classPath = null;
        }
    }

    protected void showSyncErrors(ArrayList arrayList, boolean bl) {
        if (arrayList.size() == 0) {
            return;
        }
        if (bl) {
            InSyncServiceProvider.get().getRaveErrorHandler().displayError(NbBundle.getMessage(ModelSet.class, (String)"TXT_ErrorsOnOpenProject1"));
            InSyncServiceProvider.get().getRaveErrorHandler().displayError(NbBundle.getMessage(ModelSet.class, (String)"TXT_ErrorsOnOpenProject2"));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer(200);
            ParserAnnotation parserAnnotation = (ParserAnnotation)iterator.next();
            if (parserAnnotation.getFileObject() == null) {
                stringBuffer.append("unknown");
            } else {
                stringBuffer.append(parserAnnotation.getFileObject().getNameExt());
            }
            stringBuffer.append(':');
            stringBuffer.append(parserAnnotation.getLine());
            stringBuffer.append(':');
            stringBuffer.append(parserAnnotation.getColumn());
            stringBuffer.append(':');
            stringBuffer.append(' ');
            stringBuffer.append(parserAnnotation.getMessage());
            InSyncServiceProvider.get().getRaveErrorHandler().displayErrorForFileObject(stringBuffer.toString(), parserAnnotation.getFileObject(), parserAnnotation.getLine(), parserAnnotation.getColumn());
        }
        InSyncServiceProvider.get().getRaveErrorHandler().selectErrors();
    }

    protected void flushAll() {
        Iterator iterator = this.getModelsMap().values().iterator();
        while (iterator.hasNext()) {
            ((Model)iterator.next()).flush();
        }
    }

    protected void saveAll() {
        Iterator iterator = this.getModelsMap().values().iterator();
        while (iterator.hasNext()) {
            ((Model)iterator.next()).saveUnits();
        }
    }

    public void classPathChanged() {
        this.releaseProjectClassLoader();
        this.getProjectClassLoader();
    }

    protected Collection evalOrderModels(Collection collection) {
        return collection;
    }

    protected FileObject getLocalFileObject(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (fileObject.isVirtual()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        if (SharabilityQuery.getSharability((File)file) == 2) {
            return null;
        }
        if (ModelSet.hasActiveLockFileSigns(fileObject)) {
            return null;
        }
        FileObject fileObject2 = this.getProject().getProjectDirectory();
        if (fileObject2 == null || !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return null;
        }
        return fileObject;
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = this.getLocalFileObject(fileEvent.getFile());
        if (fileObject == null) {
            return;
        }
        if (fileObject.getAttribute("NBIssue81746Workaround") == Boolean.TRUE) {
            try {
                fileObject.setAttribute("NBIssue81746Workaround", null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        this.processFileDataCreated(fileObject);
    }

    private FileObject getOurFileObject(FileObject fileObject) {
        if ((fileObject = this.getLocalFileObject(fileObject)) == null) {
            return null;
        }
        if (!FileUtil.isParentOf((FileObject)JsfProjectUtils.getDocumentRoot((Project)this.getProject()), (FileObject)fileObject) && !FileUtil.isParentOf((FileObject)JsfProjectUtils.getSourceRoot((Project)this.getProject()), (FileObject)fileObject)) {
            return null;
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFileDataCreated(FileObject fileObject) {
        if (!FileUtil.isParentOf((FileObject)JsfProjectUtils.getDocumentRoot((Project)this.getProject()), (FileObject)fileObject) && !FileUtil.isParentOf((FileObject)JsfProjectUtils.getSourceRoot((Project)this.getProject()), (FileObject)fileObject)) {
            return;
        }
        ModelCreateVisitor modelCreateVisitor = new ModelCreateVisitor();
        if (fileObject.isFolder()) {
            modelCreateVisitor.traverse(fileObject);
        } else {
            modelCreateVisitor.visit(fileObject);
        }
        List list = modelCreateVisitor.getModelsAdded();
        for (Model model : list) {
            FileObject fileObject2 = model.getFile();
            try {
                fileObject2.setAttribute("NewFile", (Object)Boolean.TRUE);
                model.sync();
            }
            catch (IOException iOException) {
                assert (Trace.trace((String)"insync.model", (String)("Failed to set the attribute: " + model.getFile())));
            }
            finally {
                block18: {
                    try {
                        fileObject2.setAttribute("NewFile", null);
                    }
                    catch (IOException iOException) {
                        if ($assertionsDisabled || Trace.trace((String)"insync.model", (String)("Failed to reset the attribute: " + model.getFile()))) break block18;
                        throw new AssertionError();
                    }
                }
            }
            if (model.isValid()) {
                model.saveUnits();
                continue;
            }
            this.models.remove(fileObject2);
            model = null;
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        String string = fileRenameEvent.getName();
        String string2 = fileObject.getName();
        String string3 = fileObject.getExt();
        boolean bl = this.getLocalFileObject(fileObject) == null;
        Model[] modelArray = this.getModels();
        for (int i = 0; i < modelArray.length; ++i) {
            Model model = modelArray[i];
            model.fileRenamed(string, string2, string3, fileObject, bl);
        }
    }

    public void removeModel(Model model) {
        FileObject fileObject = model.getFile();
        this.models.remove(fileObject);
        this.fireModelRemoved(model);
        model.destroy();
    }

    static {
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)new OpenProjectsListener());
        modelSetsListeners = new ArrayList();
        sets = new IdentityHashMap();
        projectToRunnable = new HashMap<Project, Runnable>();
    }

    private class ModelSetOperationListener
    implements OperationListener {
        private ModelSetOperationListener() {
        }

        public void operationPostCreate(OperationEvent operationEvent) {
        }

        public void operationCopy(OperationEvent.Copy copy) {
        }

        public void operationMove(OperationEvent.Move move) {
        }

        public void operationDelete(OperationEvent operationEvent) {
            FileObject fileObject = ModelSet.this.getLocalFileObject(operationEvent.getObject().getPrimaryFile());
            if (fileObject == null) {
                return;
            }
            final Model model = ModelSet.this.getModel(fileObject);
            if (model != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ModelSet modelSet = model.getOwner();
                        if (modelSet != null) {
                            modelSet.removeModel(model);
                        }
                    }
                });
            }
        }

        public void operationRename(OperationEvent.Rename rename) {
        }

        public void operationCreateShadow(OperationEvent.Copy copy) {
        }

        public void operationCreateFromTemplate(OperationEvent.Copy copy) {
            FileObject fileObject = ModelSet.this.getOurFileObject(copy.getObject().getPrimaryFile());
            if (fileObject == null) {
                return;
            }
            ModelSet.this.processFileDataCreated(fileObject);
        }
    }

    class ModelCreateVisitor
    extends FileObjectVisitor {
        protected ArrayList modelsAdded = new ArrayList();

        ModelCreateVisitor() {
        }

        protected void visitImpl(FileObject fileObject) {
            if (!ModelSet.this.models.containsKey(fileObject)) {
                for (Model.Factory factory : ModelSet.getFactories()) {
                    Model model = factory.newInstance(ModelSet.this, fileObject);
                    if (model == null) continue;
                    ModelSet.this.addModel(model.getFile(), model);
                    this.modelsAdded.add(model);
                    break;
                }
            }
        }

        public List getModelsAdded() {
            return this.modelsAdded;
        }
    }

    class ClassPathListener
    implements PropertyChangeListener {
        ClassPathListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ModelSet.this.classPathChanged();
        }
    }

    private static class ProjectClassLoader
    extends URLClassLoader {
        private final URL[] urls;
        private static final Logger TIMERS = Logger.getLogger("TIMER.visualweb");

        public ProjectClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
            this.urls = uRLArray;
            if (TIMERS.isLoggable(Level.FINER)) {
                LogRecord logRecord = new LogRecord(Level.FINER, "ModelSet$ProjectClassLoader");
                logRecord.setParameters(new Object[]{this});
                TIMERS.log(logRecord);
            }
        }

        public String toString() {
            return super.toString() + "[urls=" + (this.urls == null ? null : Arrays.asList(this.urls)) + "]";
        }
    }

    protected static class OpenProjectsListener
    implements PropertyChangeListener {
        protected OpenProjectsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
                Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
                IdentityHashMap<Project, Project> identityHashMap = new IdentityHashMap<Project, Project>();
                for (int i = 0; i < projectArray.length; ++i) {
                    identityHashMap.put(projectArray[i], projectArray[i]);
                }
                ArrayList<ModelSet> arrayList = new ArrayList<ModelSet>();
                IdentityHashMap identityHashMap2 = sets;
                synchronized (identityHashMap2) {
                    for (Project project : sets.keySet()) {
                        if (identityHashMap.containsKey(project)) continue;
                        ModelSet modelSet = (ModelSet)sets.get(project);
                        arrayList.add(modelSet);
                    }
                }
                for (ModelSet modelSet : arrayList) {
                    modelSet.destroy();
                    ModelSet.fireModelSetRemoved(modelSet);
                }
            }
        }
    }
}

