/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.xml.text.navigator.FilterActions;
import org.netbeans.modules.xml.text.navigator.FiltersDescription;
import org.netbeans.modules.xml.text.navigator.FiltersManager;
import org.netbeans.modules.xml.text.navigator.NavigatorTreeCellRenderer;
import org.netbeans.modules.xml.text.navigator.TapPanel;
import org.netbeans.modules.xml.text.navigator.TreeNodeAdapter;
import org.netbeans.modules.xml.text.navigator.base.AbstractXMLNavigatorContent;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class NavigatorContent
extends AbstractXMLNavigatorContent {
    private static final boolean DEBUG = false;
    static boolean showAttributes = true;
    static boolean showContent = true;
    private DataObject peerDO = null;
    private WeakHashMap uiCache = new WeakHashMap();
    private boolean editorOpened = false;

    public NavigatorContent() {
        this.setLayout(new BorderLayout());
    }

    public void navigate(DataObject dataObject) {
        EditorCookie editorCookie;
        if (this.peerDO != null && this.peerDO != dataObject) {
            this.closeDocument(this.peerDO);
        }
        if ((editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) == null) {
            ErrorManager.getDefault().log(1, "The DataObject " + dataObject.getName() + "(class=" + dataObject.getClass().getName() + ") has no EditorCookie!?");
        } else {
            try {
                BaseDocument baseDocument = (BaseDocument)editorCookie.openDocument();
                if (baseDocument != null) {
                    this.navigate(dataObject, baseDocument);
                    this.peerDO = dataObject;
                    this.editorOpened = editorCookie.getOpenedPanes() != null && editorCookie.getOpenedPanes().length > 0;
                }
            }
            catch (UserQuestionException userQuestionException) {
                this.showError(AbstractXMLNavigatorContent.ERROR_TOO_LARGE_DOCUMENT);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public void navigate(final DataObject dataObject, final BaseDocument baseDocument) {
        NavigatorContentPanel navigatorContentPanel;
        this.showWaitPanel();
        WeakReference weakReference = (WeakReference)this.uiCache.get(dataObject);
        if (weakReference != null) {
            NavigatorContentPanel navigatorContentPanel2 = (NavigatorContentPanel)weakReference.get();
            if (navigatorContentPanel2 != null) {
                NavigatorContentPanel navigatorContentPanel3 = navigatorContentPanel = baseDocument == navigatorContentPanel2.getDocument() ? navigatorContentPanel2 : null;
                if (navigatorContentPanel == null) {
                    this.uiCache.remove(dataObject);
                }
            } else {
                navigatorContentPanel = null;
            }
        } else {
            navigatorContentPanel = null;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    final DocumentModel documentModel = navigatorContentPanel == null ? DocumentModel.getDocumentModel((Document)baseDocument) : null;
                    if (navigatorContentPanel != null || documentModel != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                NavigatorContent.this.showWaitPanel();
                                JPanel jPanel = null;
                                if (navigatorContentPanel == null) {
                                    try {
                                        documentModel.readLock();
                                        jPanel = new NavigatorContentPanel(documentModel);
                                        NavigatorContent.this.uiCache.put(dataObject, new WeakReference<JPanel>(jPanel));
                                        EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
                                        if (observable != null) {
                                            observable.addPropertyChangeListener((PropertyChangeListener)NavigatorContent.this);
                                        }
                                        ErrorManager.getDefault().log(1, "The DataObject " + dataObject.getName() + "(class=" + dataObject.getClass().getName() + ") has no EditorCookie.Observable!");
                                    }
                                    finally {
                                        documentModel.readUnlock();
                                    }
                                } else {
                                    jPanel = navigatorContentPanel;
                                }
                                NavigatorContent.this.removeAll();
                                NavigatorContent.this.add((Component)jPanel, "Center");
                                NavigatorContent.this.revalidate();
                                NavigatorContent.this.repaint();
                            }
                        });
                    } else {
                        NavigatorContent.this.showError(AbstractXMLNavigatorContent.ERROR_CANNOT_NAVIGATE);
                    }
                }
                catch (DocumentModelException documentModelException) {
                    ErrorManager.getDefault().notify(1, (Throwable)documentModelException);
                }
            }
        });
    }

    public void release() {
        this.removeAll();
        this.repaint();
        this.closeDocument(this.peerDO);
    }

    private void closeDocument(DataObject dataObject) {
        EditorCookie editorCookie;
        if (dataObject != null && (editorCookie = (EditorCookie)this.peerDO.getCookie(EditorCookie.class)) != null) {
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
                ((EditorCookie.Observable)editorCookie).removePropertyChangeListener((PropertyChangeListener)this);
                if (this.editorOpened) {
                    editorCookie.close();
                }
            }
            this.editorOpened = false;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "document") {
            if (propertyChangeEvent.getNewValue() == null) {
                final DataObject dataObject = ((DataEditorSupport)propertyChangeEvent.getSource()).getDataObject();
                if (dataObject != null) {
                    this.editorOpened = false;
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    if (editorCookie != null) {
                        ((EditorCookie.Observable)editorCookie).removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (dataObject.isValid()) {
                                NavigatorContent.this.navigate(dataObject);
                            }
                        }
                    });
                }
            } else {
                this.editorOpened = true;
            }
        }
    }

    private class NavigatorContentPanel
    extends JPanel
    implements FiltersManager.FilterChangeListener {
        private JTree tree;
        private FiltersManager filters;
        private Document doc;
        public static final String ATTRIBUTES_FILTER = "attrs";
        public static final String CONTENT_FILTER = "content";

        public NavigatorContentPanel(DocumentModel documentModel) {
            this.doc = documentModel.getDocument();
            this.setLayout(new BorderLayout());
            this.tree = new PatchedJTree();
            TreeModel treeModel = this.createTreeModel(documentModel);
            this.tree.setModel(treeModel);
            this.tree.setShowsRootHandles(true);
            this.tree.setRootVisible(false);
            this.tree.setCellRenderer(new NavigatorTreeCellRenderer());
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = NavigatorContentPanel.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1) {
                        TreePath treePath = NavigatorContentPanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                        TreeNodeAdapter treeNodeAdapter = (TreeNodeAdapter)treePath.getLastPathComponent();
                        if (mouseEvent.getClickCount() == 2) {
                            NavigatorContentPanel.this.openAndFocusElement(treeNodeAdapter, false);
                        }
                        if (mouseEvent.getClickCount() == 1) {
                            NavigatorContentPanel.this.openAndFocusElement(treeNodeAdapter, true);
                        }
                    }
                }
            };
            this.tree.addMouseListener(mouseAdapter);
            final DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
            defaultTreeSelectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(defaultTreeSelectionModel);
            this.tree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "open");
            this.tree.getActionMap().put("open", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath treePath = defaultTreeSelectionModel.getLeadSelectionPath();
                    TreeNodeAdapter treeNodeAdapter = (TreeNodeAdapter)treePath.getLastPathComponent();
                    NavigatorContentPanel.this.openAndFocusElement(treeNodeAdapter, false);
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)jScrollPane, "Center");
            TapPanel tapPanel = new TapPanel();
            JLabel jLabel = new JLabel(NbBundle.getMessage(NavigatorContent.class, (String)"LBL_Filter"));
            jLabel.setBorder(new EmptyBorder(0, 5, 5, 0));
            tapPanel.add(jLabel);
            tapPanel.setOrientation(2);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            String string = Utilities.keyToString((KeyStroke)keyStroke);
            tapPanel.setToolTipText(NbBundle.getMessage(NavigatorContent.class, (String)"TIP_TapPanel", (Object)string));
            this.filters = this.createFilters();
            this.filters.hookChangeListener(this);
            tapPanel.add(this.filters.getComponent());
            this.add((Component)tapPanel, "South");
            MouseAdapter mouseAdapter2 = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1 && mouseEvent.getModifiers() == 4) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        JMenuItem[] jMenuItemArray = new FilterActions(NavigatorContentPanel.this.filters).createMenuItems();
                        for (int i = 0; i < jMenuItemArray.length; ++i) {
                            jPopupMenu.add(jMenuItemArray[i]);
                        }
                        jPopupMenu.pack();
                        jPopupMenu.show(NavigatorContentPanel.this.tree, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            };
            this.tree.addMouseListener(mouseAdapter2);
            TreeNode treeNode = (TreeNode)treeModel.getRoot();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = treeNode.getChildAt(i);
                if (treeNode2.getChildCount() <= 0) continue;
                this.tree.expandPath(new TreePath(new TreeNode[]{treeNode, treeNode2}));
            }
        }

        public Document getDocument() {
            return this.doc;
        }

        private void openAndFocusElement(final TreeNodeAdapter treeNodeAdapter, final boolean bl) {
            BaseDocument baseDocument = (BaseDocument)treeNodeAdapter.getDocumentElement().getDocument();
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
            if (dataObject == null) {
                return;
            }
            final EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
            if (observable == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JEditorPane[] jEditorPaneArray = observable.getOpenedPanes();
                    if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                        NavigatorContentPanel.this.selectElementInPane(jEditorPaneArray[0], treeNodeAdapter, !bl);
                    } else if (!bl) {
                        observable.open();
                        try {
                            observable.openDocument();
                            jEditorPaneArray = observable.getOpenedPanes();
                            if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                                NavigatorContentPanel.this.selectElementInPane(jEditorPaneArray[0], treeNodeAdapter, true);
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
            });
        }

        private void selectElementInPane(final JEditorPane jEditorPane, final TreeNodeAdapter treeNodeAdapter, boolean bl) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    jEditorPane.setCaretPosition(treeNodeAdapter.getDocumentElement().getStartOffset());
                }
            });
            if (bl) {
                Container container = jEditorPane;
                while (!(container instanceof TopComponent)) {
                    container = container.getParent();
                }
                ((TopComponent)container).requestActive();
            }
        }

        private TreeModel createTreeModel(DocumentModel documentModel) {
            DocumentElement documentElement = documentModel.getRootElement();
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(null);
            TreeNodeAdapter treeNodeAdapter = new TreeNodeAdapter(documentElement, defaultTreeModel, this.tree, null);
            defaultTreeModel.setRoot(treeNodeAdapter);
            return defaultTreeModel;
        }

        private FiltersManager createFilters() {
            FiltersDescription filtersDescription = new FiltersDescription();
            filtersDescription.addFilter(ATTRIBUTES_FILTER, NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowAttributes"), NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowAttributesTip"), showAttributes, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/a.png")), null);
            filtersDescription.addFilter(CONTENT_FILTER, NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowContent"), NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowContentTip"), showContent, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/content.png")), null);
            return FiltersDescription.createManager(filtersDescription);
        }

        public void filterStateChanged(ChangeEvent changeEvent) {
            showAttributes = this.filters.isSelected(ATTRIBUTES_FILTER);
            showContent = this.filters.isSelected(CONTENT_FILTER);
            this.tree.repaint();
        }

        private class PatchedJTree
        extends JTree {
            private boolean firstPaint = true;

            public void paint(Graphics graphics) {
                if (this.firstPaint) {
                    int n = graphics.getFontMetrics(this.getFont()).getHeight();
                    this.setRowHeight(n + 2);
                    this.firstPaint = false;
                }
                super.paint(graphics);
            }
        }
    }
}

