/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.xml.text.completion.XMLCompletionResultItemPaintComponent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;

class XMLResultItem
implements CompletionQuery.ResultItem,
CompletionItem {
    private static final int XML_ITEMS_SORT_PRIORITY = 20;
    public String displayText;
    private String replacementText;
    public Icon icon;
    public Color foreground = Color.black;
    public Color background = Color.white;
    public Color selectionForeground = Color.black;
    public Color selectionBackground = new Color(204, 204, 255);
    private static JLabel rubberStamp = new JLabel();
    private XMLCompletionResultItemPaintComponent component;
    private boolean shift = false;
    static int substituteOffset;

    public XMLResultItem(String string) {
        this(string, null);
    }

    public XMLResultItem(String string, String string2) {
        this.replacementText = string;
        this.displayText = string2 != null ? string2 : string;
    }

    public XMLResultItem(String string, Icon icon, Color color, Color color2, Color color3, Color color4) {
        this.displayText = string;
        this.icon = icon;
        this.foreground = color;
        this.background = color2;
        this.selectionForeground = color3;
        this.selectionBackground = color4;
    }

    public String getReplacementText(int n) {
        return this.displayText;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceText(JTextComponent jTextComponent, String string, int n, int n2) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        baseDocument.atomicLock();
        try {
            String string2 = baseDocument.getText(n, baseDocument.getLength() - n < string.length() ? baseDocument.getLength() - n : string.length());
            if (!string.equals(string2)) {
                baseDocument.remove(n, n2);
                baseDocument.insertString(n, string, null);
            } else {
                int n3 = jTextComponent.getCaret().getDot() + string.length() - n2;
                jTextComponent.setCaretPosition(n3 < baseDocument.getLength() ? n3 : baseDocument.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            boolean bl = false;
            return bl;
        }
        finally {
            baseDocument.atomicUnlock();
        }
        return true;
    }

    public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return this.replaceText(jTextComponent, this.getReplacementText(0).substring(0, n3), n, n2);
    }

    public final boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        int n3 = bl ? 1 : 0;
        return this.substituteText(jTextComponent, n, n2, n3);
    }

    public boolean substituteText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return this.replaceText(jTextComponent, this.getReplacementText(n3), n, n2);
    }

    public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
        if (this.getIcon() != null) {
            rubberStamp.setIcon(this.getIcon());
        }
        rubberStamp.setText(this.displayText);
        if (bl) {
            rubberStamp.setBackground(this.selectionBackground);
            rubberStamp.setForeground(this.selectionForeground);
        } else {
            rubberStamp.setBackground(this.background);
            rubberStamp.setForeground(this.foreground);
        }
        return rubberStamp;
    }

    public final String getItemText() {
        return this.replacementText;
    }

    public String toString() {
        return this.getItemText();
    }

    Color getPaintColor() {
        return Color.BLUE;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        int n = this.getSubstituteOffset();
        if (n == -1) {
            n = jTextComponent.getCaretPosition();
        }
        if (!this.shift) {
            Completion.get().hideAll();
        }
        this.substituteText(jTextComponent, n, jTextComponent.getCaretPosition() - n, this.shift);
    }

    public int getSubstituteOffset() {
        return substituteOffset;
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public Component getPaintComponent(boolean bl) {
        XMLCompletionResultItemPaintComponent.StringPaintComponent stringPaintComponent = new XMLCompletionResultItemPaintComponent.StringPaintComponent(this.getPaintColor());
        stringPaintComponent.setSelected(bl);
        stringPaintComponent.setString(this.getItemText());
        return stringPaintComponent;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        Component component = this.getPaintComponent(false);
        return component.getPreferredSize().width;
    }

    public int getSortPriority() {
        return 20;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.shift = keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401 && keyEvent.isShiftDown();
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        Component component = this.getPaintComponent(bl);
        component.setFont(font);
        component.setForeground(color);
        component.setBackground(color2);
        component.setBounds(0, 0, n, n2);
        ((XMLCompletionResultItemPaintComponent)component).paintComponent(graphics);
    }

    static {
        rubberStamp.setOpaque(true);
        substituteOffset = -1;
    }
}

