/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.util;

import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import com.sun.tools.ws.processor.model.java.JavaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.api.WebProjectLibrariesModifier;
import org.netbeans.modules.websvc.manager.spi.WebServiceManagerExt;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerUtil {
    public static final int BUFFER_SIZE = 4096;
    public static final String xsdNamespace = "xsd";
    public static final String WSDL_FILE_EXTENSION = "wsdl";
    public static final String LOCALIZING_BUNDLE = "SystemFileSystem.localizingBundle";
    private static final String[] PRIMITIVE_WRAPPER_CLASSES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Character", "java.lang.String"};
    private static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "char"};
    public static final String PATH_LIBRARIES = "lib";
    public static final String PATH_IN_WAR_LIB = "WEB-INF/lib";
    private static Lookup.Result<WebServiceManagerExt> extensionsResult = null;

    public static boolean isJAXRPCAvailable() {
        return ManagerUtil.getWebServiceSupportLibDef(false) != null;
    }

    public static Library getWebServiceSupportLibDef(boolean bl) {
        String string = bl ? "jaxws21" : "jaxrpc16";
        Library library = LibraryManager.getDefault().getLibrary(string);
        return library;
    }

    public static Method getPropertyGetter(String string, String string2, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            char[] cArray = string2.toCharArray();
            String string3 = null;
            Method method = null;
            for (int i = 0; i < string2.length() && method == null; ++i) {
                cArray[i] = Character.toUpperCase(cArray[i]);
                string3 = new String(cArray);
                try {
                    method = clazz.getMethod("get" + string3, new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = clazz.getMethod("is" + string3, new Class[0]);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                }
            }
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isPrimitiveType(String string) {
        for (int i = 0; i < PRIMITIVE_WRAPPER_CLASSES.length; ++i) {
            if (!PRIMITIVE_WRAPPER_CLASSES[i].equals(string)) continue;
            return true;
        }
        return ManagerUtil.isJavaPrimitive(string);
    }

    public static boolean isJavaPrimitive(String string) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getWrapperForPrimitive(String string) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(string)) continue;
            return PRIMITIVE_WRAPPER_CLASSES[i];
        }
        return null;
    }

    public static boolean hasOutput(JavaMethod javaMethod) {
        JavaType javaType = javaMethod.getReturnType();
        if (!"void".equals(javaType.getRealName())) {
            return true;
        }
        return ManagerUtil.getOutputHolderIndex(javaMethod) >= 0;
    }

    public static int getOutputHolderIndex(JavaMethod javaMethod) {
        List list = javaMethod.getParametersList();
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            JavaParameter javaParameter = (JavaParameter)list.get(i);
            if (!javaParameter.isHolder() || !javaParameter.getParameter().isOUT() && !javaParameter.getParameter().isINOUT()) continue;
            return i;
        }
        return -1;
    }

    public static String typeToString(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getOwnerType() != null) {
                return null;
            }
            Type type2 = parameterizedType.getRawType();
            if (!(type2 instanceof Class)) {
                return null;
            }
            Class clazz = (Class)type2;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray == null || typeArray.length == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < typeArray.length; ++i) {
                String string = ManagerUtil.typeToString(typeArray[0]);
                if (string == null) {
                    return null;
                }
                stringBuffer.append(string);
                if (i == typeArray.length - 1) continue;
                stringBuffer.append(',');
            }
            return clazz.getCanonicalName() + "<" + stringBuffer.toString() + ">";
        }
        if (type instanceof GenericArrayType) {
            String string = ManagerUtil.typeToString(((GenericArrayType)type).getGenericComponentType());
            if (string != null) {
                return string + "[]";
            }
        } else if (type instanceof Class) {
            return ((Class)type).getCanonicalName();
        }
        return null;
    }

    public static String removeNamespace(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String makeValidJavaBeanName(String string) {
        char[] cArray = string.toCharArray();
        if (!(string.length() <= 1 || Character.isUpperCase(cArray[0]) && Character.isUpperCase(cArray[1]))) {
            cArray[0] = Character.toLowerCase(cArray[0]);
            cArray[1] = Character.toLowerCase(cArray[1]);
        } else if (string.length() == 1 && Character.isUpperCase(cArray[0])) {
            cArray[0] = Character.toLowerCase(cArray[0]);
        }
        return new String(cArray);
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static boolean isAcronyn(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        return Character.isUpperCase(cArray[0]) && Character.isUpperCase(cArray[1]);
    }

    public static String changeString(String string, String string2, String string3) {
        if (string2.trim().equals("")) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        n2 = string.indexOf(string2, n);
        while (n2 != -1) {
            stringBuffer.append(string.substring(n, n2) + string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String upperCaseFirstChar(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null string passed!");
        }
        String string2 = new String(string);
        String string3 = string2.substring(0, 1);
        string2 = string3.toUpperCase() + string2.substring(1);
        return string2;
    }

    public static String getProperPortName(String string) {
        String string2 = "";
        if (string.indexOf(".") == -1) {
            string2 = ManagerUtil.upperCaseFirstChar(string);
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 + ManagerUtil.upperCaseFirstChar(string3);
        }
        return string2;
    }

    public static boolean isValidPackageName(String string) {
        if (null == string || string.length() == 0) {
            return false;
        }
        if (string.indexOf("$") != -1) {
            return false;
        }
        if (string.charAt(0) == '.') {
            return false;
        }
        if (string.charAt(string.length() - 1) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
                    return false;
                }
                for (int i = 0; i < string2.length(); ++i) {
                    if (Character.isJavaIdentifierPart(string2.charAt(i))) continue;
                    return false;
                }
            }
        } else {
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIdentifier(String string) {
        if (null == string || string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getParameterType(JavaParameter javaParameter) {
        String string = null;
        string = javaParameter.isHolder() ? javaParameter.getHolderName() : javaParameter.getType().getName();
        return string;
    }

    public static String getFileName(String string) {
        return new File(string).getName();
    }

    public static List<URL> buildClasspath(File file, boolean bl) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Properties properties = new Properties();
        properties.load(new FileInputStream(System.getProperty("netbeans.user") + "/build.properties"));
        if (file != null) {
            arrayList.add(file.toURI().toURL());
        }
        File file2 = new File(System.getProperty("java.home")).getParentFile();
        file2 = new File(file2, PATH_LIBRARIES + File.separator + "tools.jar");
        arrayList.add(file2.toURI().toURL());
        String string = System.getProperty("path.separator");
        String string2 = properties.getProperty("libs.jsf12-support.classpath");
        String string3 = bl ? "libs.jaxws21.classpath" : "libs.jaxrpc16.classpath";
        string2 = properties.getProperty(string3) + string + string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            File file3 = new File(string4);
            arrayList.add(file3.toURI().toURL());
        }
        return arrayList;
    }

    public static FileObject getProjectLibraryDirectory(Project project) throws IOException {
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject(PATH_LIBRARIES);
        if (fileObject2 == null) {
            fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)PATH_LIBRARIES);
        }
        return fileObject2;
    }

    public static boolean hasLibraryReference(Project project, Library library, String string) {
        List list = library.getContent("classpath");
        if (list.isEmpty()) {
            return false;
        }
        URL uRL = (URL)list.get(0);
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            return false;
        }
        string = "classpath/compile";
        ClassPath classPath = ClassPath.getClassPath((FileObject)ManagerUtil.getSourceRoot(project), (String)string);
        return classPath.contains(fileObject);
    }

    public static FileObject getSourceRoot(Project project) {
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!"${src.dir}".equals(sourceGroupArray[i].getName())) continue;
            return sourceGroupArray[i].getRootFolder();
        }
        if (sourceGroupArray.length != 0) {
            return sourceGroupArray[0].getRootFolder();
        }
        return null;
    }

    public static boolean addLibraryReferences(Project project, Library[] libraryArray) throws IOException {
        try {
            return ProjectClassPathModifier.addLibraries((Library[])libraryArray, (FileObject)ManagerUtil.getSourceRoot(project), (String)"classpath/compile");
        }
        catch (IOException iOException) {
            Logger.getLogger(ManagerUtil.class.getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            return false;
        }
    }

    public static boolean addLibraryReferences(Project project, Library[] libraryArray, String string) throws IOException {
        WebProjectLibrariesModifier webProjectLibrariesModifier = (WebProjectLibrariesModifier)project.getLookup().lookup(WebProjectLibrariesModifier.class);
        if (webProjectLibrariesModifier == null) {
            return ManagerUtil.addLibraryReferences(project, libraryArray);
        }
        if (string.equals("classpath/compile")) {
            return webProjectLibrariesModifier.addCompileLibraries(libraryArray);
        }
        if (string.equals("classpath/execute")) {
            return webProjectLibrariesModifier.addPackageLibraries(libraryArray, PATH_IN_WAR_LIB);
        }
        return false;
    }

    public static boolean removeLibraryReferences(Project project, Library[] libraryArray) throws IOException {
        try {
            return ProjectClassPathModifier.removeLibraries((Library[])libraryArray, (FileObject)ManagerUtil.getSourceRoot(project), (String)"classpath/compile");
        }
        catch (IOException iOException) {
            Logger.getLogger(ManagerUtil.class.getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            return false;
        }
    }

    public static boolean hasRootReference(Project project, URL uRL) {
        return ManagerUtil.hasRootReference(project, uRL, "classpath/compile");
    }

    public static boolean hasRootReference(Project project, URL uRL, String string) {
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            return false;
        }
        string = "classpath/compile";
        ClassPath classPath = ClassPath.getClassPath((FileObject)ManagerUtil.getSourceRoot(project), (String)string);
        return classPath.contains(fileObject);
    }

    public static boolean addRootReferences(Project project, URL[] uRLArray) throws IOException {
        try {
            return ProjectClassPathModifier.addRoots((URL[])uRLArray, (FileObject)ManagerUtil.getSourceRoot(project), (String)"classpath/compile");
        }
        catch (IOException iOException) {
            Logger.getLogger(ManagerUtil.class.getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            return false;
        }
    }

    public static boolean isJavaEE5Project(Project project) {
        if (project == null) {
            return false;
        }
        return "1.5".equals(ManagerUtil.getJ2eePlatformVersion(project));
    }

    public static String getJ2eePlatformVersion(Project project) {
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule == null) {
            return "";
        }
        return webModule.getJ2eePlatformVersion();
    }

    public static Collection<? extends WebServiceManagerExt> getExtensions() {
        if (extensionsResult == null) {
            extensionsResult = Lookup.getDefault().lookupResult(WebServiceManagerExt.class);
        }
        return extensionsResult.allInstances();
    }

    public static String getLocalizedName(FileObject fileObject) {
        String string = fileObject.getNameExt();
        String string2 = (String)fileObject.getAttribute(LOCALIZING_BUNDLE);
        if (string2 != null) {
            try {
                string2 = Utilities.translate((String)string2);
                ResourceBundle resourceBundle = NbBundle.getBundle((String)string2);
                String string3 = resourceBundle.getString(fileObject.getPath());
                if (string3 != null) {
                    string = string3;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }
}

