/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.Actions;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.netbeans.modules.ant.freeform.ui.ProjectNodeWrapper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public final class View
implements LogicalViewProvider {
    private final FreeformProject project;

    public View(FreeformProject freeformProject) {
        this.project = freeformProject;
    }

    public Node createLogicalView() {
        return new ProjectNodeWrapper((Node)new RootNode(this.project));
    }

    public Node findPath(Node node, Object object) {
        Node[] nodeArray;
        for (Node node2 : nodeArray = node.getChildren().getNodes(true)) {
            Node node3;
            ProjectNature projectNature;
            DataObject dataObject = Lookup.getDefault().lookupAll(ProjectNature.class).iterator();
            while (dataObject.hasNext()) {
                projectNature = (ProjectNature)dataObject.next();
                node3 = projectNature.findSourceFolderViewPath(this.project, node2, object);
                if (node3 == null) continue;
                return node3;
            }
            if (!(object instanceof DataObject) && !(object instanceof FileObject) || (dataObject = (DataObject)node2.getLookup().lookup(DataObject.class)) == null) continue;
            projectNature = dataObject.getPrimaryFile();
            FileObject fileObject = node3 = object instanceof DataObject ? ((DataObject)object).getPrimaryFile() : (FileObject)object;
            if (projectNature == node3) {
                return node2;
            }
            if (!FileUtil.isParentOf((FileObject)projectNature, (FileObject)node3)) continue;
            String string = FileUtil.getRelativePath((FileObject)projectNature, (FileObject)node3);
            ArrayList arrayList = Collections.list(NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(string, "/"), String.class, (boolean)true));
            arrayList.set(arrayList.size() - 1, node3.getName());
            try {
                return NodeOp.findPath((Node)node2, Collections.enumeration(arrayList));
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private static final class RootNode
    extends AbstractNode {
        private final FreeformProject p;

        public RootNode(FreeformProject freeformProject) {
            super(NodeFactorySupport.createCompositeChildren((Project)freeformProject, (String)"Projects/org-netbeans-modules-ant-freeform/Nodes"), Lookups.singleton((Object)freeformProject));
            this.p = freeformProject;
        }

        public String getName() {
            return ProjectUtils.getInformation((Project)this.p).getName();
        }

        public String getDisplayName() {
            return ProjectUtils.getInformation((Project)this.p).getDisplayName();
        }

        public Image getIcon(int n) {
            return Utilities.icon2Image((Icon)ProjectUtils.getInformation((Project)this.p).getIcon());
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public Action[] getActions(boolean bl) {
            return Actions.createContextMenu(this.p);
        }

        public boolean canRename() {
            return true;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.p, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("freeform.node." + Util.getMergedHelpIDFragments(this.p));
        }
    }
}

