/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.spi.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.spi.ProjectAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String NAMESPACE = "http://www.netbeans.org/ns/freeform-project/2";
    private static final Schema SCHEMA_1;
    private static final Schema SCHEMA_2;

    private Util() {
    }

    public static Element findElement(Element element, String string, String string2) {
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3;
            if (nodeList.item(i).getNodeType() != 1 || !string.equals((element3 = (Element)nodeList.item(i)).getLocalName()) || !string2.equals(element3.getNamespaceURI())) continue;
            if (element2 == null) {
                element2 = element3;
                continue;
            }
            return null;
        }
        return element2;
    }

    public static String findText(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static List<Element> findSubElements(Element element) throws IllegalArgumentException {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                arrayList.add((Element)node);
                continue;
            }
            if (node.getNodeType() == 3) {
                String string = ((Text)node).getNodeValue();
                if (string.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + element + ": " + string);
            }
            if (node.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + element + ": " + node);
        }
        return arrayList;
    }

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(AntProjectHelper antProjectHelper) {
        try {
            Project project = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
            AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
            assert (auxiliaryConfiguration != null);
            return auxiliaryConfiguration;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public static String relativizeLocation(File file, File file2, File file3) {
        if (CollocationQuery.areCollocated((File)file, (File)file3)) {
            if (file.equals(file2)) {
                return PropertyUtils.relativizeFile((File)file, (File)file3);
            }
            if (file.equals(file3) && "${project.dir}/".endsWith("/")) {
                return "${project.dir}/".substring(0, "${project.dir}/".length() - 1);
            }
            return "${project.dir}/" + PropertyUtils.relativizeFile((File)file, (File)file3);
        }
        return file3.getAbsolutePath();
    }

    public static File resolveFile(PropertyEvaluator propertyEvaluator, File file, String string) {
        String string2 = propertyEvaluator.evaluate(string);
        if (string2 == null) {
            return null;
        }
        return PropertyUtils.resolveFile((File)file, (String)string2);
    }

    public static File getProjectLocation(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        String string = propertyEvaluator.getProperty("project.dir");
        if (string != null) {
            return antProjectHelper.resolveFile(string);
        }
        return FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
    }

    public static void appendChildElement(Element element, Element element2, String[] stringArray) {
        Element element3 = null;
        List<String> list = Arrays.asList(stringArray);
        int n = list.indexOf(element2.getLocalName());
        assert (n != -1) : element2.getLocalName() + " was not found in " + list;
        for (Element element4 : Util.findSubElements(element)) {
            int n2 = list.indexOf(element4.getLocalName());
            assert (n2 != -1) : element4.getLocalName() + " was not found in " + list;
            if (n2 <= n) continue;
            element3 = element4;
            break;
        }
        element.insertBefore(element2, element3);
    }

    public static FileObject getDefaultAntScript(Project project) throws IllegalArgumentException {
        ProjectAccessor projectAccessor = (ProjectAccessor)project.getLookup().lookup(ProjectAccessor.class);
        if (projectAccessor == null) {
            throw new IllegalArgumentException("Only FreeformProjects are supported.");
        }
        return FreeformProjectGenerator.getAntScript(projectAccessor.getHelper(), projectAccessor.getEvaluator());
    }

    private static Element translateXML(Element element, String string) {
        Node node;
        Element element2 = element.getOwnerDocument().createElementNS(string, element.getLocalName());
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            node = node2.getNodeType() == 1 ? Util.translateXML((Element)node2, string) : node2.cloneNode(true);
            element2.appendChild(node);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            node = namedNodeMap.item(i);
            element2.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        return element2;
    }

    public static Element getPrimaryConfigurationData(final AntProjectHelper antProjectHelper) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            public Element run() {
                AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
                Element element = auxiliaryConfiguration.getConfigurationFragment("general-data", Util.NAMESPACE, true);
                if (element != null) {
                    return element;
                }
                return Util.translateXML(antProjectHelper.getPrimaryConfigurationData(true), Util.NAMESPACE);
            }
        });
    }

    public static void putPrimaryConfigurationData(final AntProjectHelper antProjectHelper, final Element element) {
        if (!element.getNamespaceURI().equals(NAMESPACE)) {
            throw new IllegalArgumentException("Bad namespace");
        }
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Element element2 = Util.translateXML(element, "http://www.netbeans.org/ns/freeform-project/1");
                try {
                    Util.validate(element2, SCHEMA_1);
                    Util.putPrimaryConfigurationDataAs1(antProjectHelper, element2);
                }
                catch (SAXException sAXException) {
                    try {
                        Util.validate(element, SCHEMA_2);
                        Util.putPrimaryConfigurationDataAs2(antProjectHelper, element);
                    }
                    catch (SAXException sAXException2) {
                        assert (false) : sAXException2.getMessage() + "; rejected content: " + Util.access$600(element);
                        Util.putPrimaryConfigurationDataAs1(antProjectHelper, element2);
                    }
                }
                return null;
            }
        });
    }

    private static void putPrimaryConfigurationDataAs1(AntProjectHelper antProjectHelper, Element element) {
        antProjectHelper.createAuxiliaryConfiguration().removeConfigurationFragment("general-data", NAMESPACE, true);
        antProjectHelper.putPrimaryConfigurationData(element, true);
    }

    private static void putPrimaryConfigurationDataAs2(AntProjectHelper antProjectHelper, Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "general-data");
        element2.appendChild(document.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "name")).appendChild(document.createTextNode(Util.findText(Util.findElement(element, "name", NAMESPACE))));
        antProjectHelper.putPrimaryConfigurationData(element2, true);
        antProjectHelper.createAuxiliaryConfiguration().putConfigurationFragment(element, true);
    }

    private static void validate(Element element, Schema schema) throws SAXException {
        SAXException[] sAXExceptionArray;
        block3: {
            Validator validator = schema.newValidator();
            sAXExceptionArray = new SAXException[]{null};
            validator.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    sAXExceptionArray[0] = sAXParseException;
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    sAXExceptionArray[0] = sAXParseException;
                }
            });
            try {
                validator.validate(new DOMSource(Util.fixupNoNamespaceAttrs(element)));
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException);
            }
        }
        if (sAXExceptionArray[0] != null) {
            throw sAXExceptionArray[0];
        }
    }

    private static Element fixupNoNamespaceAttrs(Element element) {
        Element element2 = (Element)element.cloneNode(true);
        NodeList nodeList = element2.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3 = (Element)nodeList.item(i);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            NamedNodeMap namedNodeMap = element3.getAttributes();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Attr attr = (Attr)namedNodeMap.item(j);
                if (attr.getNamespaceURI() != null) continue;
                hashMap.put(attr.getName(), attr.getValue());
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                element3.removeAttribute((String)entry.getKey());
                element3.setAttributeNS(null, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return element2;
    }

    private static String format(Element element) {
        LSSerializer lSSerializer = ((DOMImplementationLS)element.getOwnerDocument().getImplementation().getFeature("LS", "3.0")).createLSSerializer();
        try {
            lSSerializer.getDomConfig().setParameter("format-pretty-print", true);
            lSSerializer.getDomConfig().setParameter("xml-declaration", false);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return lSSerializer.writeToString(element);
    }

    static /* synthetic */ String access$600(Element element) {
        return Util.format(element);
    }

    static {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            SCHEMA_1 = schemaFactory.newSchema(FreeformProject.class.getResource("resources/freeform-project-general.xsd"));
            SCHEMA_2 = schemaFactory.newSchema(FreeformProject.class.getResource("resources/freeform-project-general-2.xsd"));
        }
        catch (SAXException sAXException) {
            throw new ExceptionInInitializerError(sAXException);
        }
    }
}

