/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class ProjectXmlValidator
extends DefaultHandler
implements FileChangeListener {
    private final FileObject projectXml;
    private InputOutput io;

    public ProjectXmlValidator(FileObject fileObject) {
        this.projectXml = fileObject;
        fileObject.addFileChangeListener((FileChangeListener)this);
        this.validateProjectXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateProjectXml() {
        if (System.getProperty("netbeans.user") == null) {
            return;
        }
        this.open();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", ProjectXmlValidator.getSchemas());
            sAXParser.parse(this.projectXml.getURL().toString(), (DefaultHandler)this);
        }
        catch (SAXParseException sAXParseException) {
            this.log(sAXParseException);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        finally {
            this.close();
        }
    }

    private static String[] getSchemas() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("nbres:/org/netbeans/modules/project/ant/project.xsd");
        treeSet.add("nbres:/org/netbeans/modules/ant/freeform/resources/freeform-project-general.xsd");
        treeSet.add("nbres:/org/netbeans/modules/ant/freeform/resources/freeform-project-general-2.xsd");
        for (ProjectNature projectNature : FreeformProject.PROJECT_NATURES.allInstances()) {
            treeSet.addAll(projectNature.getSchemas());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public void fileChanged(FileEvent fileEvent) {
        this.validateProjectXml();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.log(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.log(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private void open() {
        if (this.io != null) {
            this.io.closeInputOutput();
            this.io = null;
        }
    }

    private void log(SAXParseException sAXParseException) {
        if (this.io == null) {
            String string = NbBundle.getMessage(ProjectXmlValidator.class, (String)"LBL_project.xml_errors", (Object)FileUtil.getFileDisplayName((FileObject)this.projectXml));
            this.io = IOProvider.getDefault().getIO(string, true);
            this.io.select();
        }
        try {
            this.io.getErr().println(sAXParseException.getLocalizedMessage(), (OutputListener)new Hyperlink(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    private void close() {
        if (this.io != null) {
            this.io.getErr().close();
            this.io.getOut().close();
        }
    }

    private static final class Hyperlink
    implements OutputListener {
        private final String uri;
        private final int line;
        private final int column;

        public Hyperlink(String string, int n, int n2) {
            this.uri = string;
            this.line = n;
            this.column = n2;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            block13: {
                DataObject dataObject;
                FileObject fileObject;
                try {
                    fileObject = URLMapper.findFileObject((URL)new URL(this.uri));
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                    return;
                }
                if (fileObject == null) {
                    return;
                }
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    assert (false) : dataObjectNotFoundException;
                    return;
                }
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                if (this.line != -1) {
                    try {
                        Line line = editorCookie.getLineSet().getOriginal(this.line - 1);
                        if (this.column != -1) {
                            line.show(2, this.column - 1);
                            break block13;
                        }
                        line.show(2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        editorCookie.open();
                    }
                } else {
                    editorCookie.open();
                }
            }
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

