/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeformFileEncodingQueryImpl
extends FileEncodingQueryImplementation
implements AntProjectListener,
PropertyChangeListener {
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private Map<FileObject, Charset> encodingsCache;

    public FreeformFileEncodingQueryImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset getEncoding(FileObject fileObject) {
        FreeformFileEncodingQueryImpl freeformFileEncodingQueryImpl = this;
        synchronized (freeformFileEncodingQueryImpl) {
            if (this.encodingsCache == null) {
                this.computeEncodingsCache();
            }
            if (this.encodingsCache.size() == 0) {
                return null;
            }
            Set<FileObject> set = this.encodingsCache.keySet();
            FileObject fileObject2 = this.getNearestParent(set, fileObject);
            if (fileObject2 != null) {
                return this.encodingsCache.get(fileObject2);
            }
        }
        return null;
    }

    private FileObject getNearestParent(Set<FileObject> set, FileObject fileObject) {
        while (fileObject != null) {
            if (set.contains(fileObject)) {
                return fileObject;
            }
            fileObject = fileObject.getParent();
        }
        return null;
    }

    private void computeEncodingsCache() {
        HashMap<FileObject, Charset> hashMap = new HashMap<FileObject, Charset>(3);
        Element element = Util.getPrimaryConfigurationData(this.helper);
        Element element2 = Util.findElement(element, "folders", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 != null) {
            for (Element element3 : Util.findSubElements(element2)) {
                Object object;
                if (!element3.getLocalName().equals("source-folder")) continue;
                FileObject fileObject = null;
                Element element4 = Util.findElement(element3, "location", "http://www.netbeans.org/ns/freeform-project/2");
                if (element4 != null && (object = this.evaluator.evaluate(Util.findText(element4))) != null) {
                    fileObject = this.helper.resolveFileObject((String)object);
                }
                if ((object = Util.findElement(element3, "encoding", "http://www.netbeans.org/ns/freeform-project/2")) == null || fileObject == null) continue;
                String string = this.evaluator.evaluate(Util.findText((Element)object));
                Charset charset = null;
                if (string == null) continue;
                try {
                    charset = Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Exceptions.printStackTrace((Throwable)illegalCharsetNameException);
                }
                hashMap.put(fileObject, charset);
            }
        }
        this.encodingsCache = hashMap.size() > 0 ? hashMap : Collections.emptyMap();
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.invalidateCache();
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
        this.invalidateCache();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.invalidateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void invalidateCache() {
        FreeformFileEncodingQueryImpl freeformFileEncodingQueryImpl = this;
        synchronized (freeformFileEncodingQueryImpl) {
            this.encodingsCache = null;
        }
    }
}

