/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.ant.freeform.ui.ProjectNodeWrapper;
import org.netbeans.modules.ant.freeform.ui.UnboundTargetAlert;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Actions
implements ActionProvider {
    private static final Logger LOG = Logger.getLogger(Actions.class.getName());
    private static final Set<String> COMMON_IDE_GLOBAL_ACTIONS = new HashSet<String>(Arrays.asList("debug", "delete", "copy", "move", "rename"));
    private static final Set<String> COMMON_NON_IDE_GLOBAL_ACTIONS = new HashSet<String>(Arrays.asList("build", "clean", "rebuild", "run", "test", "javadoc", "redeploy", "deploy"));
    private final FreeformProject project;
    static TargetRunner TARGET_RUNNER = new TargetRunner();

    public Actions(FreeformProject freeformProject) {
        this.project = freeformProject;
    }

    public String[] getSupportedActions() {
        Element element = this.project.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "ide-actions", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            return new String[0];
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Element element3 : Util.findSubElements(element2)) {
            linkedHashSet.add(element3.getAttribute("name"));
        }
        linkedHashSet.addAll(COMMON_NON_IDE_GLOBAL_ACTIONS);
        linkedHashSet.add("rename");
        linkedHashSet.add("move");
        linkedHashSet.add("copy");
        linkedHashSet.add("delete");
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            return true;
        }
        if ("copy".equals(string)) {
            return true;
        }
        if ("rename".equals(string)) {
            return true;
        }
        if ("move".equals(string)) {
            return true;
        }
        Element element = this.project.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "ide-actions", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            throw new IllegalArgumentException("No commands supported");
        }
        boolean bl = false;
        for (Element element3 : Util.findSubElements(element2)) {
            if (!element3.getAttribute("name").equals(string)) continue;
            bl = true;
            Element element4 = Util.findElement(element3, "context", "http://www.netbeans.org/ns/freeform-project/2");
            if (element4 != null) {
                Map<String, FileObject> map = Actions.findSelection(element4, lookup, this.project);
                LOG.log(Level.FINE, "detected selection {0} for command {1} in {2}", new Object[]{map, string, this.project});
                if (map.size() == 1) {
                    return true;
                }
                if (map.isEmpty()) continue;
                Element element5 = Util.findElement(element4, "arity", "http://www.netbeans.org/ns/freeform-project/2");
                assert (element5 != null) : "No <arity> in <context> for " + string;
                if (Util.findElement(element5, "separated-files", "http://www.netbeans.org/ns/freeform-project/2") == null) continue;
                return true;
            }
            return true;
        }
        if (COMMON_NON_IDE_GLOBAL_ACTIONS.contains(string)) {
            return true;
        }
        if (bl) {
            return false;
        }
        throw new IllegalArgumentException("Unrecognized command: " + string);
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        Element element = this.project.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "ide-actions", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            throw new IllegalArgumentException("No commands supported");
        }
        boolean bl = false;
        for (Element element3 : Util.findSubElements(element2)) {
            if (!element3.getAttribute("name").equals(string)) continue;
            bl = true;
            Actions.runConfiguredAction(this.project, element3, lookup);
        }
        if (!bl) {
            if (COMMON_NON_IDE_GLOBAL_ACTIONS.contains(string)) {
                if (this.addGlobalBinding(string)) {
                    this.invokeAction(string, lookup);
                }
            } else {
                throw new IllegalArgumentException("Unrecognized command: " + string);
            }
        }
    }

    private static Map<String, FileObject> findSelection(Element element, Lookup lookup, FreeformProject freeformProject) {
        Object object;
        Object object22;
        Collection collection = lookup.lookupAll(DataObject.class);
        if (collection.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(collection.size());
        for (Object object22 : collection) {
            arrayList.add(object22.getPrimaryFile());
        }
        ArrayList<FileObject> arrayList2 = arrayList;
        object22 = Util.findElement(element, "folder", "http://www.netbeans.org/ns/freeform-project/2");
        assert (object22 != null) : "Must have <folder> in <context>";
        String string = Util.findText((Element)object22);
        assert (string != null) : "Must have text contents in <folder>";
        String string2 = freeformProject.evaluator().evaluate(string);
        if (string2 == null) {
            return Collections.emptyMap();
        }
        FileObject fileObject = freeformProject.helper().resolveFileObject(string2);
        if (fileObject == null) {
            return Collections.emptyMap();
        }
        Pattern pattern = null;
        Element element2 = Util.findElement(element, "pattern", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 != null) {
            object = Util.findText(element2);
            assert (object != null) : "Must have text contents in <pattern>";
            try {
                pattern = Pattern.compile((String)object);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                org.netbeans.modules.ant.freeform.Util.err.annotate((Throwable)patternSyntaxException, 0, "From <pattern> in " + FileUtil.getFileDisplayName((FileObject)freeformProject.getProjectDirectory().getFileObject("nbproject/project.xml")), null, null, null);
                org.netbeans.modules.ant.freeform.Util.err.notify((Throwable)patternSyntaxException);
                return Collections.emptyMap();
            }
        }
        object = new HashMap();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject2 = (FileObject)iterator.next();
            String string3 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            if (string3 == null) {
                return Collections.emptyMap();
            }
            if (pattern != null && !pattern.matcher(string3).find()) {
                return Collections.emptyMap();
            }
            object.put(string3, fileObject2);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static void runConfiguredAction(FreeformProject freeformProject, Element element, Lookup lookup) {
        Object object;
        Object object2;
        Element element2 = Util.findElement(element, "script", "http://www.netbeans.org/ns/freeform-project/2");
        String string = element2 != null ? Util.findText(element2) : "build.xml";
        String string2 = freeformProject.evaluator().evaluate(string);
        FileObject fileObject = null;
        if (string2 != null) {
            fileObject = freeformProject.helper().resolveFileObject(string2);
        }
        if (fileObject == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getMessage(Actions.class, (String)"LBL_ScriptFileNotFoundError"), string2), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        List<Element> list = Util.findSubElements(element);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Element object32 : list) {
            if (!object32.getLocalName().equals("target")) continue;
            arrayList.add(Util.findText(object32));
        }
        Object object4 = !arrayList.isEmpty() ? arrayList.toArray(new String[arrayList.size()]) : null;
        Properties properties = new Properties();
        Element element3 = Util.findElement(element, "context", "http://www.netbeans.org/ns/freeform-project/2");
        if (element3 != null) {
            Object object3;
            Object object5;
            Map<String, FileObject> map = Actions.findSelection(element3, lookup, freeformProject);
            if (map.isEmpty()) {
                return;
            }
            Object var13_15 = null;
            if (map.size() > 1) {
                object2 = Util.findElement(element3, "arity", "http://www.netbeans.org/ns/freeform-project/2");
                assert (object2 != null) : "No <arity> in <context> for " + element.getAttribute("name");
                object = Util.findElement((Element)object2, "separated-files", "http://www.netbeans.org/ns/freeform-project/2");
                if (object == null) {
                    return;
                }
                String string3 = Util.findText((Element)object);
            }
            object2 = Util.findElement(element3, "format", "http://www.netbeans.org/ns/freeform-project/2");
            assert (object2 != null) : "No <format> in <context> for " + element.getAttribute("name");
            object = Util.findText((Element)object2);
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void var13_17;
                object5 = iterator.next();
                if (((String)object).equals("absolute-path")) {
                    object3 = FileUtil.toFile((FileObject)((FileObject)object5.getValue()));
                    if (object3 == null) {
                        return;
                    }
                    stringBuffer.append(((File)object3).getAbsolutePath());
                } else if (((String)object).equals("relative-path")) {
                    stringBuffer.append((String)object5.getKey());
                } else if (((String)object).equals("absolute-path-noext")) {
                    object3 = FileUtil.toFile((FileObject)((FileObject)object5.getValue()));
                    if (object3 == null) {
                        return;
                    }
                    String string4 = ((File)object3).getAbsolutePath();
                    int n = string4.lastIndexOf(46);
                    if (n > string4.lastIndexOf(47)) {
                        string4 = string4.substring(0, n);
                    }
                    stringBuffer.append(string4);
                } else if (((String)object).equals("relative-path-noext")) {
                    object3 = (String)object5.getKey();
                    int n = ((String)object3).lastIndexOf(46);
                    if (n > ((String)object3).lastIndexOf(47)) {
                        object3 = ((String)object3).substring(0, n);
                    }
                    stringBuffer.append((String)object3);
                } else {
                    assert (((String)object).equals("java-name")) : object;
                    object3 = (String)object5.getKey();
                    int n = ((String)object3).lastIndexOf(46);
                    Object object6 = n == -1 || n < ((String)object3).lastIndexOf(47) ? object3 : ((String)object3).substring(0, n);
                    String string5 = ((String)object6).replace('/', '.');
                    stringBuffer.append(string5);
                }
                if (!iterator.hasNext()) continue;
                assert (var13_17 != null);
                stringBuffer.append((String)var13_17);
            }
            object5 = Util.findElement(element3, "property", "http://www.netbeans.org/ns/freeform-project/2");
            assert (object5 != null) : "No <property> in <context> for " + element.getAttribute("name");
            object3 = Util.findText((Element)object5);
            assert (object3 != null) : "Must have text contents in <property>";
            properties.setProperty((String)object3, stringBuffer.toString());
        }
        for (Element element4 : list) {
            if (!element4.getLocalName().equals("property")) continue;
            object2 = Util.findText(element4);
            if (object2 == null) {
                object2 = "";
            }
            if ((object = freeformProject.evaluator().evaluate((String)object2)) == null) continue;
            properties.setProperty(element4.getAttribute("name"), (String)object);
        }
        TARGET_RUNNER.runTarget(fileObject, (String[])object4, properties);
    }

    public static Action[] createContextMenu(FreeformProject freeformProject) {
        Element element;
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(CommonProjectActions.newFileAction());
        Element element2 = freeformProject.getPrimaryConfigurationData();
        Element element3 = Util.findElement(element2, "view", "http://www.netbeans.org/ns/freeform-project/2");
        if (element3 != null && (element = Util.findElement(element3, "context-menu", "http://www.netbeans.org/ns/freeform-project/2")) != null) {
            arrayList.add(null);
            for (Element element4 : Util.findSubElements(element)) {
                if (element4.getLocalName().equals("ide-action")) {
                    String string = element4.getAttribute("name");
                    String string2 = COMMON_IDE_GLOBAL_ACTIONS.contains(string) || COMMON_NON_IDE_GLOBAL_ACTIONS.contains(string) ? NbBundle.getMessage(Actions.class, (String)("CMD_" + string)) : string;
                    arrayList.add(ProjectSensitiveActions.projectCommandAction((String)string, (String)string2, null));
                    continue;
                }
                if (element4.getLocalName().equals("separator")) {
                    arrayList.add(null);
                    continue;
                }
                assert (element4.getLocalName().equals("action")) : element4;
                arrayList.add(new CustomAction(freeformProject, element4));
            }
        }
        Actions.addFromLayers(arrayList, "Projects/Profiler_Actions_temporary");
        arrayList.add(null);
        arrayList.add(CommonProjectActions.setAsMainProjectAction());
        arrayList.add(CommonProjectActions.openSubprojectsAction());
        arrayList.add(CommonProjectActions.closeProjectAction());
        arrayList.add(null);
        arrayList.add(CommonProjectActions.renameProjectAction());
        arrayList.add(CommonProjectActions.moveProjectAction());
        arrayList.add(CommonProjectActions.copyProjectAction());
        arrayList.add(CommonProjectActions.deleteProjectAction());
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(FindAction.class));
        arrayList.add(ProjectNodeWrapper.GENERIC_PROJECTS_ACTIONS_MARKER);
        arrayList.add(null);
        arrayList.add(CommonProjectActions.customizeProjectAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static void addFromLayers(List<Action> list, String string) {
        Lookup lookup = Lookups.forPath((String)string);
        for (Object e : lookup.lookupAll(Object.class)) {
            if (e instanceof Action) {
                list.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            list.add(null);
        }
    }

    private boolean addGlobalBinding(String string) {
        try {
            return new UnboundTargetAlert(this.project, string).accepted();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    static class TargetRunner {
        public void runTarget(FileObject fileObject, String[] stringArray, Properties properties) {
            try {
                ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private static final class CustomAction
    extends AbstractAction {
        private final FreeformProject p;
        private final Element actionEl;

        public CustomAction(FreeformProject freeformProject, Element element) {
            this.p = freeformProject;
            this.actionEl = element;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.runConfiguredAction(this.p, this.actionEl, Lookup.EMPTY);
        }

        public boolean isEnabled() {
            Element element = Util.findElement(this.actionEl, "script", "http://www.netbeans.org/ns/freeform-project/2");
            String string = element != null ? Util.findText(element) : "build.xml";
            String string2 = this.p.evaluator().evaluate(string);
            return this.p.helper().resolveFileObject(string2) != null;
        }

        public Object getValue(String string) {
            if (string.equals("Name")) {
                Element element = Util.findElement(this.actionEl, "label", "http://www.netbeans.org/ns/freeform-project/2");
                return Util.findText(element);
            }
            return super.getValue(string);
        }
    }
}

