/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.storage;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeTemplateSettingsImpl {
    private static final Logger LOG = Logger.getLogger(CodeTemplateSettingsImpl.class.getName());
    public static final String PROP_CODE_TEMPLATES = "CodeTemplateSettingsImpl.PROP_CODE_TEMPLATES";
    public static final String PROP_EXPANSION_KEY = "CodeTemplateSettingsImpl.PROP_EXPANSION_KEY";
    private static final KeyStroke DEFAULT_EXPANSION_KEY = KeyStroke.getKeyStroke(9, 0);
    private static final Map<MimePath, WeakReference<CodeTemplateSettingsImpl>> INSTANCES = new WeakHashMap<MimePath, WeakReference<CodeTemplateSettingsImpl>>();
    private final MimePath mimePath;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static synchronized CodeTemplateSettingsImpl get(MimePath mimePath) {
        CodeTemplateSettingsImpl codeTemplateSettingsImpl;
        WeakReference<CodeTemplateSettingsImpl> weakReference = INSTANCES.get(mimePath);
        CodeTemplateSettingsImpl codeTemplateSettingsImpl2 = codeTemplateSettingsImpl = weakReference == null ? null : (CodeTemplateSettingsImpl)weakReference.get();
        if (codeTemplateSettingsImpl == null) {
            codeTemplateSettingsImpl = new CodeTemplateSettingsImpl(mimePath);
            INSTANCES.put(mimePath, new WeakReference<CodeTemplateSettingsImpl>(codeTemplateSettingsImpl));
        }
        return codeTemplateSettingsImpl;
    }

    public Map<String, CodeTemplateDescription> getCodeTemplates() {
        EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"CodeTemplates");
        try {
            return editorSettingsStorage.load(this.mimePath, null, false);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return Collections.emptyMap();
        }
    }

    public void setCodeTemplates(Map<String, CodeTemplateDescription> map) {
        EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"CodeTemplates");
        try {
            if (map == null) {
                editorSettingsStorage.delete(this.mimePath, null, false);
            } else {
                editorSettingsStorage.save(this.mimePath, null, false, map);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
        this.pcs.firePropertyChange(PROP_CODE_TEMPLATES, null, null);
    }

    public KeyStroke getExpandKey() {
        return CodeTemplateSettingsImpl.BaseOptions_getCodeTemplateExpandKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpandKey(KeyStroke keyStroke) {
        CodeTemplateSettingsImpl.BaseOptions_setCodeTemplateExpandKey(keyStroke);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<CodeTemplateSettingsImpl> arrayList = new ArrayList<CodeTemplateSettingsImpl>();
        Class<CodeTemplateSettingsImpl> clazz = CodeTemplateSettingsImpl.class;
        synchronized (CodeTemplateSettingsImpl.class) {
            for (WeakReference<CodeTemplateSettingsImpl> weakReference : INSTANCES.values()) {
                CodeTemplateSettingsImpl codeTemplateSettingsImpl = (CodeTemplateSettingsImpl)weakReference.get();
                if (codeTemplateSettingsImpl == null) continue;
                arrayList.add(codeTemplateSettingsImpl);
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            for (CodeTemplateSettingsImpl codeTemplateSettingsImpl : arrayList) {
                codeTemplateSettingsImpl.pcs.firePropertyChange(PROP_EXPANSION_KEY, null, null);
            }
            return;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private CodeTemplateSettingsImpl(MimePath mimePath) {
        this.mimePath = mimePath;
    }

    private static KeyStroke BaseOptions_getCodeTemplateExpandKey() {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.editor.options.BaseOptions");
            Method method = clazz.getDeclaredMethod("getCodeTemplateExpandKey", new Class[0]);
            return (KeyStroke)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, null, exception);
            return DEFAULT_EXPANSION_KEY;
        }
    }

    private static void BaseOptions_setCodeTemplateExpandKey(KeyStroke keyStroke) {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.editor.options.BaseOptions");
            Method method = clazz.getDeclaredMethod("setCodeTemplateExpandKey", KeyStroke.class);
            method.invoke(null, keyStroke);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

