/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.codetemplates.CodeTemplateApiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.CodeTemplateComparator;
import org.netbeans.lib.editor.codetemplates.CodeTemplateInsertHandler;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeTemplateManagerOperation
implements LookupListener,
Runnable {
    private static final Logger LOG = Logger.getLogger(CodeTemplateManagerOperation.class.getName());
    private static final Map<MimePath, CodeTemplateManagerOperation> mime2operation = new WeakHashMap<MimePath, CodeTemplateManagerOperation>(8);
    private static final KeyStroke DEFAULT_EXPANSION_KEY = KeyStroke.getKeyStroke(9, 0);
    private final CodeTemplateManager manager;
    private final String mimePath;
    private final Lookup.Result<CodeTemplateSettings> ctslr;
    private final EventListenerList listenerList = new EventListenerList();
    private boolean loaded = false;
    private Map<String, CodeTemplate> abbrev2template = Collections.emptyMap();
    private List<CodeTemplate> sortedTemplatesByAbbrev = Collections.emptyList();
    private List<CodeTemplate> sortedTemplatesByParametrizedText = Collections.emptyList();
    private List<CodeTemplate> selectionTemplates = Collections.emptyList();
    private KeyStroke expansionKey = DEFAULT_EXPANSION_KEY;
    private String expansionKeyText = CodeTemplateManagerOperation.getExpandKeyStrokeText(this.expansionKey);
    private static final int MATCH_NO = 0;
    private static final int MATCH_IGNORE_CASE = 1;
    private static final int MATCH = 2;

    public static synchronized CodeTemplateManager getManager(Document document) {
        String string = (String)document.getProperty("mimeType");
        return CodeTemplateManagerOperation.get(MimePath.parse((String)string)).getManager();
    }

    public static synchronized CodeTemplateManagerOperation get(Document document, int n) {
        MimePath mimePath = CodeTemplateManagerOperation.getFullMimePath(document, n);
        if (mimePath != null) {
            return CodeTemplateManagerOperation.get(mimePath);
        }
        return null;
    }

    public static synchronized CodeTemplateManagerOperation get(MimePath mimePath) {
        CodeTemplateManagerOperation codeTemplateManagerOperation = mime2operation.get(mimePath);
        if (codeTemplateManagerOperation == null) {
            codeTemplateManagerOperation = new CodeTemplateManagerOperation(mimePath);
            mime2operation.put(mimePath, codeTemplateManagerOperation);
        }
        return codeTemplateManagerOperation;
    }

    private CodeTemplateManagerOperation(MimePath mimePath) {
        this.mimePath = mimePath.getPath();
        this.manager = CodeTemplateApiPackageAccessor.get().createCodeTemplateManager(this);
        assert (this.manager != null) : "Can't creat CodeTemplateManager";
        this.ctslr = MimeLookup.getLookup((MimePath)mimePath).lookupResult(CodeTemplateSettings.class);
        this.ctslr.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.ctslr));
        RequestProcessor.getDefault().post((Runnable)this);
    }

    public String getMimePath() {
        return this.mimePath;
    }

    public CodeTemplateManager getManager() {
        return this.manager;
    }

    public Collection<? extends CodeTemplate> getCodeTemplates() {
        return this.sortedTemplatesByAbbrev;
    }

    public Collection<? extends CodeTemplate> findSelectionTemplates() {
        return this.selectionTemplates;
    }

    public CodeTemplate findByAbbreviation(String string) {
        return this.abbrev2template.get(string);
    }

    public Collection<? extends CodeTemplate> findByParametrizedText(String string, boolean bl) {
        int n;
        CodeTemplate codeTemplate;
        int n2;
        ArrayList<CodeTemplate> arrayList = new ArrayList<CodeTemplate>();
        int n3 = 0;
        int n4 = this.sortedTemplatesByParametrizedText.size() - 1;
        while (n3 <= n4) {
            n2 = n3 + n4 >> 1;
            codeTemplate = this.sortedTemplatesByParametrizedText.get(n2);
            n = CodeTemplateManagerOperation.compareTextIgnoreCase(codeTemplate.getParametrizedText(), string);
            if (n < 0) {
                n3 = n2 + 1;
                continue;
            }
            if (n > 0) {
                n4 = n2 - 1;
                continue;
            }
            n3 = n2;
            break;
        }
        for (n2 = n3 - 1; n2 >= 0 && (n = CodeTemplateManagerOperation.matchPrefix((codeTemplate = this.sortedTemplatesByParametrizedText.get(n2)).getParametrizedText(), string)) != 0; --n2) {
            if (n == 1) {
                if (!bl) continue;
                arrayList.add(codeTemplate);
                continue;
            }
            arrayList.add(codeTemplate);
        }
        for (n2 = n3; n2 < this.sortedTemplatesByParametrizedText.size() && (n = CodeTemplateManagerOperation.matchPrefix((codeTemplate = this.sortedTemplatesByParametrizedText.get(n2)).getParametrizedText(), string)) != 0; ++n2) {
            if (n == 1) {
                if (!bl) continue;
                arrayList.add(codeTemplate);
                continue;
            }
            arrayList.add(codeTemplate);
        }
        return arrayList;
    }

    public static Collection<? extends CodeTemplateFilter> getTemplateFilters(JTextComponent jTextComponent, int n) {
        MimePath mimePath = CodeTemplateManagerOperation.getFullMimePath(jTextComponent.getDocument(), n);
        Collection collection = MimeLookup.getLookup((MimePath)mimePath).lookupAll(CodeTemplateFilter.Factory.class);
        ArrayList<CodeTemplateFilter> arrayList = new ArrayList<CodeTemplateFilter>(collection.size());
        for (CodeTemplateFilter.Factory factory : collection) {
            arrayList.add(factory.createFilter(jTextComponent, n));
        }
        return arrayList;
    }

    public static void insert(CodeTemplate codeTemplate, JTextComponent jTextComponent) {
        String string = CodeTemplateApiPackageAccessor.get().getCodeTemplateMimePath(codeTemplate);
        Collection collection = MimeLookup.getLookup((String)string).lookupAll(CodeTemplateProcessorFactory.class);
        CodeTemplateInsertHandler codeTemplateInsertHandler = new CodeTemplateInsertHandler(codeTemplate, jTextComponent, collection);
        codeTemplateInsertHandler.processTemplate();
    }

    private static int matchPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        boolean bl = true;
        int n2 = charSequence2.length();
        if (n2 > charSequence.length()) {
            return 0;
        }
        for (n = 0; n < n2; ++n) {
            char c;
            char c2 = charSequence.charAt(n);
            if (c2 == (c = charSequence2.charAt(n))) continue;
            bl = false;
            if (Character.toLowerCase(c2) != Character.toLowerCase(c)) break;
        }
        if (n == n2) {
            return bl ? 2 : 1;
        }
        return 0;
    }

    private static int compareTextIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n = Math.min(charSequence.length(), charSequence2.length());
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = Character.toLowerCase(charSequence.charAt(i));
            if (c2 == (c = Character.toLowerCase(charSequence2.charAt(i)))) continue;
            return c2 - c;
        }
        return charSequence.length() - charSequence2.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoaded() {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            return this.loaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLoadedListener(ChangeListener changeListener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            if (!this.isLoaded()) {
                this.listenerList.add(ChangeListener.class, changeListener);
                return;
            }
        }
        changeListener.stateChanged(new ChangeEvent(this.manager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLoaded() {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            while (!this.isLoaded()) {
                try {
                    this.listenerList.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Interrupted when waiting to load code templates");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged(ChangeEvent changeEvent) {
        Object[] objectArray;
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            objectArray = this.listenerList.getListenerList();
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            if (ChangeListener.class != objectArray[i]) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    @Override
    public void run() {
        this.rebuildCodeTemplates();
    }

    private static void processCodeTemplateDescriptions(CodeTemplateManagerOperation codeTemplateManagerOperation, Collection<? extends CodeTemplateDescription> collection, Map<String, CodeTemplate> map, List<CodeTemplate> list) {
        for (CodeTemplateDescription codeTemplateDescription : collection) {
            CodeTemplate codeTemplate = CodeTemplateApiPackageAccessor.get().createCodeTemplate(codeTemplateManagerOperation, codeTemplateDescription.getAbbreviation(), codeTemplateDescription.getDescription(), codeTemplateDescription.getParametrizedText(), codeTemplateDescription.getContexts(), codeTemplateDescription.getMimePath());
            map.put(codeTemplate.getAbbreviation(), codeTemplate);
            if (codeTemplate.getParametrizedText().toLowerCase().indexOf("${selection") <= -1) continue;
            list.add(codeTemplate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildCodeTemplates() {
        ArrayList arrayList;
        Collection collection = this.ctslr.allInstances();
        CodeTemplateSettings codeTemplateSettings = collection.isEmpty() ? null : (CodeTemplateSettings)collection.iterator().next();
        HashMap<String, CodeTemplate> hashMap = new HashMap<String, CodeTemplate>();
        ArrayList<CodeTemplate> arrayList2 = new ArrayList<CodeTemplate>();
        KeyStroke keyStroke = DEFAULT_EXPANSION_KEY;
        if (codeTemplateSettings != null) {
            arrayList = codeTemplateSettings.getCodeTemplateDescriptions();
            CodeTemplateManagerOperation.processCodeTemplateDescriptions(this, arrayList, hashMap, arrayList2);
            keyStroke = CodeTemplateManagerOperation.patchExpansionKey(codeTemplateSettings.getExpandKey());
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Can't find CodeTemplateSettings for '" + this.mimePath + "'");
        }
        arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList, CodeTemplateComparator.BY_ABBREVIATION_IGNORE_CASE);
        ArrayList arrayList3 = new ArrayList(hashMap.values());
        Collections.sort(arrayList3, CodeTemplateComparator.BY_PARAMETRIZED_TEXT_IGNORE_CASE);
        boolean bl = false;
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            bl = this.abbrev2template == null;
            this.abbrev2template = Collections.unmodifiableMap(hashMap);
            this.sortedTemplatesByAbbrev = Collections.unmodifiableList(arrayList);
            this.sortedTemplatesByParametrizedText = Collections.unmodifiableList(arrayList3);
            this.selectionTemplates = Collections.unmodifiableList(arrayList2);
            this.expansionKey = keyStroke;
            this.expansionKeyText = CodeTemplateManagerOperation.getExpandKeyStrokeText(keyStroke);
            this.loaded = true;
            this.listenerList.notifyAll();
        }
        if (bl) {
            this.fireStateChanged(new ChangeEvent(this.manager));
        }
    }

    public KeyStroke getExpansionKey() {
        return this.expansionKey;
    }

    public String getExpandKeyStrokeText() {
        return this.expansionKeyText;
    }

    private static String getExpandKeyStrokeText(KeyStroke keyStroke) {
        String string = keyStroke.equals(KeyStroke.getKeyStroke(' ')) ? "SPACE" : (keyStroke.equals(KeyStroke.getKeyStroke(new Character(' '), 1)) ? "Shift-SPACE" : (keyStroke.equals(KeyStroke.getKeyStroke(9, 0)) ? "TAB" : (keyStroke.equals(KeyStroke.getKeyStroke(10, 0)) ? "ENTER" : keyStroke.toString())));
        return string;
    }

    private static KeyStroke patchExpansionKey(KeyStroke keyStroke) {
        if (keyStroke.equals(KeyStroke.getKeyStroke(32, 0))) {
            keyStroke = KeyStroke.getKeyStroke(' ');
        } else if (keyStroke.equals(KeyStroke.getKeyStroke(32, 1))) {
            keyStroke = KeyStroke.getKeyStroke(new Character(' '), 1);
        } else if (keyStroke.equals(KeyStroke.getKeyStroke(9, 0)) || keyStroke.equals(KeyStroke.getKeyStroke(10, 0))) {
            // empty if block
        }
        return keyStroke;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.rebuildCodeTemplates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MimePath getFullMimePath(Document document, int n) {
        String string = null;
        if (document instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            abstractDocument.readLock();
            try {
                List list = TokenHierarchy.get((Document)document).embeddedTokenSequences(n, true);
                if (list.size() > 1) {
                    string = ((TokenSequence)list.get(list.size() - 1)).languagePath().mimePath();
                }
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
        if (string == null) {
            string = NbEditorUtilities.getMimeType((Document)document);
        }
        if (string != null) {
            return MimePath.parse((String)string);
        }
        return null;
    }
}

