/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.element.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.gotodeclaration.element.spi.ElementDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.element.spi.ElementProvider;
import org.netbeans.modules.cnd.gotodeclaration.util.NameMatcher;
import org.netbeans.modules.cnd.gotodeclaration.util.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProvider
implements ElementProvider {
    private ProviderDelegate delegate;

    protected abstract ProviderDelegate createDelegate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ProviderDelegate providerDelegate = null;
        BaseProvider baseProvider = this;
        synchronized (baseProvider) {
            if (this.delegate != null) {
                providerDelegate = this.delegate;
                this.delegate = null;
            }
        }
        if (providerDelegate != null) {
            providerDelegate.cancel();
        }
    }

    @Override
    public boolean isSuitable() {
        return !CsmModelAccessor.getModel().projects().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends ElementDescriptor> getElements(Project project, String string, SearchType searchType, boolean bl) {
        if (bl) {
            this.cancel();
            this.delegate = this.createDelegate();
        }
        BaseProvider baseProvider = this;
        synchronized (baseProvider) {
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
        }
        return this.delegate.getElements(project, string, searchType, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        ProviderDelegate providerDelegate = null;
        BaseProvider baseProvider = this;
        synchronized (baseProvider) {
            if (this.delegate != null) {
                providerDelegate = this.delegate;
                this.delegate = null;
            }
        }
        if (providerDelegate != null) {
            providerDelegate.cancel();
            providerDelegate.cleanup();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ProviderDelegate {
        private boolean isCancelled = false;
        protected static final boolean PROCESS_LIBRARIES = true;
        protected static final boolean TRACE = Boolean.getBoolean("cnd.goto.fv.trace");
        private Set<CsmProject> processedProjects = new HashSet<CsmProject>();
        private CsmProject currentProject;

        protected ProviderDelegate() {
        }

        public void cancel() {
            this.isCancelled = true;
        }

        protected final boolean isCancelled() {
            return this.isCancelled;
        }

        protected abstract void processProject(CsmProject var1, ResultSet var2, NameMatcher var3);

        public Collection<? extends ElementDescriptor> getElements(Project project, String string, SearchType searchType, boolean bl) {
            if (TRACE) {
                System.err.printf("%s.getElements(%s, %s, %s)\n", this.getBriefClassName(), project, string, searchType);
            }
            CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)project);
            return this.getElements(csmProject, string, searchType, bl);
        }

        Collection<? extends ElementDescriptor> getElements(CsmProject csmProject, String string, SearchType searchType, boolean bl) {
            NameMatcher nameMatcher = NameMatcherFactory.createNameMatcher(string, searchType);
            if (nameMatcher == null) {
                return Collections.emptyList();
            }
            if (bl) {
                this.processedProjects.clear();
            }
            ResultSetImpl resultSetImpl = new ResultSetImpl();
            if (csmProject != null && !this.processedProjects.contains(csmProject)) {
                this.processedProjects.add(csmProject);
                this.currentProject = csmProject;
                this.processProject(csmProject, resultSetImpl, nameMatcher);
                this.currentProject = null;
                for (CsmProject csmProject2 : csmProject.getLibraries()) {
                    if (this.isCancelled()) break;
                    if (!csmProject2.isArtificial() || this.processedProjects.contains(csmProject2)) continue;
                    this.processedProjects.add(csmProject2);
                    this.currentProject = csmProject2;
                    this.processProject(csmProject2, resultSetImpl, nameMatcher);
                    this.currentProject = null;
                }
            }
            return resultSetImpl.getResult();
        }

        public void cleanup() {
            this.processedProjects.clear();
            this.currentProject = null;
        }

        private String getBriefClassName() {
            String string = this.getClass().getName();
            int n = string.lastIndexOf(46);
            return n >= 0 ? string.substring(n + 1) : string;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ResultSetImpl
        implements ResultSet {
            private Map<ElementDescriptor, Boolean> data = new HashMap<ElementDescriptor, Boolean>();

            protected ResultSetImpl() {
            }

            @Override
            public void add(ElementDescriptor elementDescriptor) {
                if (!this.data.containsKey(elementDescriptor) || !this.isArtificial(ProviderDelegate.this.currentProject)) {
                    this.data.put(elementDescriptor, Boolean.TRUE);
                }
            }

            @Override
            public Collection<? extends ElementDescriptor> getResult() {
                return new ArrayList<ElementDescriptor>(this.data.keySet());
            }

            private boolean isArtificial(CsmProject csmProject) {
                return csmProject != null && csmProject.isArtificial();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ResultSet {
        public void add(ElementDescriptor var1);

        public Collection<? extends ElementDescriptor> getResult();
    }
}

