/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.theme.ThemeContext;
import com.sun.webui.theme.ThemeReference;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThemeResources {
    private ThemeReference[] themeReferences;
    private Locale locale;
    private String version;
    private String name;
    private ThemeContext themeContext;

    ThemeResources(ThemeReference[] themeReferences, String themeName, String version, Locale locale, ThemeContext themeContext) {
        this.themeReferences = themeReferences;
        this.themeContext = themeContext;
        this.locale = locale;
        this.version = version;
        this.name = themeName;
    }

    ThemeReference[] getThemeReferences() {
        return this.themeReferences;
    }

    ThemeContext getThemeContext() {
        return this.themeContext;
    }

    Locale getLocale() {
        return this.locale;
    }

    String getName() {
        return this.name;
    }

    String getVersion() {
        return this.version;
    }

    Iterator<ThemeReference> getThemeReferenceIterator(boolean reverse) {
        if (this.themeReferences == null) {
            return this.getEmptyIterator();
        }
        if (!reverse) {
            return this.getThemeReferenceIterator();
        }
        final int tempindex = this.themeReferences.length - 1;
        return new Iterator<ThemeReference>(){
            int index;
            {
                this.index = tempindex;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public ThemeReference next() {
                try {
                    return ThemeResources.this.themeReferences[this.index--];
                }
                catch (Exception e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    Iterator<ThemeReference> getThemeReferenceIterator() {
        if (this.themeReferences == null) {
            return this.getEmptyIterator();
        }
        return new Iterator<ThemeReference>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ThemeResources.this.themeReferences.length;
            }

            @Override
            public ThemeReference next() {
                try {
                    return ThemeResources.this.themeReferences[this.index++];
                }
                catch (Exception e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Iterator<ThemeReference> getEmptyIterator() {
        return new Iterator<ThemeReference>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public ThemeReference next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

