/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class FieldRendererBase
extends RendererBase {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!(component instanceof Field)) {
            throw new IllegalArgumentException("TextFieldRenderer can only decode Field components.");
        }
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("TextFieldRenderer can only decode EditableValueHolder components.");
        }
        Field field = (Field)component;
        if (field.isDisabled() || field.isReadOnly()) {
            return;
        }
        String id = field.getClientId(context);
        if (field instanceof ComplexComponent) {
            id = field.getLabeledElementId(context);
        }
        if (id == null) {
            return;
        }
        String value = null;
        Map params = context.getExternalContext().getRequestParameterMap();
        Object valueObject = params.get(id);
        if (valueObject != null) {
            value = (String)valueObject;
            if (field.isTrim()) {
                value = value.toString().trim();
            }
        }
        field.setSubmittedValue(value);
    }

    protected JSONObject getLabel(FacesContext context, Field field) throws IOException, JSONException {
        if (field == null) {
            throw new RuntimeException("field must not be null");
        }
        JSONObject json = new JSONObject();
        json.put("value", (Object)field.getLabel()).put("level", field.getLabelLevel());
        return json;
    }
}

