/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Anchor;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class AnchorRenderer
extends Renderer {
    private static final String[] stringAttributes = new String[]{"onclick", "onDblClick", "onKeyDown", "onKeyPress", "onMouseUp", "onKeyUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver", "onFocus", "onBlur", "shape", "coords", "rel", "rev", "target", "type", "style"};
    private static String ANCHOR_IMAGE = "_img";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException("FacesContext or UIComponent is null");
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", component);
        this.renderAttributes(component, context, writer);
        this.renderContents(component, context, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UIParameter) continue;
            RenderingUtilities.renderComponent(child, context);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ClientSniffer sniffer;
        if (context == null || component == null) {
            throw new NullPointerException("FacesContext or UIComponent is null");
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String text = (String)component.getAttributes().get("text");
        if ((component.getChildCount() == 0 || text == null && text.length() == 0) && ((sniffer = ClientSniffer.getInstance(context)).isIe6up() || sniffer.isIe7() || sniffer.isIe7up())) {
            Icon icon = new Icon();
            icon.setIcon("DOT");
            icon.setId(component.getId() + ANCHOR_IMAGE);
            RenderingUtilities.renderComponent((UIComponent)icon, context);
        }
        writer.endElement("a");
    }

    protected void renderAttributes(UIComponent component, FacesContext context, ResponseWriter writer) throws IOException {
        int tabIndex;
        Integer _tabIndex;
        Map attributes = component.getAttributes();
        if (component instanceof Anchor) {
            writer.writeAttribute("id", (Object)component.getId(), null);
        } else {
            writer.writeAttribute("id", (Object)component.getClientId(context), null);
        }
        String name = (String)component.getAttributes().get("name");
        if (name == null || name.length() == 0) {
            writer.writeAttribute("name", (Object)component.getId(), null);
        } else {
            writer.writeAttribute("name", (Object)name, null);
        }
        this.renderStringAttributes(component, context, writer);
        String url = (String)attributes.get("url");
        if (url != null) {
            this.renderURL(component, context, writer, url);
        }
        if ((_tabIndex = (Integer)attributes.get("tabindex")) != null && (tabIndex = _tabIndex.intValue()) != Integer.MIN_VALUE) {
            writer.writeAttribute("tabindex", (Object)tabIndex, null);
        }
    }

    protected void renderContents(UIComponent component, FacesContext context, ResponseWriter writer) throws IOException {
        String text = (String)component.getAttributes().get("text");
        if (text != null && text.length() > 0) {
            text = ConversionUtilities.convertValueToString(component, text);
            writer.write(text);
        }
    }

    private void renderStringAttributes(UIComponent component, FacesContext context, ResponseWriter writer) throws IOException {
        String urlLang;
        String tooltip;
        String styleClass;
        Map attributes = component.getAttributes();
        RenderingUtilities.writeStringAttributes(component, writer, stringAttributes);
        String style = (String)attributes.get("style");
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((styleClass = this.getStyleClass(component, context, attributes)) != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if ((tooltip = (String)attributes.get("toolTip")) != null && tooltip.length() > 0) {
            writer.writeAttribute("title", (Object)tooltip, null);
        }
        if ((urlLang = (String)attributes.get("urlLang")) != null && urlLang.length() > 0) {
            writer.writeAttribute("hreflang", (Object)urlLang, null);
        }
    }

    protected String getStyleClass(UIComponent component, FacesContext context, Map attributes) {
        Theme theme = ThemeUtilities.getTheme(context);
        String styleclass = (String)attributes.get("styleClass");
        StringBuilder style = new StringBuilder();
        if (styleclass != null) {
            style.append(styleclass).append(" ");
        }
        boolean visible = (Boolean)attributes.get("visible");
        boolean disabled = (Boolean)attributes.get("disabled");
        if (component.getAttributes().get("url") != null && !disabled) {
            style.append(theme.getStyleClass("ANCHOR")).append(" ");
        } else {
            style.append(theme.getStyleClass("ANCHOR_DISABLED")).append(" ");
        }
        if (!visible) {
            style.append(theme.getStyleClass("HIDDEN"));
        }
        return style.toString();
    }

    protected void renderURL(UIComponent component, FacesContext context, ResponseWriter writer, String url) throws IOException {
        if (!url.startsWith("#")) {
            url = context.getApplication().getViewHandler().getResourceURL(context, url);
            RenderingUtilities.renderURLAttribute(context, writer, component, "href", url, "url");
        } else {
            writer.writeAttribute("href", (Object)url, null);
        }
    }
}

