/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model.login;

import com.sun.webui.jsf.model.login.LoginCallback;
import com.sun.webui.jsf.model.login.LoginConstants;
import com.sun.webui.jsf.util.LogUtil;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JaasController
extends Thread {
    private CallbackHandler ccbh;
    private HttpServletRequest request;
    private HttpSession session;
    private String serviceName;
    private Subject subject;

    public JaasController(HttpServletRequest req, CallbackHandler handler, String loginService, Subject subject) {
        this.request = req;
        this.session = this.request.getSession(false);
        this.ccbh = handler;
        this.serviceName = loginService;
        this.subject = subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LoginContext lc = null;
        try {
            lc = new LoginContext(this.serviceName, this.subject, this.ccbh);
            lc.login();
            JaasController jaasController = this;
            synchronized (jaasController) {
                this.session.setAttribute("subject", (Object)lc.getSubject());
                LoginCallback lcb = new LoginCallback();
                lcb.setLoginState(LoginConstants.LOGINSTATE.SUCCESS);
                this.session.setAttribute("serverconv", (Object)lcb);
                this.notifyAll();
            }
            this.session.removeAttribute("loginThread");
            this.session.removeAttribute("moduleClass");
        }
        catch (Exception e) {
            try {
                JaasController lcb = this;
                synchronized (lcb) {
                    LoginCallback lcb2 = new LoginCallback();
                    lcb2.setMessage("ERROR", "login.errorSummary", e.getMessage());
                    lcb2.setLoginState(LoginConstants.LOGINSTATE.FAILURE);
                    this.session.setAttribute("serverconv", (Object)lcb2);
                    this.session.setAttribute("jaasloginexception", (Object)e);
                    this.session.removeAttribute("loginThread");
                    this.notifyAll();
                }
            }
            catch (Exception ex) {
                LogUtil.warning("Write failed" + ex.getMessage());
            }
            LogUtil.severe("AUTHENTICATION FAILED" + e.getMessage());
        }
    }
}

