/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.websvcmgr.util;

import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import com.sun.tools.ws.processor.model.java.JavaType;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.visualweb.api.designerapi.DesignerServiceHack;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderMethod;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderParameter;
import org.netbeans.modules.visualweb.websvcmgr.consumer.DesignerWebServiceExtData;
import org.netbeans.modules.visualweb.websvcmgr.consumer.DesignerWebServiceExtImpl;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;

public class Util {
    public static final String dataproviderJar = InstalledFileLocator.getDefault().locate("modules/ext/dataprovider.jar", null, false).getAbsolutePath();
    public static final String designTimeJar = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-visualweb-designtime.jar", null, false).getAbsolutePath();
    public static final int BUFFER_SIZE = 4096;
    public static final String xsdNamespace = "xsd";
    public static final String WSDL_FILE_EXTENSION = "wsdl";
    private static final String[] PRIMITIVE_WRAPPER_CLASSES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Character", "java.lang.String"};
    private static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "char"};
    private static Map baseTypes = null;

    public static boolean isJAXRPCAvailable() {
        return Util.getWebServiceSupportLibDef(false) != null;
    }

    public static Library getWebServiceSupportLibDef(boolean bl) {
        String string = bl ? "jaxws21" : "jaxrpc16";
        Library library = LibraryManager.getDefault().getLibrary(string);
        return library;
    }

    public static Method getPropertyGetter(String string, String string2, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            char[] cArray = string2.toCharArray();
            String string3 = null;
            Method method = null;
            for (int i = 0; i < string2.length() && method == null; ++i) {
                cArray[i] = Character.toUpperCase(cArray[i]);
                string3 = new String(cArray);
                try {
                    method = clazz.getMethod("get" + string3, new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = clazz.getMethod("is" + string3, new Class[0]);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                }
            }
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isPrimitiveType(String string) {
        for (int i = 0; i < PRIMITIVE_WRAPPER_CLASSES.length; ++i) {
            if (!PRIMITIVE_WRAPPER_CLASSES[i].equals(string)) continue;
            return true;
        }
        return Util.isJavaPrimitive(string);
    }

    public static boolean isJavaPrimitive(String string) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getWrapperForPrimitive(String string) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(string)) continue;
            return PRIMITIVE_WRAPPER_CLASSES[i];
        }
        return null;
    }

    public static boolean hasOutput(JavaMethod javaMethod) {
        JavaType javaType = javaMethod.getReturnType();
        if (!"void".equals(javaType.getRealName())) {
            return true;
        }
        return Util.getOutputHolderIndex(javaMethod) >= 0;
    }

    public static int getOutputHolderIndex(JavaMethod javaMethod) {
        List list = javaMethod.getParametersList();
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            JavaParameter javaParameter = (JavaParameter)list.get(i);
            if (!javaParameter.isHolder() || !javaParameter.getParameter().isOUT() && !javaParameter.getParameter().isINOUT()) continue;
            return i;
        }
        return -1;
    }

    public static String typeToString(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getOwnerType() != null) {
                return null;
            }
            Type type2 = parameterizedType.getRawType();
            if (!(type2 instanceof Class)) {
                return null;
            }
            Class clazz = (Class)type2;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray == null || typeArray.length == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < typeArray.length; ++i) {
                String string = Util.typeToString(typeArray[0]);
                if (string == null) {
                    return null;
                }
                stringBuffer.append(string);
                if (i == typeArray.length - 1) continue;
                stringBuffer.append(',');
            }
            return clazz.getCanonicalName() + "<" + stringBuffer.toString() + ">";
        }
        if (type instanceof GenericArrayType) {
            String string = Util.typeToString(((GenericArrayType)type).getGenericComponentType());
            if (string != null) {
                return string + "[]";
            }
        } else if (type instanceof Class) {
            return ((Class)type).getCanonicalName();
        }
        return null;
    }

    public static String removeNamespace(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static Project getActiveProject() {
        FileObject fileObject = DesignerServiceHack.getDefault().getCurrentFile();
        if (fileObject == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public static boolean isAcronyn(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        return Character.isUpperCase(cArray[0]) && Character.isUpperCase(cArray[1]);
    }

    public static void insertSimpleTypes(Map map) {
        map.put("java.lang.Integer", "java.lang.Integer");
        map.put("java.lang.Short", "java.lang.Short");
        map.put("java.lang.Long", "java.lang.Long");
        map.put("java.lang.Double", "java.lang.Double");
        map.put("java.lang.Boolean", "java.lang.Boolean");
        map.put("java.lang.Character", "java.lang.Character");
        map.put("java.lang.Float", "java.lang.Float");
        map.put("java.lang.StringBuffer", "java.lang.StringBuffer");
        map.put("java.lang.Byte", "java.lang.Byte");
        map.put("java.lang.String", "java.lang.String");
        map.put("java.math.BigInteger", "java.math.BigInteger");
        map.put("char_lb_rb", "char[]");
        map.put("string", "java.lang.String");
        map.put("int", "int");
        map.put("short", "short");
        map.put("long", "long");
        map.put("double", "double");
        map.put("boolean", "boolean");
        map.put("char", "char");
        map.put("float", "float");
        map.put("byte", "byte");
        map.put("decimal", "java.math.BigDecimal");
        map.put("dateTime", "java.util.Date");
        map.put("xsd:string".intern(), "java.lang.String");
        map.put("xsd:int".intern(), "int");
        map.put("xsd:short".intern(), "short");
        map.put("xsd:long".intern(), "long");
        map.put("xsd:double".intern(), "double");
        map.put("xsd:boolean".intern(), "boolean");
        map.put("xsd:char".intern(), "char");
        map.put("xsd:float".intern(), "float");
        map.put("xsd:byte".intern(), "byte");
        map.put("xsd:decimal".intern(), "java.math.BigDecimal");
        map.put("xsd:dateTime".intern(), "java.util.Date");
    }

    public static boolean isSerializerNeeded(String string) {
        if (baseTypes == null) {
            baseTypes = new HashMap();
            Util.insertSimpleTypes(baseTypes);
        }
        return !baseTypes.containsKey(string);
    }

    public static String getMethodSignatureAsString(DataProviderMethod dataProviderMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dataProviderMethod.getMethodName());
        stringBuffer.append("(");
        boolean bl = true;
        for (DataProviderParameter dataProviderParameter : dataProviderMethod.getParameters()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            String string = dataProviderParameter.getType();
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static Method getCorrespondingJaxRpcMethod(JavaMethod javaMethod, String string, WebServiceData webServiceData) {
        WebServiceDescriptor webServiceDescriptor = webServiceData.getJaxRpcDescriptor();
        if (webServiceDescriptor == null) {
            return null;
        }
        try {
            Object object;
            WsdlServiceProxyDescriptor.JarEntry jarEntry2;
            List list = ManagerUtil.buildClasspath(null, (boolean)false);
            for (WsdlServiceProxyDescriptor.JarEntry jarEntry2 : webServiceDescriptor.getJars()) {
                if (!jarEntry2.getType().equals("proxy")) continue;
                object = new File(webServiceDescriptor.getXmlDescriptorFile().getParent(), jarEntry2.getName());
                list.add(((File)object).toURI().toURL());
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(list.toArray(new URL[list.size()]), Util.class.getClassLoader());
            jarEntry2 = webServiceData.getWsdlService().getPortByName(string);
            object = (DesignerWebServiceExtData)webServiceDescriptor.getConsumerData().get(DesignerWebServiceExtImpl.CONSUMER_ID);
            String string2 = ((DesignerWebServiceExtData)object).getPortToProxyBeanNameMap().get(jarEntry2.getName());
            Class<?> clazz = uRLClassLoader.loadClass(string2);
            Method[] methodArray = clazz.getDeclaredMethods();
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!Util.isSimilarMethod(methodArray[i].getName(), javaMethod.getName())) continue;
                arrayList.add(methodArray[i]);
            }
            if (arrayList.size() == 1) {
                return (Method)arrayList.get(0);
            }
            Method method = null;
            int n = -1;
            for (Method method2 : arrayList) {
                int n2 = Util.getMatchingParametersCount(method2, javaMethod);
                if (n2 > n) {
                    method = method2;
                    n = n2;
                    continue;
                }
                if (n2 != n || method2.getParameterTypes().length != javaMethod.getParametersList().size()) continue;
                method = method2;
            }
            return method;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static boolean isSimilarMethod(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        return string.replace("_", "").equalsIgnoreCase(string2);
    }

    private static int getMatchingParametersCount(Method method, JavaMethod javaMethod) {
        List list = javaMethod.getParametersList();
        Type[] typeArray = method.getGenericParameterTypes();
        int n = 0;
        for (int i = 0; i < typeArray.length && i < list.size(); ++i) {
            String string = ManagerUtil.typeToString((Type)typeArray[i]);
            JavaParameter javaParameter = (JavaParameter)list.get(i);
            if (javaParameter.isHolder() || !javaParameter.getType().getRealName().startsWith(string)) continue;
            ++n;
        }
        return n;
    }
}

