/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.cssengine;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssListValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValueService;
import org.netbeans.modules.visualweb.designer.cssengine.CssEngineServiceImpl;
import org.netbeans.modules.visualweb.designer.cssengine.CssValueConstants;
import org.netbeans.modules.visualweb.designer.cssengine.CssValueFactory;
import org.netbeans.modules.visualweb.designer.cssengine.CssValueImpl;
import org.netbeans.modules.visualweb.designer.cssengine.XhtmlCssEngine;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssValueServiceImpl
implements CssValueService {
    private static final String CSS_FONT_FAMILY_NAME_MONOSPACE = "monospace";
    private static final String CSS_FONT_FAMILY_NAME_SANS_SERIF = "sans-serif";
    private static final String JAVA_FONT_FAMILY_NAME_MONOSPACED = "monospaced";
    private static final String JAVA_FONT_FAMILY_NAME_SANS_SERIF = "SansSerif";
    private static final Object LOCK_FONT_MAPPING = new Object();
    private static Map<String, String> fontMapping;
    private static final CssValueService instance;
    private static final String[] CSS_LENGTH_UNITS;

    private CssValueServiceImpl() {
    }

    public static CssValueService getDefault() {
        return instance;
    }

    private static Value getCssValue(Element element, int n) {
        CssValueImpl cssValueImpl = CssEngineServiceImpl.get().getComputedValueImplForElement(element, n);
        return cssValueImpl == null ? null : cssValueImpl.getValue();
    }

    @Override
    public Color getColorForElement(Element element, int n) {
        Value value = CssValueServiceImpl.getCssValue(element, n);
        if (value == CssValueConstants.TRANSPARENT_RGB_VALUE) {
            return null;
        }
        if (value instanceof ComputedValue && ((ComputedValue)value).getComputedValue() == CssValueConstants.TRANSPARENT_RGB_VALUE) {
            return null;
        }
        if (value != null) {
            return CssValueServiceImpl.convertColor(value);
        }
        return null;
    }

    @Override
    public boolean isColorTransparentForElement(Element element, int n) {
        Value value = CssValueServiceImpl.getCssValue(element, n);
        if (value instanceof ComputedValue) {
            return ((ComputedValue)value).getComputedValue() == CssValueConstants.TRANSPARENT_RGB_VALUE;
        }
        return false;
    }

    @Override
    public String[] getCssLengthUnits() {
        return CSS_LENGTH_UNITS;
    }

    private static Color convertColor(Value value) {
        int n = CssValueServiceImpl.resolveColorComponent(value.getRed());
        int n2 = CssValueServiceImpl.resolveColorComponent(value.getGreen());
        int n3 = CssValueServiceImpl.resolveColorComponent(value.getBlue());
        return new Color(n, n2, n3, 255);
    }

    private static int resolveColorComponent(Value value) {
        switch (value.getPrimitiveType()) {
            case 2: {
                float f = value.getFloatValue();
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(255.0f * f / 100.0f);
            }
            case 1: {
                float f = value.getFloatValue();
                f = f > 255.0f ? 255.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(f);
            }
        }
        assert (false);
        return 0;
    }

    @Override
    public float getFontSizeForElement(Element element, int n) {
        Value value = CssValueServiceImpl.getCssValue(element, 25);
        if (value == null) {
            return n;
        }
        return value.getFloatValue();
    }

    @Override
    public int getFontStyleForElement(Element element, int n) {
        int n2 = n;
        Value value = CssValueServiceImpl.getCssValue(element, 30);
        if (value != null && (double)value.getFloatValue() > 400.0) {
            n2 |= 1;
        }
        if ((value = CssValueServiceImpl.getCssValue(element, 28)) == ValueConstants.ITALIC_VALUE || value == ValueConstants.OBLIQUE_VALUE) {
            n2 |= 2;
        }
        return n2;
    }

    @Override
    public String[] getFontFamilyNamesForElement(Element element) {
        Value value = CssValueServiceImpl.getCssValue(element, 24);
        return this.getFontFamilyNames(value);
    }

    private String[] getFontFamilyNames(Value value) {
        if (value == null || value.getLength() == 0) {
            return new String[]{JAVA_FONT_FAMILY_NAME_SANS_SERIF};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, String> map = this.getValidFontNameMapping();
        int n = value.getLength();
        for (int i = 0; i < n; ++i) {
            Value value2 = value.item(i);
            String string = value2.getStringValue();
            String string2 = map.get(CssValueServiceImpl.mapCssFontFamilyNameToJavaFontFamilyName(string));
            if (string2 == null) {
                string2 = map.get(string.toLowerCase());
            }
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(JAVA_FONT_FAMILY_NAME_SANS_SERIF);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getValidFontNameMapping() {
        Object object = LOCK_FONT_MAPPING;
        synchronized (object) {
            if (fontMapping == null) {
                String[] stringArray = null;
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (graphicsEnvironment != null) {
                    stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
                }
                if (stringArray == null) {
                    stringArray = Toolkit.getDefaultToolkit().getFontList();
                }
                if (stringArray != null) {
                    fontMapping = new HashMap<String, String>(stringArray.length * 2);
                    for (int i = stringArray.length - 1; i >= 0; --i) {
                        fontMapping.put(stringArray[i].toLowerCase(), stringArray[i]);
                        fontMapping.put(stringArray[i], stringArray[i]);
                    }
                } else {
                    fontMapping = new HashMap<String, String>();
                }
            }
        }
        return fontMapping;
    }

    private static String mapCssFontFamilyNameToJavaFontFamilyName(String string) {
        if (CSS_FONT_FAMILY_NAME_MONOSPACE.equals(string)) {
            return JAVA_FONT_FAMILY_NAME_MONOSPACED;
        }
        if (CSS_FONT_FAMILY_NAME_SANS_SERIF.equals(string)) {
            return JAVA_FONT_FAMILY_NAME_SANS_SERIF;
        }
        return string;
    }

    @Override
    public CssListValue getComputedCssListValue(CssValue cssValue) {
        ComputedValue computedValue;
        Value value;
        if (cssValue == null) {
            return null;
        }
        Value value2 = ((CssValueImpl)cssValue).getValue();
        if (value2 instanceof ListValue) {
            return CssValueFactory.createCssListValue((ListValue)value2);
        }
        if (value2 instanceof ComputedValue && (value = (computedValue = (ComputedValue)value2).getComputedValue()) instanceof ListValue) {
            return CssValueFactory.createCssListValue((ListValue)value);
        }
        return null;
    }

    @Override
    public boolean isAbsoluteValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.ABSOLUTE_VALUE);
    }

    @Override
    public boolean isAutoValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.AUTO_VALUE);
    }

    @Override
    public boolean isBaseLineValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.BASELINE_VALUE);
    }

    @Override
    public boolean isBlockValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.BLOCK_VALUE);
    }

    @Override
    public boolean isBothValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.BOTH_VALUE);
    }

    @Override
    public boolean isBottomValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.BOTTOM_VALUE);
    }

    @Override
    public boolean isCapitalizeValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.CAPITALIZE_VALUE);
    }

    @Override
    public boolean isCenterValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.CENTER_VALUE);
    }

    @Override
    public boolean isCircleValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.CIRCLE_VALUE);
    }

    @Override
    public boolean isCollapseValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.COLLAPSE_VALUE);
    }

    @Override
    public boolean isDashedValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.DASHED_VALUE);
    }

    @Override
    public boolean isDecimalValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.DECIMAL_VALUE);
    }

    @Override
    public boolean isDiscValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.DISC_VALUE);
    }

    @Override
    public boolean isDottedValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.DOTTED_VALUE);
    }

    @Override
    public boolean isDoubleValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.DOUBLE_VALUE);
    }

    @Override
    public boolean isFixedValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.FIXED_VALUE);
    }

    @Override
    public boolean isGridValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.GRID_VALUE);
    }

    @Override
    public boolean isGrooveValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.GROOVE_VALUE);
    }

    @Override
    public boolean isHiddenValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.HIDDEN_VALUE);
    }

    @Override
    public boolean isLeftValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.LEFT_VALUE);
    }

    @Override
    public boolean isListItemValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.LIST_ITEM_VALUE);
    }

    @Override
    public boolean isLowerAlphaValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.LOWER_ALPHA_VALUE);
    }

    @Override
    public boolean isLowerCaseValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.LOWERCASE_VALUE);
    }

    @Override
    public boolean isLowerLatinValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.LOWER_LATIN_VALUE);
    }

    @Override
    public boolean isLowerRomanValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.LOWER_ROMAN_VALUE);
    }

    @Override
    public boolean isInlineValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.INLINE_VALUE);
    }

    @Override
    public boolean isInlineBlockValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.INLINE_BLOCK_VALUE);
    }

    @Override
    public boolean isInsetValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.INSET_VALUE);
    }

    @Override
    public boolean isJustifyValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.JUSTIFY_VALUE);
    }

    @Override
    public boolean isMiddleValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.MIDDLE_VALUE);
    }

    @Override
    public boolean isNoneValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.NONE_VALUE);
    }

    @Override
    public boolean isNormalValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.NORMAL_VALUE);
    }

    @Override
    public boolean isNoRepeatValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.NO_REPEAT_VALUE);
    }

    @Override
    public boolean isNoWrapValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.NOWRAP_VALUE);
    }

    @Override
    public boolean isOutsetValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.OUTSET_VALUE);
    }

    @Override
    public boolean isPreValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.PRE_VALUE);
    }

    @Override
    public boolean isPreWrapValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.PRE_WRAP_VALUE);
    }

    @Override
    public boolean isRaveCenterValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.RAVECENTER_VALUE);
    }

    @Override
    public boolean isRelativeValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.RELATIVE_VALUE);
    }

    @Override
    public boolean isRepeatValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.REPEAT_VALUE);
    }

    @Override
    public boolean isRepeatXValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.REPEAT_X_VALUE);
    }

    @Override
    public boolean isRepeatYValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.REPEAT_Y_VALUE);
    }

    @Override
    public boolean isRidgeValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.RIDGE_VALUE);
    }

    @Override
    public boolean isRightValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.RIGHT_VALUE);
    }

    @Override
    public boolean isSmallCapsValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.SMALL_CAPS_VALUE);
    }

    @Override
    public boolean isSolidValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.SOLID_VALUE);
    }

    @Override
    public boolean isSquareValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.SQUARE_VALUE);
    }

    @Override
    public boolean isStaticValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.STATIC_VALUE);
    }

    @Override
    public boolean isSubValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.SUB_VALUE);
    }

    @Override
    public boolean isSuperValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.SUPER_VALUE);
    }

    @Override
    public boolean isTableValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_VALUE);
    }

    @Override
    public boolean isTableCaptionValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_CAPTION_VALUE);
    }

    @Override
    public boolean isTableCellValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_CELL_VALUE);
    }

    @Override
    public boolean isTableColumnValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_COLUMN_VALUE);
    }

    @Override
    public boolean isTableColumnGroupValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_COLUMN_GROUP_VALUE);
    }

    @Override
    public boolean isTableFooterGroupValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_FOOTER_GROUP_VALUE);
    }

    @Override
    public boolean isTableHeaderGroupValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_HEADER_GROUP_VALUE);
    }

    @Override
    public boolean isTableRowGroupValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_ROW_GROUP_VALUE);
    }

    @Override
    public boolean isTableRowValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TABLE_ROW_VALUE);
    }

    @Override
    public boolean isTextBottomValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TEXT_BOTTOM_VALUE);
    }

    @Override
    public boolean isTextTopValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TEXT_TOP_VALUE);
    }

    @Override
    public boolean isTopValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.TOP_VALUE);
    }

    @Override
    public boolean isUpperAlphaValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.UPPER_ALPHA_VALUE);
    }

    @Override
    public boolean isUpperCaseValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.UPPERCASE_VALUE);
    }

    @Override
    public boolean isUpperLatinValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.UPPER_LATIN_VALUE);
    }

    @Override
    public boolean isUpperRomanValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.UPPER_ROMAN_VALUE);
    }

    @Override
    public boolean isVisibleValue(CssValue cssValue) {
        return CssValueServiceImpl.isCssValueConstant(cssValue, CssValueConstants.VISIBLE_VALUE);
    }

    private static boolean isCssValueConstant(CssValue cssValue, Value value) {
        if (cssValue == null) {
            return false;
        }
        return ((CssValueImpl)cssValue).getValue() == value;
    }

    @Override
    public boolean isOfPrimitivePercentageType(CssValue cssValue) {
        if (!(cssValue instanceof CssValueImpl)) {
            return false;
        }
        return ((CssValueImpl)cssValue).getValue().getPrimitiveType() == 2;
    }

    @Override
    public boolean isOfPrimitiveEmsType(CssValue cssValue) {
        if (!(cssValue instanceof CssValueImpl)) {
            return false;
        }
        return ((CssValueImpl)cssValue).getValue().getPrimitiveType() == 3;
    }

    @Override
    public CssValue getBothCssValueConstant() {
        return CssValueFactory.createCssValue(CssValueConstants.BOTH_VALUE);
    }

    @Override
    public CssValue getCollapseCssValueConstant() {
        return CssValueFactory.createCssValue(CssValueConstants.COLLAPSE_VALUE);
    }

    @Override
    public CssValue getDecimalCssValueConstant() {
        return CssValueFactory.createCssValue(CssValueConstants.DECIMAL_VALUE);
    }

    @Override
    public CssValue getDiscCssValueConstant() {
        return CssValueFactory.createCssValue(CssValueConstants.DISC_VALUE);
    }

    @Override
    public CssValue getTableFooterGroupValueConstant() {
        return CssValueFactory.createCssValue(CssValueConstants.TABLE_FOOTER_GROUP_VALUE);
    }

    @Override
    public CssValue getTableHeaderGroupValueConstant() {
        return CssValueFactory.createCssValue(CssValueConstants.TABLE_HEADER_GROUP_VALUE);
    }

    @Override
    public CssValue getTableRowGroupValueConstant() {
        return CssValueFactory.createCssValue(CssValueConstants.TABLE_ROW_GROUP_VALUE);
    }

    @Override
    public CssValue getTableRowValueConstant() {
        return CssValueFactory.createCssValue(CssValueConstants.TABLE_ROW_VALUE);
    }

    @Override
    public boolean isPositionProperty(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("clear") || string.equals("float") || string.equals("height") || string.equals("left") || string.equals("right") || string.equals("position") || string.equals("top") || string.equals("z-index") || string.equals("width");
    }

    @Override
    public boolean isTextProperty(String string) {
        return string.startsWith("font-") || string.startsWith("text-") || string.equals("vertical-align") || string.equals("white-space") || string.equals("color") || string.equals("letter-spacing") || string.equals("word-spacing");
    }

    @Override
    public boolean isAutoValue(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("auto");
    }

    @Override
    public String getAbsoluteValue() {
        return "absolute";
    }

    @Override
    public String getGridValue() {
        return "grid";
    }

    @Override
    public String getHeightProperty() {
        return "height";
    }

    @Override
    public String getWidthProperty() {
        return "width";
    }

    @Override
    public boolean hasNoUnits(String string) {
        return XhtmlCssEngine.hasNoUnits(string);
    }

    @Override
    public boolean isInlineTag(CssValue cssValue, Element element, HtmlTag htmlTag) {
        if (this.isNoneValue(cssValue)) {
            return false;
        }
        if (this.isBlockValue(cssValue) || this.isListItemValue(cssValue) || this.isTableValue(cssValue) || this.isInlineBlockValue(cssValue)) {
            return false;
        }
        if (this.isInlineValue(cssValue)) {
            return true;
        }
        if (htmlTag == null) {
            htmlTag = HtmlTag.getTag((String)element.getTagName());
        }
        if (htmlTag != null) {
            return htmlTag.isInlineTag();
        }
        return true;
    }

    @Override
    public int getCssLength(Element element, int n) {
        CssValue cssValue = CssEngineServiceImpl.get().getComputedValueForElement(element, n);
        if (cssValue == null) {
            return 0;
        }
        if (this.isAutoValue(cssValue)) {
            return 0x7FFFFFFE;
        }
        return (int)cssValue.getFloatValue();
    }

    static {
        instance = new CssValueServiceImpl();
        CSS_LENGTH_UNITS = new String[]{"%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc"};
    }
}

