/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProjectCreateData;
import org.netbeans.modules.ruby.railsprojects.RailsProjectGenerator;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapterFactory;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.DatabaseConfigPanel;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.RailsInstallationPanel;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class NewRailsProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    static final String JDBC_WN = "useJdbc";
    static final String RAILS_DB_WN = "railsDatabase";
    static final String RAILS_DEVELOPMENT_DB = "railsDatabase.development";
    static final String RAILS_PRODUCTION_DB = "railsDatabase.production";
    static final String RAILS_TEST_DB = "railsDatabase.test";
    static final String GOLDSPIKE_WN = "goldspike";
    static final String SERVER_INSTANCE = "serverInstance";
    static final String PLATFORM = "platform";
    static final int TYPE_APP = 0;
    static final int TYPE_EXT = 2;
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final long serialVersionUID = 1L;
    private int type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    public NewRailsProjectWizardIterator() {
        this(0);
    }

    public NewRailsProjectWizardIterator(int n) {
        this.type = n;
    }

    public static NewRailsProjectWizardIterator existing() {
        return new NewRailsProjectWizardIterator(2);
    }

    private WizardDescriptor.Panel[] createPanels() {
        if (this.type == 0) {
            return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type), new DatabaseConfigPanel(), new RailsInstallationPanel.Panel()};
        }
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
    }

    private String[] createSteps() {
        String string = NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LAB_ConfigureProject");
        String string2 = NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LAB_ConfigureDatabase");
        String string3 = NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LAB_InstallRails");
        if (this.type == 0) {
            return new String[]{string, string2, string3};
        }
        return new String[]{string};
    }

    public Set instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set instantiate(ProgressHandle progressHandle) throws IOException {
        FileObject fileObject;
        progressHandle.start(4);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        File file = (File)this.wiz.getProperty("projdir");
        if (file != null) {
            file = FileUtil.normalizeFile((File)file);
        }
        String string = (String)this.wiz.getProperty("name");
        progressHandle.progress(NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LBL_NewRailsProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        RakeProjectHelper rakeProjectHelper = null;
        Boolean bl = (Boolean)this.wiz.getProperty(GOLDSPIKE_WN);
        RubyInstance rubyInstance = (RubyInstance)this.wiz.getProperty(SERVER_INSTANCE);
        RubyPlatform rubyPlatform = (RubyPlatform)this.wiz.getProperty(PLATFORM);
        RailsDatabaseConfiguration railsDatabaseConfiguration = (RailsDatabaseConfiguration)this.wiz.getProperty(RAILS_DEVELOPMENT_DB);
        if (railsDatabaseConfiguration == null) {
            railsDatabaseConfiguration = RailsAdapterFactory.getDefaultAdapter();
        }
        RailsProjectCreateData railsProjectCreateData = new RailsProjectCreateData(rubyPlatform, file, string, this.type == 0, railsDatabaseConfiguration, bl, rubyInstance.getServerUri());
        rakeProjectHelper = RailsProjectGenerator.createProject(railsProjectCreateData);
        progressHandle.progress(2);
        FileObject fileObject2 = FileUtil.toFileObject((File)file);
        progressHandle.progress(3);
        hashSet.add(fileObject2);
        progressHandle.progress(NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LBL_NewRailsProjectWizardIterator_WizardProgress_PreparingToOpen"), 4);
        File file2 = file = file != null ? file.getParentFile() : null;
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        if (this.type == 0 && (fileObject = fileObject2.getFileObject("config/database.yml")) != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    editorCookie.open();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }
        return hashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz.putProperty("mainClass", null);
            this.wiz.putProperty(PLATFORM, null);
            this.wiz = null;
            this.panels = null;
        }
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private FileObject getMainClassFO(FileObject fileObject, String string) {
        return fileObject.getFileObject(string);
    }

    static String getPackageName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((bl || !Character.isJavaIdentifierPart(c)) && (!bl || !Character.isJavaIdentifierStart(c))) continue;
            bl = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.length() == 0 ? NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : stringBuffer.toString();
    }
}

