/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.RailsApplication;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.ServerResolver;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class RailsServerManager {
    private static final Logger LOGGER = Logger.getLogger(RailsServerManager.class.getName());
    private static final Set<Integer> IN_USE_PORTS = new HashSet<Integer>();
    private static final int SERVER_STARTUP_TIMEOUT = 120;
    private ServerStatus status = ServerStatus.NOT_STARTED;
    private RubyServer server;
    private boolean portConflict;
    private int originalPort;
    private int port = -1;
    private RailsProject project;
    private RubyExecution execution;
    private File dir;
    private boolean debug;
    private boolean switchToDebugMode;
    private Semaphore debugSemaphore;

    public RailsServerManager(RailsProject railsProject) {
        this.project = railsProject;
        this.dir = FileUtil.toFile((FileObject)railsProject.getProjectDirectory());
    }

    public synchronized void setDebug(boolean bl) {
        if (this.status == ServerStatus.RUNNING && !this.debug && bl) {
            this.switchToDebugMode = true;
        }
        this.debug = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRunning() {
        Object object;
        Object object2;
        Object object3;
        Object object4 = this;
        synchronized (object4) {
            if (this.status == ServerStatus.STARTING) {
                return;
            }
            if (this.status == ServerStatus.RUNNING) {
                if (this.switchToDebugMode) {
                    assert (this.debugSemaphore == null) : "startSemaphor supposed to be null";
                    this.debugSemaphore = new Semaphore(0);
                    this.switchToDebugMode = false;
                } else if (RailsServerManager.isPortInUse(this.port)) {
                    return;
                }
            }
        }
        if (this.debugSemaphore != null) {
            try {
                if (this.execution != null) {
                    this.execution.kill();
                }
                this.debugSemaphore.acquire();
                this.debugSemaphore = null;
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
        object4 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RailsServerManager railsServerManager = RailsServerManager.this;
                synchronized (railsServerManager) {
                    RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                    if (RailsServerManager.this.server != null) {
                        RailsServerManager.this.server.removeApplication(RailsServerManager.this.port);
                    }
                    IN_USE_PORTS.remove(RailsServerManager.this.port);
                    if (RailsServerManager.this.portConflict) {
                        RailsServerManager.this.notifyPortConflict();
                    }
                    if (RailsServerManager.this.debugSemaphore != null) {
                        RailsServerManager.this.debugSemaphore.release();
                    } else {
                        RailsServerManager.this.debug = false;
                    }
                }
            }
        };
        Object object5 = this;
        synchronized (object5) {
            this.status = ServerStatus.STARTING;
        }
        this.portConflict = false;
        object5 = this.project.evaluator().getProperty("rails.port");
        this.port = 0;
        if (object5 != null) {
            this.port = Integer.parseInt((String)object5);
        }
        if (this.port == 0) {
            this.port = 3000;
        }
        this.originalPort = this.port;
        while (RailsServerManager.isPortInUse(this.port)) {
            ++this.port;
        }
        String string = ((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
        String string2 = this.project.evaluator().getProperty("javac.classpath");
        String string3 = this.project.evaluator().getProperty("rails.servertype");
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        RubyInstance rubyInstance = ServerRegistry.getDefault().getServer(string3, rubyPlatform);
        if (rubyInstance == null) {
            object3 = ServerRegistry.getDefault().getServers();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!object.isPlatformSupported(rubyPlatform)) continue;
                rubyInstance = object;
                break;
            }
            assert (rubyInstance != null) : "No servers found for " + rubyPlatform;
        }
        if (!(rubyInstance instanceof RubyServer)) {
            object3 = rubyInstance.runApplication(rubyPlatform, string, this.dir);
            object2 = rubyInstance;
            RequestProcessor.getDefault().post(new Runnable((Future)object3, (RubyInstance)object2){
                final /* synthetic */ Future val$result;
                final /* synthetic */ RubyInstance val$serverInstance;
                {
                    this.val$result = future;
                    this.val$serverInstance = rubyInstance;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block12: {
                        try {
                            RubyInstance.OperationState operationState = (RubyInstance.OperationState)((Object)this.val$result.get());
                            if (operationState == RubyInstance.OperationState.COMPLETED) {
                                RailsServerManager railsServerManager = RailsServerManager.this;
                                synchronized (railsServerManager) {
                                    RailsServerManager.this.port = this.val$serverInstance.getRailsPort();
                                    RailsServerManager.this.status = ServerStatus.RUNNING;
                                    break block12;
                                }
                            }
                            RailsServerManager railsServerManager = RailsServerManager.this;
                            synchronized (railsServerManager) {
                                RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.log(Level.INFO, exception.getMessage(), exception);
                            RailsServerManager railsServerManager = RailsServerManager.this;
                            synchronized (railsServerManager) {
                                RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                            }
                        }
                    }
                }
            });
            return;
        }
        object3 = ServerResolver.getExplicitlySpecifiedServer(this.project);
        this.server = (RubyServer)(object3 != null ? object3 : rubyInstance);
        object2 = RailsServerManager.getServerTabName(this.server, string, this.port);
        object = this.server.getServerPath();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor(RubyPlatform.platformFor((Project)this.project), (String)object2, this.dir, (String)object);
        executionDescriptor.additionalArgs(this.buildStartupArgs());
        executionDescriptor.postBuild((Runnable)object4);
        executionDescriptor.classPath(string2);
        executionDescriptor.addStandardRecognizers();
        executionDescriptor.addOutputRecognizer((OutputRecognizer)new RailsServerRecognizer(this.server));
        executionDescriptor.frontWindow(false);
        executionDescriptor.debug(this.debug);
        executionDescriptor.fastDebugRequired(this.debug);
        executionDescriptor.fileLocator((FileLocator)new DirectoryFileLocator(FileUtil.toFileObject((File)this.dir)));
        executionDescriptor.showSuspended(true);
        String string4 = this.project.evaluator().getProperty("source.encoding");
        IN_USE_PORTS.add(this.port);
        this.execution = new RubyExecution(executionDescriptor, string4);
        this.execution.run();
    }

    private String[] buildStartupArgs() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.server.getStartupParam() != null) {
            arrayList.add(this.server.getStartupParam());
        }
        if ((string = this.project.evaluator().getProperty("rails.env")) != null && !"".equals(string.trim())) {
            arrayList.add("-e");
            arrayList.add(string);
        }
        arrayList.add("--port");
        arrayList.add(Integer.toString(this.port));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String getServerTabName(RubyServer rubyServer, String string, int n) {
        return NbBundle.getMessage(RailsServerManager.class, (String)"LBL_ServerTab", (Object)rubyServer.getDisplayName(), (Object)string, (Object)String.valueOf(n));
    }

    private void notifyPortConflict() {
        String string = NbBundle.getMessage(RailsServerManager.class, (String)"Conflict", (Object)Integer.toString(this.originalPort));
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showUrl(final String string) {
        Object object = this;
        synchronized (object) {
            if (!this.switchToDebugMode && this.status == ServerStatus.RUNNING && RailsServerManager.isPortInUse(this.port)) {
                RailsServerManager.showURL(string, this.port);
                return;
            }
        }
        this.ensureRunning();
        object = NbBundle.getMessage(RailsServerManager.class, (String)"ServerStartup");
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)object, (Cancellable)new Cancellable(){

            public boolean cancel() {
                return true;
            }
        }, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int n;
                    for (n = 0; n <= 120; ++n) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        RailsServerManager railsServerManager = RailsServerManager.this;
                        synchronized (railsServerManager) {
                            block12: {
                                if (RailsServerManager.this.status != ServerStatus.RUNNING) break block12;
                                LOGGER.fine("Server " + RailsServerManager.this.server + " started in " + n + " seconds.");
                                RailsServerManager.showURL(string, RailsServerManager.this.port);
                                return;
                            }
                            if (RailsServerManager.this.status == ServerStatus.NOT_STARTED) {
                                LOGGER.fine("Server starup failed, server type is: " + RailsServerManager.this.server);
                                break;
                            }
                            continue;
                        }
                    }
                    LOGGER.fine("Could not start " + RailsServerManager.this.server + " in " + n + " seconds, current server status is " + (Object)((Object)RailsServerManager.this.status));
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RailsServerManager.class, (String)"NoServerFound", (Object)("http://localhost:" + RailsServerManager.this.port + "/" + string)));
                }
                finally {
                    progressHandle.finish();
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    public static boolean isPortInUse(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void showURL(String string, int n) {
        LOGGER.fine("Opening URL: http://localhost:" + n + "/" + string);
        try {
            URL uRL = new URL("http://localhost:" + n + "/" + string);
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
        }
    }

    static boolean isAddressInUseMsg(String string) {
        return string.matches(".*in.*: Address.+in use.+(Errno::EADDRINUSE).*");
    }

    public static JComboBox getServerComboBox(RubyPlatform rubyPlatform) {
        JComboBox jComboBox = new JComboBox();
        if (rubyPlatform != null) {
            jComboBox.setModel(new ServerListModel(rubyPlatform));
        }
        jComboBox.setRenderer(new ServerListCellRendered());
        return jComboBox;
    }

    private static class ServerListCellRendered
    extends JLabel
    implements ListCellRenderer {
        public ServerListCellRendered() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            RubyInstance rubyInstance = (RubyInstance)object;
            if (rubyInstance != null) {
                this.setText(rubyInstance.getDisplayName());
                this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            }
            return this;
        }
    }

    public static class ServerListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<? extends RubyInstance> servers;
        private Object selected;

        public ServerListModel(RubyPlatform rubyPlatform) {
            this.servers = ServerRegistry.getDefault().getServers(rubyPlatform);
            this.selected = this.servers.get(0);
        }

        public int getSize() {
            return this.servers.size();
        }

        public Object getElementAt(int n) {
            return this.servers.get(n);
        }

        public void setSelectedItem(Object object) {
            if (this.selected != object) {
                this.selected = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selected;
        }
    }

    private class RailsServerRecognizer
    extends OutputRecognizer {
        private final RubyServer server;

        RailsServerRecognizer(RubyServer rubyServer) {
            this.server = rubyServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputRecognizer.ActionText processLine(String string) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Processing output line: " + string);
            }
            String string2 = string;
            if (this.server.isStartupMsg(string)) {
                RailsServerManager railsServerManager = RailsServerManager.this;
                synchronized (railsServerManager) {
                    LOGGER.fine("Identified " + this.server + " as running");
                    RailsServerManager.this.status = ServerStatus.RUNNING;
                    String string3 = ((ProjectInformation)RailsServerManager.this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
                    this.server.addApplication(new RailsApplication(string3, RailsServerManager.this.port, RailsServerManager.this.execution));
                }
            } else if (RailsServerManager.isAddressInUseMsg(string)) {
                LOGGER.fine("Detected port conflict: " + string);
                RailsServerManager.this.portConflict = true;
            }
            if (!string2.equals(string)) {
                return new OutputRecognizer.ActionText(new String[]{string2}, null, null, null);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ServerStatus {
        NOT_STARTED,
        STARTING,
        RUNNING;

    }
}

