/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.NbUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.railsprojects.RailsFileLocator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.UpdateHelper;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerManager;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.GotoTest;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.TestNotifier;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RailsActionProvider
implements ActionProvider,
ScriptDescProvider {
    public static final String COMMAND_RDOC = "rdoc";
    public static final String COMMAND_AUTOTEST = "autotest";
    public static final String COMMAND_RAILS_CONSOLE = "rails-console";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "autotest", "rdoc", "rails-console", "run", "run.single", "debug", "debug.single", "test", "test.single", "debug.test.single", "delete", "copy", "move", "rename"};
    RailsProject project;
    private UpdateHelper updateHelper;
    final Set<String> bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single"));

    public RailsActionProvider(RailsProject railsProject, UpdateHelper updateHelper) {
        this.updateHelper = updateHelper;
        this.project = railsProject;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    private RubyPlatform getPlatform() {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        if (rubyPlatform == null) {
            rubyPlatform = RubyPlatformManager.getDefaultPlatform();
        }
        return rubyPlatform;
    }

    private boolean isMigrationFile(FileObject fileObject) {
        if (fileObject.getParent() == null || !fileObject.getParent().getName().equals("migrate")) {
            return false;
        }
        if (fileObject.getParent().getParent() == null || !fileObject.getParent().getParent().getName().equals("db")) {
            return false;
        }
        if (!fileObject.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        return fileObject.getName().matches("\\d\\d\\d_.*");
    }

    private FileObject getCurrentFile(Lookup lookup) {
        FileObject fileObject = null;
        FileObject[] fileObjectArray = this.findSources(lookup);
        if (fileObjectArray != null && fileObjectArray.length > 0) {
            fileObject = fileObjectArray[0];
        } else {
            for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
                FileObject fileObject2 = dataObject.getPrimaryFile();
                if (!fileObject2.getMIMEType().equals("text/x-ruby")) continue;
                fileObject = fileObject2;
                break;
            }
        }
        return fileObject;
    }

    private void saveFile(FileObject fileObject) {
        try {
            SaveCookie saveCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                saveCookie.save();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        boolean bl = "debug".equals(string);
        boolean bl2 = "debug.single".equals(string);
        if ("run".equals(string) || bl) {
            LifecycleManager.getDefault().saveAll();
            this.runServer("", bl);
            return;
        }
        if ("test".equals(string)) {
            if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)true)) {
                return;
            }
            LifecycleManager.getDefault().saveAll();
            RakeSupport rakeSupport = new RakeSupport((Project)this.project);
            rakeSupport.setTest(true);
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            String string2 = NbBundle.getMessage(RailsActionProvider.class, (String)"Tests");
            rakeSupport.runRake(file, null, string2, (FileLocator)new RailsFileLocator(lookup, this.project), true, false, new String[]{"test"});
            return;
        }
        if ("test.single".equals(string) || "debug.test.single".equals(string)) {
            if (!RubyPlatform.platformFor((Project)this.project).isValidRuby(true)) {
                return;
            }
            FileObject fileObject = this.getCurrentFile(lookup);
            if (fileObject == null) {
                return;
            }
            this.saveFile(fileObject);
            DeclarationFinder.DeclarationLocation declarationLocation = new GotoTest().findTest(fileObject, -1);
            if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                fileObject = declarationLocation.getFileObject();
                this.saveFile(fileObject);
            } else if (RubyUtils.isRhtmlFile((FileObject)fileObject)) {
                return;
            }
            boolean bl3 = "debug.test.single".equals(string);
            RSpecSupport rSpecSupport = new RSpecSupport((Project)this.project);
            if (rSpecSupport.isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)fileObject)) {
                rSpecSupport.runRSpec(null, fileObject, fileObject.getName(), (FileLocator)new RailsFileLocator(lookup, this.project), true, bl3, new String[0]);
                return;
            }
            this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl3, new OutputRecognizer[]{new TestNotifier(true, true)});
            return;
        }
        if ("run.single".equals(string) || bl2) {
            if (!RubyPlatform.platformFor((Project)this.project).isValidRuby(true)) {
                return;
            }
            FileObject fileObject = this.getCurrentFile(lookup);
            if (fileObject == null) {
                return;
            }
            if (RakeSupport.isRakeFile((FileObject)fileObject)) {
                LifecycleManager.getDefault().saveAll();
                RakeSupport rakeSupport = new RakeSupport((Project)this.project);
                rakeSupport.runRake(null, fileObject, fileObject.getName(), (FileLocator)new RailsFileLocator(lookup, this.project), true, bl2, new String[0]);
                return;
            }
            RSpecSupport rSpecSupport = new RSpecSupport((Project)this.project);
            if (rSpecSupport.isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)fileObject)) {
                LifecycleManager.getDefault().saveAll();
                rSpecSupport.runRSpec(null, fileObject, fileObject.getName(), (FileLocator)new RailsFileLocator(lookup, this.project), true, bl2, new String[0]);
                return;
            }
            this.saveFile(fileObject);
            if (this.isMigrationFile(fileObject)) {
                String string3 = fileObject.getName();
                String string4 = Integer.toString(Integer.parseInt(string3.substring(0, 3)));
                RakeSupport rakeSupport = new RakeSupport((Project)this.project);
                rakeSupport.runRake(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), null, fileObject.getName(), (FileLocator)new RailsFileLocator(lookup, this.project), true, bl2, new String[]{"db:migrate", "VERSION=" + string4});
                return;
            }
            String string5 = "";
            String string6 = fileObject.getName();
            if (fileObject.getExt().equals("rhtml") || fileObject.getExt().equals("erb")) {
                if (string6.endsWith(".html")) {
                    string6 = string6.substring(0, string6.length() - ".html".length());
                }
                if (!string6.startsWith("_")) {
                    string5 = string6;
                }
                FileObject fileObject2 = this.project.getProjectDirectory();
                for (FileObject fileObject3 = fileObject.getParent(); fileObject3 != null && fileObject3 != fileObject2 && (!fileObject3.getName().equals("views") || fileObject3.getParent() != null && !fileObject3.getParent().getName().equals("app")); fileObject3 = fileObject3.getParent()) {
                    string5 = fileObject3.getNameExt() + "/" + string5;
                }
            } else if (string6.endsWith("_controller")) {
                String string7;
                int n;
                FileObject fileObject4;
                FileObject fileObject5;
                string5 = string6.substring(0, string6.length() - "_controller".length());
                FileObject fileObject6 = this.project.getProjectDirectory();
                for (fileObject5 = fileObject.getParent(); fileObject5 != null && fileObject5 != fileObject6; fileObject5 = fileObject5.getParent()) {
                    if (fileObject5.getName().equals("controllers") && (fileObject5.getParent() == null || fileObject5.getParent().getName().equals("app"))) {
                        fileObject5 = fileObject5.getParent();
                        break;
                    }
                    string5 = fileObject5.getNameExt() + "/" + string5;
                }
                JTextComponent jTextComponent = NbUtilities.getOpenPane();
                if (fileObject5 != null && jTextComponent != null && jTextComponent.getCaret() != null && (fileObject4 = NbUtilities.findFileObject((JTextComponent)jTextComponent)) != null && (n = jTextComponent.getCaret().getDot()) >= 0 && (string7 = AstUtilities.getMethodName((FileObject)fileObject, (int)n)) != null) {
                    string5 = string5 + "/" + string7;
                }
            } else if (string6.endsWith("_helper")) {
                string5 = string6.substring(0, string6.length() - "_helper".length());
                FileObject fileObject7 = this.project.getProjectDirectory();
                for (FileObject fileObject8 = fileObject.getParent(); fileObject8 != null && fileObject8 != fileObject7 && (!fileObject8.getName().equals("helpers") || fileObject8.getParent() != null && !fileObject8.getParent().getName().equals("app")); fileObject8 = fileObject8.getParent()) {
                    string5 = fileObject8.getNameExt() + "/" + string5;
                }
            } else if (string6.endsWith("_test")) {
                this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl2, new OutputRecognizer[]{new TestNotifier(true, true)});
                return;
            }
            if (string5.length() == 0) {
                this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl2, null);
                return;
            }
            this.runServer(string5, bl || bl2);
            return;
        }
        if ("build".equals(string)) {
            if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)true)) {
                return;
            }
            LifecycleManager.getDefault().saveAll();
            RailsFileLocator railsFileLocator = new RailsFileLocator(lookup, this.project);
            String string8 = NbBundle.getMessage(RailsActionProvider.class, (String)"Rake");
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.project);
            if (projectInformation != null) {
                string8 = projectInformation.getDisplayName();
            }
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            String string9 = this.project.evaluator().getProperty("javac.classpath");
            new RubyExecution(new ExecutionDescriptor(this.getPlatform(), string8, file, RubyPlatform.gemManagerFor((Project)this.project).getRake()).fileLocator((FileLocator)railsFileLocator).classPath(string9).addStandardRecognizers().appendJdkToPath(RubyPlatform.platformFor((Project)this.project).isJRuby()).addOutputRecognizer((OutputRecognizer)RubyExecution.RUBY_TEST_OUTPUT), this.project.evaluator().getProperty("source.encoding")).run();
            return;
        }
        if (COMMAND_RDOC.equals(string)) {
            if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)true)) {
                return;
            }
            LifecycleManager.getDefault().saveAll();
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            Runnable runnable = new Runnable(){

                public void run() {
                    FileObject fileObject;
                    FileObject fileObject2 = RailsActionProvider.this.project.getProjectDirectory().getFileObject("doc/app");
                    if (fileObject2 != null && (fileObject = fileObject2.getFileObject("index.html")) != null) {
                        try {
                            URL uRL = FileUtil.toFile((FileObject)fileObject).toURI().toURL();
                            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                        }
                        catch (MalformedURLException malformedURLException) {
                            ErrorManager.getDefault().notify((Throwable)malformedURLException);
                        }
                    }
                }
            };
            RailsFileLocator railsFileLocator = new RailsFileLocator(lookup, this.project);
            String string10 = NbBundle.getMessage(RailsActionProvider.class, (String)"RakeDoc");
            new RubyExecution(new ExecutionDescriptor(this.getPlatform(), string10, file, RubyPlatform.gemManagerFor((Project)this.project).getRake()).additionalArgs(new String[]{"appdoc"}).postBuild(runnable).fileLocator((FileLocator)railsFileLocator).addStandardRecognizers(), this.project.evaluator().getProperty("source.encoding")).run();
            return;
        }
        if (COMMAND_AUTOTEST.equals(string)) {
            if (AutoTestSupport.isInstalled((Project)this.project)) {
                AutoTestSupport autoTestSupport = new AutoTestSupport(lookup, (Project)this.project, this.project.evaluator().getProperty("source.encoding"));
                autoTestSupport.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                autoTestSupport.start();
            }
            return;
        }
        if (COMMAND_RAILS_CONSOLE.equals(string)) {
            this.openRailsConsole(lookup);
            return;
        }
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
    }

    private void openRailsConsole(Lookup lookup) {
        String string = NbBundle.getMessage(RailsActionProvider.class, (String)"RailsConsole");
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String string2 = "script" + File.separator + "console";
        String string3 = this.project.evaluator().getProperty("javac.classpath");
        new RubyExecution(new ExecutionDescriptor(this.getPlatform(), string, file, string2).showSuspended(false).showProgress(false).classPath(string3).allowInput().additionalArgs(new String[]{"--irb=irb --noreadline"}).fileLocator((FileLocator)new RailsFileLocator(lookup, this.project)).addStandardRecognizers(), this.project.evaluator().getProperty("source.encoding")).run();
    }

    private void runRubyScript(FileObject fileObject, String string, String string2, Lookup lookup, boolean bl, OutputRecognizer[] outputRecognizerArray) {
        ExecutionDescriptor executionDescriptor = this.getScriptDescriptor(null, fileObject, string, string2, lookup, bl, outputRecognizerArray);
        RubyExecution rubyExecution = new RubyExecution(executionDescriptor, this.project.evaluator().getProperty("source.encoding"));
        rubyExecution.run();
    }

    public ExecutionDescriptor getScriptDescriptor(File file, FileObject fileObject, String string, String string2, Lookup lookup, boolean bl, OutputRecognizer[] outputRecognizerArray) {
        String object = this.project.evaluator().getProperty("run.jvmargs");
        if (object != null && object.trim().length() == 0) {
            object = null;
        }
        FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        StringBuilder stringBuilder = new StringBuilder();
        if (fileObjectArray != null && fileObjectArray.length > 0) {
            for (FileObject fileObject2 : fileObjectArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("-I\"");
                stringBuilder.append(FileUtil.toFile((FileObject)fileObject2).getAbsoluteFile());
                stringBuilder.append("\"");
            }
        }
        if (fileObjectArray2 != null && fileObjectArray2.length > 0) {
            for (FileObject fileObject2 : fileObjectArray2) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("-I\"");
                stringBuilder.append(FileUtil.toFile((FileObject)fileObject2).getAbsoluteFile());
                stringBuilder.append("\"");
            }
        }
        String string3 = stringBuilder.toString();
        object = object != null ? string3 + " " + object : string3;
        if (!new File(string).exists() && fileObjectArray != null && fileObjectArray.length > 0) {
            int n = 0;
            for (FileObject fileObject3 : fileObjectArray) {
                FileObject fileObject4 = fileObject3.getFileObject(string);
                if (fileObject4 == null) continue;
                string = FileUtil.toFile((FileObject)fileObject4).getAbsolutePath();
                n = 1;
                break;
            }
            if (n == 0 && fileObjectArray2 != null) {
                for (FileObject fileObject3 : fileObjectArray2) {
                    FileObject fileObject5 = fileObject3.getFileObject(string);
                    if (fileObject5 == null) continue;
                    string = FileUtil.toFile((FileObject)fileObject5).getAbsolutePath();
                    break;
                }
            }
        }
        if (file == null) {
            file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        String string4 = this.project.evaluator().getProperty("javac.classpath");
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor(this.getPlatform(), string2, file, string);
        executionDescriptor.debug(bl);
        executionDescriptor.showSuspended(true);
        executionDescriptor.allowInput();
        executionDescriptor.initialArgs(object);
        executionDescriptor.classPath(string4);
        executionDescriptor.additionalArgs(this.getApplicationArguments());
        executionDescriptor.fileLocator((FileLocator)new RailsFileLocator(lookup, this.project));
        executionDescriptor.addStandardRecognizers();
        executionDescriptor.addOutputRecognizer((OutputRecognizer)RubyExecution.RUBY_TEST_OUTPUT);
        if (outputRecognizerArray != null) {
            for (OutputRecognizer outputRecognizer : outputRecognizerArray) {
                executionDescriptor.addOutputRecognizer(outputRecognizer);
            }
        }
        return executionDescriptor;
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        return true;
    }

    private FileObject[] findSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = RailsActionProvider.findSelectedFiles(lookup, fileObjectArray[i], "text/x-ruby", true);
            if (fileObjectArray2 != null) {
                return fileObjectArray2;
            }
            fileObjectArray2 = RailsActionProvider.findSelectedFiles(lookup, fileObjectArray[i], "application/x-httpd-eruby", true);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    static FileObject[] findSelectedFiles(Lookup lookup, FileObject fileObject, String string, boolean bl) {
        if (fileObject != null && !fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + fileObject);
        }
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            boolean bl2;
            FileObject fileObject2 = dataObject.getPrimaryFile();
            boolean bl3 = bl2 = FileUtil.toFile((FileObject)fileObject2) != null;
            if (fileObject != null) {
                bl2 &= FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject == fileObject2;
            }
            if (string != null) {
                bl2 &= fileObject2.getMIMEType().equals(string);
            }
            if (bl2) {
                linkedHashSet.add(fileObject2);
                continue;
            }
            if (!bl) continue;
            return null;
        }
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        return linkedHashSet.toArray(new FileObject[linkedHashSet.size()]);
    }

    private String[] getApplicationArguments() {
        String string = this.project.evaluator().getProperty("application.args");
        return string == null || string.trim().length() == 0 ? null : Utilities.parseParameters((String)string);
    }

    private void runServer(String string, boolean bl) {
        RailsServerManager railsServerManager = (RailsServerManager)this.project.getLookup().lookup(RailsServerManager.class);
        if (railsServerManager != null) {
            railsServerManager.setDebug(bl);
            railsServerManager.showUrl(string);
        }
    }
}

