/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.railsprojects.RailsFileLocator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.rubyproject.RakeSupport;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigrateAction
extends SystemAction
implements ContextAwareAction {
    public String getName() {
        return NbBundle.getMessage(MigrateAction.class, (String)"LBL_rake_migrate");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false) : "Action should never be called without a context";
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    private static JMenu createMenu(RailsProject railsProject) {
        return new LazyMenu(railsProject);
    }

    static void buildMenu(JMenu jMenu, RailsProject railsProject) {
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"CurrentVersion"));
        jMenuItem.addActionListener(new MigrateMenuItemHandler(railsProject, -1L));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"Version0", (Object)0));
        jMenuItem.addActionListener(new MigrateMenuItemHandler(railsProject, 0L));
        jMenu.add(jMenuItem);
        Map<Long, String> map = MigrateAction.getVersions(railsProject);
        if (!map.isEmpty()) {
            jMenu.addSeparator();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.addAll(map.keySet());
            Collections.sort(arrayList);
            MigrateAction.buildMenu(railsProject, jMenu, 0, arrayList.size() - 1, arrayList, map);
        }
    }

    private static void buildMenu(RailsProject railsProject, JMenu jMenu, int n, int n2, List<Long> list, Map<Long, String> map) {
        int n3 = 20;
        int n4 = 15;
        if (n2 - n > n3) {
            int n5 = n2 - n;
            int n6 = (int)Math.sqrt(n5);
            if (n6 < n4) {
                n4 = n6;
            }
            int n7 = n5 / n4;
            if (n5 % n4 == 0) {
                --n4;
            }
            for (int i = 0; i <= n4; ++i) {
                int n8 = i * n7 + n;
                int n9 = (i + 1) * n7 - 1 + n;
                if (n8 > n2) {
                    return;
                }
                if (n9 > n2) {
                    n9 = n2;
                } else if (n9 == n2 - 1) {
                    n9 = n2;
                }
                if (n9 == n8) {
                    MigrateAction.buildMenu(railsProject, jMenu, n8, n9, list, map);
                    continue;
                }
                long l = list.get(n8);
                long l2 = list.get(n9);
                JMenu jMenu2 = new JMenu(NbBundle.getMessage(MigrateAction.class, (String)"VersionXtoY", (Object)Long.toString(l), (Object)Long.toString(l2)));
                MigrateAction.buildMenu(railsProject, jMenu2, n8, n9, list, map);
                jMenu.add(jMenu2);
            }
            return;
        }
        for (int i = n; i <= n2; ++i) {
            long l = list.get(i);
            String string = map.get(l);
            if (string == null) {
                string = "";
            }
            JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"VersionX", (Object)Long.toString(l), (Object)string));
            jMenuItem.addActionListener(new MigrateMenuItemHandler(railsProject, l));
            jMenu.add(jMenuItem);
        }
    }

    static Map<Long, String> getVersions(RailsProject railsProject) {
        FileObject fileObject = railsProject.getProjectDirectory();
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        FileObject fileObject2 = fileObject.getFileObject("db/migrate");
        if (fileObject2 == null) {
            return Collections.emptyMap();
        }
        for (FileObject fileObject3 : fileObject2.getChildren()) {
            String string;
            String string2 = fileObject3.getName();
            if (!fileObject3.getMIMEType().equals("text/x-ruby")) continue;
            if (string2.matches("^\\d\\d\\d_.*")) {
                try {
                    long l = Integer.parseInt(fileObject3.getName().substring(0, 3));
                    string = RubyUtils.underlinedNameToCamel((String)string2.substring(4));
                    hashMap.put(l, "- " + string);
                }
                catch (NumberFormatException numberFormatException) {
                    Exceptions.printStackTrace((Throwable)numberFormatException);
                }
                continue;
            }
            if (!string2.matches("^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d_.*")) continue;
            try {
                long l = Long.parseLong(fileObject3.getName().substring(0, 14));
                string = RubyUtils.underlinedNameToCamel((String)string2.substring(15));
                hashMap.put(l, "- " + string);
            }
            catch (NumberFormatException numberFormatException) {
                Exceptions.printStackTrace((Throwable)numberFormatException);
            }
        }
        return hashMap;
    }

    private static final class MigrateMenuItemHandler
    implements ActionListener,
    Runnable {
        private final RailsProject project;
        private final long version;

        public MigrateMenuItemHandler(RailsProject railsProject, long l) {
            this.project = railsProject;
            this.version = l;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)true)) {
                return;
            }
            LifecycleManager.getDefault().saveAll();
            RailsFileLocator railsFileLocator = new RailsFileLocator(Lookup.EMPTY, this.project);
            String string = NbBundle.getMessage(MigrateAction.class, (String)"Migration");
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            RakeSupport rakeSupport = new RakeSupport((Project)this.project);
            if (this.version == -1L) {
                rakeSupport.runRake(file, null, string, (FileLocator)railsFileLocator, true, false, new String[]{"db:migrate"});
            } else {
                rakeSupport.runRake(file, null, string, (FileLocator)railsFileLocator, true, false, new String[]{"db:migrate", "VERSION=" + Long.toString(this.version)});
            }
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final RailsProject project;
        private boolean initialized = false;

        public LazyMenu(RailsProject railsProject) {
            super(((MigrateAction)SystemAction.get(MigrateAction.class)).getName());
            this.project = railsProject;
        }

        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                this.initialized = true;
                super.removeAll();
                MigrateAction.buildMenu(this, this.project);
            }
            return super.getPopupMenu();
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final RailsProject project;

        public ContextAction(Lookup lookup) {
            super(((MigrateAction)SystemAction.get(MigrateAction.class)).getName());
            Collection collection = lookup.lookupAll(RailsProject.class);
            this.project = collection.size() == 1 ? (RailsProject)collection.iterator().next() : null;
            super.setEnabled(this.project != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return MigrateAction.createMenu(this.project);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public void setEnabled(boolean bl) {
            assert (false) : "No modifications to enablement status permitted";
        }
    }
}

