/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.modules.editor.hints.FixData;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Annotation;
import org.openide.util.WeakListeners;

public class ParseErrorAnnotation
extends Annotation
implements PropertyChangeListener {
    private final Severity severity;
    private final FixData fixes;
    private final String description;
    private final Position lineStart;
    private final AnnotationHolder holder;

    public ParseErrorAnnotation(Severity severity, FixData fixData, String string, Position position, AnnotationHolder annotationHolder) {
        this.severity = severity;
        this.fixes = fixData;
        this.description = string;
        this.lineStart = position;
        this.holder = annotationHolder;
        if (!fixData.isComputed()) {
            fixData.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)fixData));
        }
    }

    public String getAnnotationType() {
        boolean bl = this.fixes.isComputed() && !this.fixes.getFixes().isEmpty();
        switch (this.severity) {
            case ERROR: {
                if (bl) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_err_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_err";
            }
            case WARNING: {
                if (bl) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_warn_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_warn";
            }
            case VERIFIER: {
                if (bl) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_verifier_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_verifier";
            }
            case HINT: {
                if (bl) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_hint_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_hint";
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)this.severity));
    }

    public String getShortDescription() {
        return this.description;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fixes.isComputed()) {
            try {
                this.holder.detachAnnotation(this);
                this.holder.attachAnnotation(this.lineStart, this);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException);
            }
        }
    }

    public FixData getFixes() {
        return this.fixes;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLineNumber() {
        return this.holder.lineNumber(this.lineStart);
    }

    Severity getSeverity() {
        return this.severity;
    }
}

