/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.modeldiscovery.provider.ModelSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelFolder
implements FolderProperties {
    private String path;
    private ItemProperties.LanguageKind language;
    private Set<String> userIncludes = new LinkedHashSet<String>();
    private Set<String> systemIncludes = new LinkedHashSet<String>();
    private Map<String, String> userMacros = new HashMap<String, String>();
    private List<SourceFileProperties> files = new ArrayList<SourceFileProperties>();

    public ModelFolder(String string, SourceFileProperties sourceFileProperties) {
        this.path = string;
        this.language = sourceFileProperties.getLanguageKind();
        this.update(sourceFileProperties);
    }

    void update(SourceFileProperties sourceFileProperties) {
        this.files.add(sourceFileProperties);
        this.userIncludes.addAll(sourceFileProperties.getUserInludePaths());
        for (String string : sourceFileProperties.getUserInludePaths()) {
            this.userIncludes.add(ModelSource.convertRelativePathToAbsolute(sourceFileProperties, string));
        }
        this.systemIncludes.addAll(sourceFileProperties.getSystemInludePaths());
        this.userMacros.putAll(sourceFileProperties.getUserMacros());
    }

    public String getItemPath() {
        return this.path;
    }

    public List<SourceFileProperties> getFiles() {
        return this.files;
    }

    public List<String> getUserInludePaths() {
        return new ArrayList<String>(this.userIncludes);
    }

    public List<String> getSystemInludePaths() {
        return new ArrayList<String>(this.systemIncludes);
    }

    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    public Map<String, String> getSystemMacros() {
        return null;
    }

    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }
}

