/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.makeproject.api.compilers.CCCCompiler;
import org.netbeans.modules.cnd.makeproject.ui.options.CodeAssistancePanelController;
import org.netbeans.modules.cnd.makeproject.ui.options.ParserSettingsPanel;
import org.netbeans.modules.cnd.makeproject.ui.utils.ListEditorPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class PredefinedPanel
extends JPanel {
    private IncludesPanel includesPanel;
    private DefinitionsPanel definitionsPanel;
    private CCCCompiler compiler;
    private ParserSettingsPanel parserSettingsPanel;
    private static final int INSETS = 0;
    private static final double WEIGTH = 0.1;
    private JPanel includes;
    private JLabel jLabel1;
    private JPanel macros;
    private JButton resetButton;

    public PredefinedPanel(CCCCompiler cCCCompiler, ParserSettingsPanel parserSettingsPanel) {
        this.initComponents();
        this.compiler = cCCCompiler;
        this.parserSettingsPanel = parserSettingsPanel;
        this.updatePanels();
        this.resetButton.getAccessibleContext().setAccessibleDescription(PredefinedPanel.getString("RESET_BUTTON_AD"));
    }

    private void updatePanels() {
        List list = this.compiler.getSystemIncludeDirectories();
        Object[] objectArray = list.toArray(new String[list.size()]);
        if (this.includesPanel != null) {
            this.includes.remove(this.includesPanel);
        }
        this.includesPanel = new IncludesPanel(objectArray);
        this.includes.add(this.includesPanel);
        List list2 = this.compiler.getSystemPreprocessorSymbols();
        Object[] objectArray2 = list2.toArray(new String[list2.size()]);
        if (this.definitionsPanel != null) {
            this.macros.remove(this.definitionsPanel);
        }
        this.definitionsPanel = new DefinitionsPanel(objectArray2);
        this.macros.add(this.definitionsPanel);
    }

    public boolean save() {
        boolean bl = false;
        Vector vector = this.includesPanel.getListData();
        bl |= this.compiler.setSystemIncludeDirectories(vector);
        Vector vector2 = this.definitionsPanel.getListData();
        return bl |= this.compiler.setSystemPreprocessorSymbols(vector2);
    }

    public void update() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("update for PredefinedPanel " + this.compiler.getName());
        }
        this.updatePanels();
    }

    private void initComponents() {
        this.includes = new JPanel();
        this.macros = new JPanel();
        this.resetButton = new JButton();
        this.jLabel1 = new JLabel();
        this.includes.setLayout(new BorderLayout());
        this.includes.setBackground(new Color(255, 51, 51));
        this.macros.setLayout(new BorderLayout());
        this.macros.setBackground(new Color(204, 204, 0));
        this.resetButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("RESET_BUTTON_MN").charAt(0));
        this.resetButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("RESET_BUTTON_TXT"));
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PredefinedPanel.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("CODE_ASSISTANCE_COMMENT"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.includes, -1, 500, Short.MAX_VALUE).add(2, (Component)this.macros, -1, 500, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1, -1, 371, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.resetButton))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.includes, -1, 149, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.macros, -1, 134, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.resetButton).add((Component)this.jLabel1, -2, 34, -2))));
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        String string = PredefinedPanel.getString("RESET_QUESTION");
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, PredefinedPanel.getString("RESET_DIALOG_TITLE"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION) {
            this.compiler.resetSystemIncludesAndDefines();
            this.updatePanels();
            this.validate();
            this.repaint();
            this.parserSettingsPanel.fireFilesPropertiesChanged();
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(PredefinedPanel.class, (String)string);
    }

    boolean isChanged() {
        boolean bl = false;
        if (this.includesPanel != null) {
            bl |= this.includesPanel.isChanged();
        }
        if (this.definitionsPanel != null) {
            bl |= this.definitionsPanel.isChanged();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isChanged for PredefinedPanel " + this.compiler.getName() + " is " + bl);
        }
        return bl;
    }

    boolean isDataValid() {
        boolean bl = true;
        if (this.includesPanel != null) {
            bl &= this.includesPanel.isDataValid();
        }
        if (this.definitionsPanel != null) {
            bl &= this.definitionsPanel.isDataValid();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isDataValid for PredefinedPanel " + this.compiler.getName() + " is " + bl);
        }
        return bl;
    }

    void cancel() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("cancel for PredefinedPanel " + this.compiler.getName());
        }
    }

    private static class DefinitionsPanel
    extends ListEditorPanel {
        public DefinitionsPanel(Object[] objectArray) {
            super(objectArray);
            this.getDefaultButton().setVisible(false);
        }

        public Object addAction() {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDef"), PredefinedPanel.getString("AddDialogTitle"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            String string = inputLine.getInputText();
            if (string.length() != 0) {
                return string;
            }
            return null;
        }

        public String getListLabelText() {
            return PredefinedPanel.getString("MacroDefinitionsTxt");
        }

        public char getListLabelMnemonic() {
            return PredefinedPanel.getString("MacroDefinitionsMn").charAt(0);
        }

        public String getAddButtonText() {
            return PredefinedPanel.getString("AddButtonTxt");
        }

        public char getAddButtonMnemonics() {
            return PredefinedPanel.getString("MAddButtonMn").charAt(0);
        }

        public char getCopyButtonMnemonics() {
            return PredefinedPanel.getString("MCopyButtonMn").charAt(0);
        }

        public Object copyAction(Object object) {
            return new String((String)object);
        }

        public char getRenameButtonMnemonics() {
            return PredefinedPanel.getString("MditButtonMn").charAt(0);
        }

        public String getRenameButtonText() {
            return PredefinedPanel.getString("EditButtonTxt");
        }

        public void editAction(Object object) {
            String string = (String)object;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDef"), PredefinedPanel.getString("EditDialogTitle"));
            inputLine.setInputText(string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string2 = inputLine.getInputText();
            Vector vector = this.getListData();
            Object[] objectArray = this.getListData().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object) continue;
                vector.remove(i);
                vector.add(i, string2);
                break;
            }
        }

        public char getRemoveButtonMnemonics() {
            return PredefinedPanel.getString("MRemoveButtonMn").charAt(0);
        }

        public char getUpButtonMnemonics() {
            return PredefinedPanel.getString("MUpButtonMn").charAt(0);
        }

        public char getDownButtonMnemonics() {
            return PredefinedPanel.getString("MDownButtonMn").charAt(0);
        }
    }

    private static class IncludesPanel
    extends ListEditorPanel {
        public IncludesPanel(Object[] objectArray) {
            super(objectArray);
            this.getDefaultButton().setVisible(false);
        }

        public Object addAction() {
            FileChooser fileChooser;
            int n;
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = System.getProperty("user.home");
            }
            if ((n = (fileChooser = new FileChooser(PredefinedPanel.getString("SelectDirectoryTxt"), PredefinedPanel.getString("SelectTxt"), 1, null, string, true)).showOpenDialog((Component)this)) == 1) {
                return null;
            }
            String string2 = fileChooser.getSelectedFile().getPath();
            return string2;
        }

        public String getListLabelText() {
            return PredefinedPanel.getString("IncludeDirectoriesTxt");
        }

        public char getListLabelMnemonic() {
            return PredefinedPanel.getString("IncludeDirectoriesMn").charAt(0);
        }

        public String getAddButtonText() {
            return PredefinedPanel.getString("AddButtonTxt");
        }

        public char getAddButtonMnemonics() {
            return PredefinedPanel.getString("IAddButtonMn").charAt(0);
        }

        public char getCopyButtonMnemonics() {
            return PredefinedPanel.getString("ICopyButtonMn").charAt(0);
        }

        public Object copyAction(Object object) {
            return new String((String)object);
        }

        public String getRenameButtonText() {
            return PredefinedPanel.getString("EditButtonTxt");
        }

        public char getRenameButtonMnemonics() {
            return PredefinedPanel.getString("EditButtonMn").charAt(0);
        }

        public void editAction(Object object) {
            String string = (String)object;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDir"), PredefinedPanel.getString("EditDialogTitle"));
            inputLine.setInputText(string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string2 = inputLine.getInputText();
            Vector vector = this.getListData();
            Object[] objectArray = this.getListData().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object) continue;
                vector.remove(i);
                vector.add(i, string2);
                break;
            }
        }

        public char getRemoveButtonMnemonics() {
            return PredefinedPanel.getString("IRemoveButtonMn").charAt(0);
        }

        public char getUpButtonMnemonics() {
            return PredefinedPanel.getString("IUpButtonMn").charAt(0);
        }

        public char getDownButtonMnemonics() {
            return PredefinedPanel.getString("IDownButtonMn").charAt(0);
        }
    }
}

