/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.utils.AllFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.MacOSXExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.PeExecutableFileFilter;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class SelectExecutablePanel
extends JPanel {
    private JList exeList;
    private FileFilter elfExecutableFileFilter = ElfExecutableFileFilter.getInstance();
    private FileFilter exeExecutableFileFilter = PeExecutableFileFilter.getInstance();
    private FileFilter machOExecutableFileFilter = MacOSXExecutableFileFilter.getInstance();
    private DocumentListener documentListener;
    private DialogDescriptor dialogDescriptor;
    private MakeConfiguration conf;
    private JLabel ExecutableListLabel;
    private JButton browseButton;
    private JLabel errorLabel;
    private JLabel executableLabel;
    private JScrollPane executableList;
    private JTextField executableTextField;
    private JTextArea instructionsTextArea;
    private JList list;

    public SelectExecutablePanel(MakeConfiguration makeConfiguration) {
        this.conf = makeConfiguration;
        this.initComponents();
        this.instructionsTextArea.setBackground(this.getBackground());
        File file = new File(makeConfiguration.getMakefileConfiguration().getAbsBuildCommandWorkingDir());
        String[] stringArray = this.findAllExecutables(file);
        this.exeList = new JList<String>(stringArray);
        this.executableList.setViewportView(this.exeList);
        this.exeList.addListSelectionListener(new MyListSelectionListener());
        if (stringArray.length > 0) {
            this.exeList.setSelectedIndex(0);
        }
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SelectExecutablePanel.this.validateExe();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SelectExecutablePanel.this.validateExe();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SelectExecutablePanel.this.validateExe();
            }
        };
        this.executableTextField.getDocument().addDocumentListener(this.documentListener);
        this.setPreferredSize(new Dimension(600, 300));
        this.validateExe();
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
        this.validateExe();
    }

    private void validateExe() {
        String string = null;
        File file = new File(this.executableTextField.getText());
        if (this.executableTextField.getText().length() == 0) {
            string = SelectExecutablePanel.getString("NO_EXE_ERROR");
        } else if (!file.exists()) {
            string = SelectExecutablePanel.getString("EXE_DOESNT_EXISTS");
        } else if (file.isDirectory() || !this.elfExecutableFileFilter.accept(file) && !this.exeExecutableFileFilter.accept(file) && !this.machOExecutableFileFilter.accept(file)) {
            string = SelectExecutablePanel.getString("FILE_NOT_AN_EXECUTABLE");
        }
        if (string != null) {
            this.errorLabel.setText(string);
            if (this.dialogDescriptor != null) {
                this.dialogDescriptor.setValid(false);
            }
        } else {
            this.errorLabel.setText(" ");
            if (this.dialogDescriptor != null) {
                this.dialogDescriptor.setValid(true);
            }
        }
    }

    public String getExecutable() {
        return this.executableTextField.getText();
    }

    private String[] findAllExecutables(File file) {
        ArrayList arrayList = new ArrayList();
        this.addExecutables(file, arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void addExecutables(File file, ArrayList arrayList) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                if (fileArray[i].getName().equals("SCCS")) continue;
                this.addExecutables(fileArray[i], arrayList);
                continue;
            }
            if (AllFileFilter.getInstance().accept(fileArray[i])) continue;
            if (this.conf.getPlatform().getValue() == 3) {
                if (!this.exeExecutableFileFilter.accept(fileArray[i])) continue;
                arrayList.add(fileArray[i].getPath());
                continue;
            }
            if (this.conf.getPlatform().getValue() == 4) {
                if (!this.machOExecutableFileFilter.accept(fileArray[i])) continue;
                arrayList.add(fileArray[i].getPath());
                continue;
            }
            if (!this.elfExecutableFileFilter.accept(fileArray[i])) continue;
            arrayList.add(fileArray[i].getPath());
        }
    }

    private void initComponents() {
        this.instructionsTextArea = new JTextArea();
        this.ExecutableListLabel = new JLabel();
        this.executableList = new JScrollPane();
        this.list = new JList();
        this.executableLabel = new JLabel();
        this.executableTextField = new JTextField();
        this.browseButton = new JButton();
        this.errorLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/Bundle").getString("GUIDANCE_TEXT"));
        this.instructionsTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.ExecutableListLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/Bundle").getString("LIST_LABEL_MN").charAt(0));
        this.ExecutableListLabel.setLabelFor(this.executableList);
        this.ExecutableListLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/Bundle").getString("LIST_LABEL_TEXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.add((Component)this.ExecutableListLabel, gridBagConstraints);
        this.executableList.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.executableList, gridBagConstraints);
        this.executableLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/Bundle").getString("EXECUTABLE_MN").charAt(0));
        this.executableLabel.setLabelFor(this.executableTextField);
        this.executableLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/Bundle").getString("EXECUTABLE_TEXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.add((Component)this.executableLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.executableTextField, gridBagConstraints);
        this.browseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/Bundle").getString("BROWSE_BUTTON_MN").charAt(0));
        this.browseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/Bundle").getString("BROWSE_BUTTON_TEXT"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectExecutablePanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 12);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.errorLabel.setForeground(new Color(255, 51, 51));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 0);
        this.add((Component)this.errorLabel, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.executableTextField.getText().length() > 0 ? this.executableTextField.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileFilter[] fileFilterArray = this.conf.getPlatform().getValue() == 3 ? new FileFilter[]{PeExecutableFileFilter.getInstance()} : (this.conf.getPlatform().getValue() == 4 ? new FileFilter[]{MacOSXExecutableFileFilter.getInstance()} : new FileFilter[]{ElfExecutableFileFilter.getInstance()});
        FileChooser fileChooser = new FileChooser(SelectExecutablePanel.getString("CHOOSER_TITLE_TXT"), SelectExecutablePanel.getString("CHOOSER_BUTTON_TXT"), 0, fileFilterArray, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        String string2 = FilePathAdaptor.normalize(fileChooser.getSelectedFile().getPath());
        this.executableTextField.setText(string2);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(SelectExecutablePanel.class, (String)string);
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            if (!listSelectionEvent.getValueIsAdjusting() && (n = SelectExecutablePanel.this.exeList.getSelectedIndex()) >= 0) {
                SelectExecutablePanel.this.executableTextField.setText((String)SelectExecutablePanel.this.exeList.getSelectedValue());
                SelectExecutablePanel.this.validateExe();
            }
        }
    }
}

