/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ui.MakeArtifactChooser;
import org.netbeans.modules.cnd.makeproject.configurations.ui.TableEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RequiredProjectsPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    private Project project;
    private MakeConfiguration conf;
    private MyListEditorPanel myListEditorPanel;
    private String baseDir;
    private PropertyEditorSupport editor;
    private JButton addProjectButton;
    private JButton addStandardLibraryButton;
    private JButton addLibraryButton;
    private JButton addLibraryFileButton;
    private JButton addLibraryOption;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JPanel outerPanel;
    private static ResourceBundle bundle;

    public RequiredProjectsPanel(Project project, MakeConfiguration makeConfiguration, String string, Object[] objectArray, PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
        this.project = project;
        this.conf = makeConfiguration;
        this.baseDir = string;
        this.editor = propertyEditorSupport;
        this.initComponents();
        this.addProjectButton = new JButton(RequiredProjectsPanel.getString("ADD_PROJECTS_BUTTON_TXT"));
        this.addProjectButton.setToolTipText(RequiredProjectsPanel.getString("ADD_PROJECTS_BUTTON_TT"));
        this.addProjectButton.setMnemonic(RequiredProjectsPanel.getString("ADD_PROJECTS_BUTTON_MN").charAt(0));
        JButton[] jButtonArray = new JButton[]{this.addProjectButton};
        this.myListEditorPanel = new MyListEditorPanel(objectArray, jButtonArray);
        this.addProjectButton.addActionListener(new AddProjectButtonAction());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.outerPanel.add((Component)this.myListEditorPanel, gridBagConstraints);
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.setPreferredSize(new Dimension(700, 350));
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setInstructionsText(String string) {
        this.instructionsTextArea.setText(string);
    }

    public void setListData(Object[] objectArray) {
        this.myListEditorPanel.setListData(objectArray);
    }

    public Vector getListData() {
        return this.myListEditorPanel.getListData();
    }

    private Object getPropertyValue() throws IllegalStateException {
        return new ArrayList(this.getListData());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("RequiredProjects");
    }

    private void initComponents() {
        this.outerPanel = new JPanel();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(323, 223));
        this.outerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.outerPanel, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(RequiredProjectsPanel.class);
        }
        return bundle.getString(string);
    }

    class AddProjectButtonAction
    implements ActionListener {
        AddProjectButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MakeArtifact[] makeArtifactArray = MakeArtifactChooser.showDialog(MakeArtifactChooser.ArtifactType.PROJECT, RequiredProjectsPanel.this.project, RequiredProjectsPanel.this.myListEditorPanel);
            if (makeArtifactArray != null) {
                for (int i = 0; i < makeArtifactArray.length; ++i) {
                    String string;
                    String string2;
                    if (PathPanel.getMode() == 0) {
                        string2 = IpeUtils.toAbsoluteOrRelativePath((String)RequiredProjectsPanel.this.baseDir, (String)makeArtifactArray[i].getProjectLocation());
                        string = IpeUtils.toAbsoluteOrRelativePath((String)RequiredProjectsPanel.this.baseDir, (String)makeArtifactArray[i].getWorkingDirectory());
                    } else if (PathPanel.getMode() == 1) {
                        string2 = IpeUtils.toRelativePath((String)RequiredProjectsPanel.this.baseDir, (String)makeArtifactArray[i].getProjectLocation());
                        string = IpeUtils.toRelativePath((String)RequiredProjectsPanel.this.baseDir, (String)makeArtifactArray[i].getWorkingDirectory());
                    } else {
                        string2 = makeArtifactArray[i].getProjectLocation();
                        string = makeArtifactArray[i].getWorkingDirectory();
                    }
                    string2 = FilePathAdaptor.normalize(string2);
                    string = FilePathAdaptor.normalize(string);
                    makeArtifactArray[i].setProjectLocation(string2);
                    makeArtifactArray[i].setWorkingDirectory(string);
                    makeArtifactArray[i].setBuild(false);
                    RequiredProjectsPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.ProjectItem(makeArtifactArray[i]));
                }
            }
        }
    }

    private class MyListEditorPanel
    extends TableEditorPanel {
        public MyListEditorPanel(Object[] objectArray, JButton[] jButtonArray) {
            super(objectArray, jButtonArray, RequiredProjectsPanel.this.baseDir);
            this.getAddButton().setVisible(false);
            this.getCopyButton().setVisible(false);
            this.getEditButton().setVisible(false);
            this.getDefaultButton().setVisible(false);
        }

        public String getListLabelText() {
            return RequiredProjectsPanel.getString("PROJECTS_TXT");
        }

        public char getListLabelMnemonic() {
            return RequiredProjectsPanel.getString("PROJECTS_MN").charAt(0);
        }
    }
}

