/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.remote;

import org.netbeans.modules.cnd.makeproject.api.remote.FilePathMapper;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class FilePathAdaptor {
    public static String mapToRemote(String string) {
        FilePathMapper filePathMapper = FilePathAdaptor.getConverting();
        return filePathMapper.mapToRemote(string);
    }

    public static String mapToLocal(String string) {
        FilePathMapper filePathMapper = FilePathAdaptor.getConverting();
        return filePathMapper.mapToLocal(string);
    }

    public static String normalize(String string) {
        FilePathMapper filePathMapper = FilePathAdaptor.getConverting();
        return filePathMapper.normalize(string);
    }

    public static String naturalize(String string) {
        FilePathMapper filePathMapper = FilePathAdaptor.getConverting();
        return filePathMapper.naturalize(string);
    }

    private static FilePathMapper getConverting() {
        FilePathMapper filePathMapper = (FilePathMapper)Lookup.getDefault().lookup(FilePathMapper.class);
        return filePathMapper == null ? FilePathMapperDefault.DEFAULT : filePathMapper;
    }

    private static class FilePathMapperDefault
    implements FilePathMapper {
        public static final FilePathMapper DEFAULT = new FilePathMapperDefault();

        private FilePathMapperDefault() {
        }

        public String mapToRemote(String string) {
            return string;
        }

        public String mapToLocal(String string) {
            return string;
        }

        public String normalize(String string) {
            return string.replaceAll("\\\\", "/");
        }

        public String naturalize(String string) {
            if (Utilities.isUnix()) {
                return string.replaceAll("\\\\", "/");
            }
            if (Utilities.isWindows()) {
                return string.replaceAll("/", "\\\\");
            }
            return string;
        }
    }
}

