/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Configuration
implements ProjectConfiguration {
    private String baseDir;
    private String name;
    private boolean defaultConfiguration;
    private PropertyChangeSupport pcs = null;
    private Map<String, ConfigurationAuxObject> auxObjectsMap = Collections.synchronizedSortedMap(new TreeMap());
    private Configuration cloneOf;

    public Configuration(String string, String string2) {
        this.baseDir = string;
        this.name = string2;
        this.defaultConfiguration = false;
        this.pcs = new PropertyChangeSupport(this);
        ConfigurationAuxObjectProvider[] configurationAuxObjectProviderArray = ConfigurationDescriptorProvider.getAuxObjectProviders();
        for (int i = 0; i < configurationAuxObjectProviderArray.length; ++i) {
            ConfigurationAuxObject configurationAuxObject = configurationAuxObjectProviderArray[i].factoryCreate(string, this.pcs);
            configurationAuxObject.initialize();
            String string3 = configurationAuxObject.getId();
            if (this.auxObjectsMap.containsKey(string3)) {
                System.err.println("Init duplicated ConfigurationAuxObject id=" + string3);
            }
            this.auxObjectsMap.put(string3, configurationAuxObject);
        }
    }

    public void setCloneOf(Configuration configuration) {
        this.cloneOf = configuration;
    }

    public Configuration getCloneOf() {
        return this.cloneOf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getBaseDir() {
        return FilePathAdaptor.mapToRemote(this.baseDir);
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public boolean isDefault() {
        return this.defaultConfiguration;
    }

    public void setDefault(boolean bl) {
        this.defaultConfiguration = bl;
    }

    public String toString() {
        if (this.isDefault()) {
            return this.getDisplayName() + " " + Configuration.getString("ActiveTxt");
        }
        return this.getDisplayName();
    }

    public void addAuxObject(ConfigurationAuxObject configurationAuxObject) {
        String string = configurationAuxObject.getId();
        if (this.auxObjectsMap.containsKey(string)) {
            System.err.println("Add duplicated ConfigurationAuxObject id=" + string);
        }
        this.auxObjectsMap.put(string, configurationAuxObject);
    }

    public void removeAuxObject(ConfigurationAuxObject configurationAuxObject) {
        this.auxObjectsMap.remove(configurationAuxObject.getId());
    }

    public void removeAuxObject(String string) {
        this.auxObjectsMap.remove(string);
    }

    public ConfigurationAuxObject getAuxObject(String string) {
        return this.auxObjectsMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationAuxObject[] getAuxObjects() {
        ArrayList<ConfigurationAuxObject> arrayList;
        Map<String, ConfigurationAuxObject> map = this.auxObjectsMap;
        synchronized (map) {
            arrayList = new ArrayList<ConfigurationAuxObject>(this.auxObjectsMap.values());
        }
        return arrayList.toArray(new ConfigurationAuxObject[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuxObjects(List<ConfigurationAuxObject> list) {
        Map<String, ConfigurationAuxObject> map = this.auxObjectsMap;
        synchronized (map) {
            this.auxObjectsMap.clear();
            for (ConfigurationAuxObject configurationAuxObject : list) {
                this.auxObjectsMap.put(configurationAuxObject.getId(), configurationAuxObject);
            }
        }
    }

    public abstract Configuration cloneConf();

    public abstract void assign(Configuration var1);

    public abstract Configuration copy();

    public void cloneConf(Configuration configuration) {
        configuration.setDefault(this.isDefault());
    }

    public RunProfile getProfile() {
        return (RunProfile)this.getAuxObject("runprofile");
    }

    private static String getString(String string) {
        return NbBundle.getMessage(Configuration.class, (String)string);
    }
}

