/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CompilerSet2Configuration {
    private StringConfiguration compilerSetName;
    private String flavor;
    private boolean dirty = false;

    public CompilerSet2Configuration() {
        String string = CppSettings.getDefault().getCompilerSetName();
        if (string == null || string.length() == 0) {
            string = CompilerSetManager.getDefault().getCompilerSetNames().size() > 0 ? CompilerSetManager.getDefault().getCompilerSet(0).getName() : (Utilities.getOperatingSystem() == 8 ? "Sun" : "GNU");
        }
        this.compilerSetName = new StringConfiguration(null, string);
        this.flavor = null;
    }

    public StringConfiguration getCompilerSetName() {
        return this.compilerSetName;
    }

    public void setCompilerSetName(StringConfiguration stringConfiguration) {
        this.compilerSetName = stringConfiguration;
    }

    public void setValue(String string) {
        if (!this.getOption().equals(string)) {
            this.setValue(string, null);
        }
    }

    public void setNameAndFlavor(String string, int n) {
        String string2;
        String string3;
        int n2 = string.indexOf("|");
        if (n2 > 0) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = string;
            string2 = string;
        }
        this.setValue(CompilerSet.CompilerFlavor.mapOldToNew((String)string3, (int)n), CompilerSet.CompilerFlavor.mapOldToNew((String)string2, (int)n));
    }

    public void setValue(String string, String string2) {
        this.getCompilerSetName().setValue(string);
        this.setFlavor(string2);
    }

    public int getValue() {
        String string = this.getCompilerSetName().getValue();
        if (string != null) {
            int n = 0;
            for (String string2 : CompilerSetManager.getDefault().getCompilerSetNames()) {
                if (string.equals(string2)) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    public String getDisplayName(boolean bl) {
        CompilerSet compilerSet = null;
        String string = null;
        if (compilerSet == null) {
            compilerSet = CompilerSetManager.getDefault().getCompilerSet(this.getCompilerSetName().getValue());
        }
        if (compilerSet != null) {
            string = compilerSet.getName();
        }
        if (string != null) {
            return string;
        }
        if (bl) {
            return this.createNotFoundName(this.getCompilerSetName().getValue());
        }
        return "";
    }

    public String createNotFoundName(String string) {
        return string + " - " + CompilerSet2Configuration.getString("NOT_FOUND");
    }

    public void assign(CompilerSet2Configuration compilerSet2Configuration) {
        String string = this.getCompilerSetName().getValue();
        String string2 = compilerSet2Configuration.getCompilerSetName().getValue();
        this.setDirty(string2 != null && !string2.equals(string));
        this.setValue(compilerSet2Configuration.getCompilerSetName().getValue());
    }

    public Object clone() {
        CompilerSet2Configuration compilerSet2Configuration = new CompilerSet2Configuration();
        compilerSet2Configuration.setCompilerSetName((StringConfiguration)this.getCompilerSetName().clone());
        return compilerSet2Configuration;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public boolean isValid() {
        return CompilerSetManager.getDefault().getCompilerSet(this.getCompilerSetName().getValue()) != null;
    }

    public void setValid() {
    }

    public String getOldName() {
        return this.getCompilerSetName().getValue();
    }

    public String getOption() {
        return this.getCompilerSetName().getValue();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(CompilerSet2Configuration.class, (String)string);
    }

    public String getNameAndFlavor() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getOption());
        if (this.getFlavor() != null) {
            stringBuilder.append("|");
            stringBuilder.append(this.getFlavor());
        }
        return stringBuilder.toString();
    }

    public String getFlavor() {
        CompilerSet compilerSet;
        if (this.flavor == null && (compilerSet = CompilerSetManager.getDefault().getCompilerSet(this.getOption())) != null) {
            this.flavor = compilerSet.getCompilerFlavor().toString();
        }
        return this.flavor;
    }

    public void setFlavor(String string) {
        this.flavor = string;
    }
}

