/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.compilers.CCCCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class CCCompilerConfiguration
extends CCCCompilerConfiguration
implements AllOptionsProvider {
    public CCCompilerConfiguration(String string, CCCompilerConfiguration cCCompilerConfiguration) {
        super(string, cCCompilerConfiguration);
    }

    public void assign(CCCompilerConfiguration cCCompilerConfiguration) {
        super.assign(cCCompilerConfiguration);
    }

    public Object clone() {
        CCCompilerConfiguration cCCompilerConfiguration = new CCCompilerConfiguration(this.getBaseDir(), (CCCompilerConfiguration)this.getMaster());
        cCCompilerConfiguration.setDevelopmentMode((IntConfiguration)this.getDevelopmentMode().clone());
        cCCompilerConfiguration.setWarningLevel((IntConfiguration)this.getWarningLevel().clone());
        cCCompilerConfiguration.setMTLevel((IntConfiguration)this.getMTLevel().clone());
        cCCompilerConfiguration.setSixtyfourBits((IntConfiguration)this.getSixtyfourBits().clone());
        cCCompilerConfiguration.setStrip((BooleanConfiguration)this.getStrip().clone());
        cCCompilerConfiguration.setAdditionalDependencies((StringConfiguration)this.getAdditionalDependencies().clone());
        cCCompilerConfiguration.setTool((StringConfiguration)this.getTool().clone());
        cCCompilerConfiguration.setCommandLineConfiguration((OptionsConfiguration)this.getCommandLineConfiguration().clone());
        cCCompilerConfiguration.setMTLevel((IntConfiguration)this.getMTLevel().clone());
        cCCompilerConfiguration.setLibraryLevel((IntConfiguration)this.getLibraryLevel().clone());
        cCCompilerConfiguration.setStandardsEvolution((IntConfiguration)this.getStandardsEvolution().clone());
        cCCompilerConfiguration.setLanguageExt((IntConfiguration)this.getLanguageExt().clone());
        cCCompilerConfiguration.setIncludeDirectories((VectorConfiguration)this.getIncludeDirectories().clone());
        cCCompilerConfiguration.setInheritIncludes((BooleanConfiguration)this.getInheritIncludes().clone());
        cCCompilerConfiguration.setPreprocessorConfiguration((VectorConfiguration)this.getPreprocessorConfiguration().clone());
        cCCompilerConfiguration.setInheritPreprocessor((BooleanConfiguration)this.getInheritPreprocessor().clone());
        return cCCompilerConfiguration;
    }

    public String getOptions(BasicCompiler basicCompiler) {
        String string = "$(COMPILE.cc) ";
        string = string + this.getAllOptions2(basicCompiler) + " ";
        string = string + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getCCFlagsBasic(BasicCompiler basicCompiler) {
        CCCCompiler cCCCompiler = (CCCCompiler)basicCompiler;
        String string = "";
        string = string + cCCCompiler.getMTLevelOptions(this.getMTLevel().getValue()) + " ";
        string = string + cCCCompiler.getLibraryLevelOptions(this.getLibraryLevel().getValue()) + " ";
        string = string + cCCCompiler.getStandardsEvolutionOptions(this.getStandardsEvolution().getValue()) + " ";
        string = string + cCCCompiler.getLanguageExtOptions(this.getLanguageExt().getValue()) + " ";
        string = string + basicCompiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == DEVELOPMENT_MODE_TEST) {
            string = string + basicCompiler.getDevelopmentModeOptions(DEVELOPMENT_MODE_TEST);
        }
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getCCFlags(BasicCompiler basicCompiler) {
        String string = this.getCCFlagsBasic(basicCompiler) + " ";
        string = string + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getAllOptions(BasicCompiler basicCompiler) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getCCFlagsBasic(basicCompiler));
        stringBuilder.append(" ");
        for (CCCompilerConfiguration cCCompilerConfiguration = (CCCompilerConfiguration)this.getMaster(); cCCompilerConfiguration != null; cCCompilerConfiguration = (CCCompilerConfiguration)cCCompilerConfiguration.getMaster()) {
            stringBuilder.append(cCCompilerConfiguration.getCommandLineConfiguration().getValue());
            stringBuilder.append(" ");
        }
        stringBuilder.append(this.getAllOptions2(basicCompiler));
        stringBuilder.append(" ");
        return CppUtils.reformatWhitespaces((String)stringBuilder.toString());
    }

    public String getAllOptions2(BasicCompiler basicCompiler) {
        String string = "";
        if (this.getDevelopmentMode().getValue() != DEVELOPMENT_MODE_TEST) {
            string = string + basicCompiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        }
        string = string + basicCompiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        string = string + basicCompiler.getStripOption(this.getStrip().getValue()) + " ";
        string = string + this.getPreprocessorOptions();
        string = string + this.getIncludeDirectoriesOptions();
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getPreprocessorOptions() {
        CCCompilerConfiguration cCCompilerConfiguration = (CCCompilerConfiguration)this.getMaster();
        StringBuilder stringBuilder = new StringBuilder(this.getPreprocessorConfiguration().getOption("-D") + " ");
        while (cCCompilerConfiguration != null && this.getInheritPreprocessor().getValue()) {
            stringBuilder.append(cCCompilerConfiguration.getPreprocessorConfiguration().getOption("-D") + " ");
            if (cCCompilerConfiguration.getInheritPreprocessor().getValue()) {
                cCCompilerConfiguration = (CCCompilerConfiguration)cCCompilerConfiguration.getMaster();
                continue;
            }
            cCCompilerConfiguration = null;
        }
        return stringBuilder.toString();
    }

    public String getIncludeDirectoriesOptions() {
        CCCompilerConfiguration cCCompilerConfiguration = (CCCompilerConfiguration)this.getMaster();
        StringBuilder stringBuilder = new StringBuilder(this.getIncludeDirectories().getOption("-I") + " ");
        while (cCCompilerConfiguration != null && this.getInheritIncludes().getValue()) {
            stringBuilder.append(cCCompilerConfiguration.getIncludeDirectories().getOption("-I") + " ");
            if (cCCompilerConfiguration.getInheritIncludes().getValue()) {
                cCCompilerConfiguration = (CCCompilerConfiguration)cCCompilerConfiguration.getMaster();
                continue;
            }
            cCCompilerConfiguration = null;
        }
        return stringBuilder.toString();
    }

    public Sheet getSheet(MakeConfiguration makeConfiguration, Folder folder) {
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = CompilerSetManager.getDefault().getCompilerSet(makeConfiguration.getCompilerSet().getValue());
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(Tool.CCCompiler);
        sheet.put(this.getSet());
        if (makeConfiguration.isCompileConfiguration() && folder == null) {
            Sheet.Set set;
            sheet.put(this.getBasicSet());
            if (makeConfiguration.getCompilerSet().getValue() == CompilerSet.CompilerFlavor.Sun.ordinal()) {
                set = new Sheet.Set();
                set.setName("OtherOptions");
                set.setDisplayName(CCCompilerConfiguration.getString("OtherOptionsTxt"));
                set.setShortDescription(CCCompilerConfiguration.getString("OtherOptionsHint"));
                set.put((Node.Property)new IntNodeProp(this.getMTLevel(), this.getMaster() == null, "MultithreadingLevel", CCCompilerConfiguration.getString("MultithreadingLevelTxt"), CCCompilerConfiguration.getString("MultithreadingLevelHint")));
                set.put((Node.Property)new IntNodeProp(this.getLibraryLevel(), this.getMaster() == null, "LibraryLevel", CCCompilerConfiguration.getString("LibraryLevelTxt"), CCCompilerConfiguration.getString("LibraryLevelHint")));
                set.put((Node.Property)new IntNodeProp(this.getStandardsEvolution(), this.getMaster() == null, "StandardsEvolution", CCCompilerConfiguration.getString("StandardsEvolutionTxt"), CCCompilerConfiguration.getString("StandardsEvolutionHint")));
                set.put((Node.Property)new IntNodeProp(this.getLanguageExt(), this.getMaster() == null, "LanguageExtensions", CCCompilerConfiguration.getString("LanguageExtensionsTxt"), CCCompilerConfiguration.getString("LanguageExtensionsHint")));
                sheet.put(set);
            }
            if (this.getMaster() != null) {
                sheet.put(this.getInputSet());
            }
            set = new Sheet.Set();
            set.setName("Tool");
            set.setDisplayName(CCCompilerConfiguration.getString("ToolTxt1"));
            set.setShortDescription(CCCompilerConfiguration.getString("ToolHint1"));
            set.put((Node.Property)new StringNodeProp(this.getTool(), basicCompiler.getName(), false, "Tool", CCCompilerConfiguration.getString("ToolTxt2"), CCCompilerConfiguration.getString("ToolHint2")));
            sheet.put(set);
            String[] stringArray = new String[]{CCCompilerConfiguration.getString("AdditionalOptionsTxt1"), CCCompilerConfiguration.getString("AdditionalOptionsHint"), CCCompilerConfiguration.getString("AdditionalOptionsTxt2"), CCCompilerConfiguration.getString("AllOptionsTxt")};
            Sheet.Set set2 = new Sheet.Set();
            set2.setName("CommandLine");
            set2.setDisplayName(CCCompilerConfiguration.getString("CommandLineTxt"));
            set2.setShortDescription(CCCompilerConfiguration.getString("CommandLineHint"));
            set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, basicCompiler, null, stringArray));
            sheet.put(set2);
        }
        return sheet;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(CCCompilerConfiguration.class, (String)string);
    }
}

