/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.compilers.SunCCCCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.openide.ErrorManager;

public class SunCCCompiler
extends SunCCCCompiler {
    private static final String compilerStderrCommand = " -xdryrun -E";
    private static final String compilerStderrCommand2 = " -xdumpmacros=defs,sys -E";
    private static final String[] DEVELOPMENT_MODE_OPTIONS = new String[]{"", "-g", "-g0 -xO3 -xhwcprof", "-xprofile=tcov +d -xinline=", "-g0 -xO2", "-xO3", "-xO5 -xipo=1 -xdepend -fsimple=1 -xlibmil -xlibmopt -xvector -xbuiltin -sync_stdio=no -xalias_level=simple"};
    private static final String[] WARNING_LEVEL_OPTIONS = new String[]{"-w", "", "+w", "-xwe"};
    private static final String[] LIBRARY_LEVEL_OPTIONS = new String[]{"-library=no%Cstd,no%Crun -filt=no%stdlib", "-library=no%Cstd -filt=no%stdlib", "-library=iostream,no%Cstd -filt=no%stdlib", "", "-library=stlport4,no%Cstd"};
    private static final String[] MT_LEVEL_OPTIONS = new String[]{"", "-mt", "-xautopar -xvector -xreduction -xloopinfo", "-xopenmp"};
    private static final String[] STANDARD_OPTIONS = new String[]{"-compat", "-features=no%localfor,no%extinl,no%conststrings", "", "-features=no%anachronisms,no%transitions,tmplife"};
    private static final String[] LANGUAGE_EXT_OPTIONS = new String[]{"-features=no%longlong", "", "-features=extensions,tmplrefstatic,iddollar"};

    public SunCCCompiler(CompilerSet.CompilerFlavor compilerFlavor, int n, String string, String string2, String string3) {
        super(compilerFlavor, n, string, string2, string3);
    }

    public SunCCCompiler createCopy() {
        SunCCCompiler sunCCCompiler = new SunCCCompiler(this.getFlavor(), this.getKind(), "", this.getDisplayName(), this.getPath());
        sunCCCompiler.setName(this.getName());
        return sunCCCompiler;
    }

    public String getDevelopmentModeOptions(int n) {
        return DEVELOPMENT_MODE_OPTIONS[n];
    }

    public String getWarningLevelOptions(int n) {
        if (n < WARNING_LEVEL_OPTIONS.length) {
            return WARNING_LEVEL_OPTIONS[n];
        }
        return "";
    }

    public String getSixtyfourBitsOption(int n) {
        if (this.getFlavor() == CompilerSet.CompilerFlavor.Sun12) {
            if (n == BasicCompilerConfiguration.BITS_DEFAULT) {
                return "";
            }
            if (n == BasicCompilerConfiguration.BITS_32) {
                return "-m32";
            }
            if (n == BasicCompilerConfiguration.BITS_64) {
                return "-m64";
            }
            return "";
        }
        if (n == BasicCompilerConfiguration.BITS_DEFAULT) {
            return "";
        }
        if (n == BasicCompilerConfiguration.BITS_32) {
            return "";
        }
        if (n == BasicCompilerConfiguration.BITS_64) {
            return "-xarch=generic64";
        }
        return "";
    }

    public String getStripOption(boolean bl) {
        return bl ? "-s" : "";
    }

    public String getMTLevelOptions(int n) {
        return MT_LEVEL_OPTIONS[n];
    }

    public String getLibraryLevelOptions(int n) {
        return LIBRARY_LEVEL_OPTIONS[n];
    }

    public String getStandardsEvolutionOptions(int n) {
        return STANDARD_OPTIONS[n];
    }

    public String getLanguageExtOptions(int n) {
        return LANGUAGE_EXT_OPTIONS[n];
    }

    protected void parseCompilerOutput(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                int n2 = string.indexOf("-I");
                while (n2 > 0) {
                    int n3 = string.indexOf(" ", n2 + 1);
                    String string2 = n3 > 0 ? string.substring(n2 + 2, n3) : string.substring(n2 + 2);
                    if (!string2.equals("-xbuiltin")) {
                        this.systemIncludeDirectoriesList.addUnique(this.normalizePath(string2));
                    }
                    if (string2.endsWith("Cstd")) {
                        this.systemIncludeDirectoriesList.addUnique(this.normalizePath(string2.substring(0, string2.length() - 4) + "std"));
                    }
                    if (n3 <= 0) break;
                    n2 = string.indexOf("-I", n3);
                }
                this.parseUserMacros(string, this.systemPreprocessorSymbolsList);
                if (!string.startsWith("#define ") || (n = string.indexOf(32, 8)) <= 0) continue;
                String string3 = string.substring(8, n) + "=" + string.substring(n + 1);
                this.systemPreprocessorSymbolsList.add(string3);
            }
            inputStream.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
        }
    }

    private void dumpLists() {
        int n;
        System.out.println("==================================" + this.getDisplayName());
        for (n = 0; n < this.systemIncludeDirectoriesList.size(); ++n) {
            System.out.println("-I" + this.systemIncludeDirectoriesList.get(n));
        }
        for (n = 0; n < this.systemPreprocessorSymbolsList.size(); ++n) {
            System.out.println("-D" + this.systemPreprocessorSymbolsList.get(n));
        }
    }

    protected String getDefaultPath() {
        return "CC";
    }

    protected String getCompilerStderrCommand() {
        return compilerStderrCommand;
    }

    protected String getCompilerStderrCommand2() {
        return compilerStderrCommand2;
    }
}

